/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.gdal;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.reflect.Array;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.HashSet;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.geometry.wrapper.Capability;
import org.apache.sis.geometry.wrapper.Dimensions;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.GeometryType;
import org.apache.sis.storage.ConcurrentReadException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.gdal.FeatureLayer;
import org.apache.sis.storage.gdal.FieldAccessor;
import org.apache.sis.storage.gdal.GDAL;
import org.apache.sis.storage.gdal.GDALStore;
import org.apache.sis.storage.gdal.OGR;
import org.apache.sis.storage.panama.Resources;
import org.apache.sis.util.internal.shared.Numerics;

final class FeatureIterator
implements Spliterator<AbstractFeature>,
Runnable {
    private static final int LINEAR_RING = 101;
    private final FeatureLayer layer;
    private final long count;
    private Arena arena;
    private MemorySegment buffer;
    private MemorySegment month;
    private MemorySegment day;
    private MemorySegment hour;
    private MemorySegment minute;
    private MemorySegment second;
    private MemorySegment timezone;
    private final Set<String> unsupportedTypes;
    private boolean initialized;

    FeatureIterator(FeatureLayer layer) throws DataStoreException {
        this.layer = layer;
        OGR ogr = layer.OGR();
        try {
            this.count = ogr.getFeatureCount.invokeExact(layer.handle, 0);
        }
        catch (Throwable e) {
            throw GDAL.propagate(e);
        }
        this.unsupportedTypes = new HashSet<String>();
    }

    private void initialize(OGR ogr) throws Throwable {
        assert (Thread.holdsLock((Object)this.layer.store));
        if (this.layer.iterationInProgress != null) {
            throw new ConcurrentReadException(Resources.forLocale(this.layer.store.getLocale()).getString((short)8));
        }
        this.initialized = true;
        int bufferSize = 0;
        for (FieldAccessor<?> field : this.layer.fields) {
            bufferSize = Math.max(bufferSize, field.bufferSize());
        }
        if (bufferSize >= 4) {
            this.arena = this.layer.store.changeArena(this.arena, true);
            this.buffer = this.arena.allocate(bufferSize);
            this.sliceBuffers();
        }
        this.layer.iterationInProgress = this;
        ogr.resetReading.invoke(this.layer.handle);
    }

    private void sliceBuffers() {
        if (this.buffer.byteSize() > 4L) {
            int i = 1;
            while (true) {
                MemorySegment s = this.buffer.asSlice((long)(i * 4), 1L);
                switch (i) {
                    default: {
                        throw new AssertionError(i);
                    }
                    case 1: {
                        this.month = s;
                        break;
                    }
                    case 2: {
                        this.day = s;
                        break;
                    }
                    case 3: {
                        this.hour = s;
                        break;
                    }
                    case 4: {
                        this.minute = s;
                        break;
                    }
                    case 5: {
                        this.second = s;
                        break;
                    }
                    case 6: {
                        this.timezone = s;
                        return;
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public Spliterator<AbstractFeature> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return this.count >= 0L ? this.count : Long.MAX_VALUE;
    }

    @Override
    public long getExactSizeIfKnown() {
        return this.count;
    }

    @Override
    public int characteristics() {
        return this.count >= 0L ? 320 : 256;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryAdvance(Consumer<? super AbstractFeature> action) {
        try {
            GDALStore gDALStore = this.layer.store;
            synchronized (gDALStore) {
                OGR ogr = this.layer.OGR();
                if (!this.initialized) {
                    this.initialize(ogr);
                }
                return this.advance(ogr, action);
            }
        }
        catch (Throwable e) {
            throw GDAL.propagate(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachRemaining(Consumer<? super AbstractFeature> action) {
        try {
            GDALStore gDALStore = this.layer.store;
            synchronized (gDALStore) {
                OGR ogr = this.layer.OGR();
                if (!this.initialized) {
                    this.initialize(ogr);
                }
                while (this.advance(ogr, action)) {
                }
            }
        }
        catch (Throwable e) {
            throw GDAL.propagate(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean advance(OGR ogr, Consumer<? super AbstractFeature> action) throws Throwable {
        AbstractFeature feature;
        MemorySegment handle = ogr.getNextFeature.invokeExact(this.layer.handle);
        if (GDAL.isNull(handle)) {
            return false;
        }
        try {
            feature = this.layer.type.newInstance();
            for (FieldAccessor<?> field : this.layer.fields) {
                feature.setPropertyValue(field.name(), field.getValue(this, ogr, handle));
            }
        }
        finally {
            ogr.destroyFeature.invokeExact(handle);
        }
        action.accept((AbstractFeature)feature);
        return true;
    }

    final MemorySegment buffer() {
        return this.buffer;
    }

    final boolean hasDate(OGR ogr, MemorySegment feature, int index) throws Throwable {
        return ogr.getFieldAsDateTime.invokeExact(feature, index, this.buffer, this.month, this.day, this.hour, this.minute, this.second, this.timezone) != 0;
    }

    final LocalDate date() {
        return LocalDate.of(this.buffer.get(ValueLayout.JAVA_INT, 0L), this.month.get(ValueLayout.JAVA_INT, 0L), this.day.get(ValueLayout.JAVA_INT, 0L));
    }

    final LocalTime time() {
        float withMillis = this.second.get(ValueLayout.JAVA_FLOAT, 0L);
        int sec = (int)withMillis;
        return LocalTime.of(this.hour.get(ValueLayout.JAVA_INT, 0L), this.minute.get(ValueLayout.JAVA_INT, 0L), sec, Math.round((withMillis - (float)sec) * 1.0E9f));
    }

    final ZoneOffset timezone() {
        return this.timezone.get(ValueLayout.JAVA_INT, 0L) == 100 ? ZoneOffset.UTC : null;
    }

    final Object geometry(OGR ogr, MemorySegment geom) throws Throwable {
        MemorySegment cz;
        boolean isPolygon;
        assert (Thread.holdsLock((Object)this.layer.store));
        Geometries<?> library = this.layer.library;
        int code = ogr.getGeometryType.invokeExact(geom);
        GeometryType type = code == 101 ? GeometryType.LINESTRING : GeometryType.forBinaryType((int)code);
        boolean bl = isPolygon = type == GeometryType.POLYGON;
        if (isPolygon || type.isCollection) {
            GeometryType componentType;
            if (isPolygon) {
                componentType = GeometryType.LINESTRING;
            } else {
                componentType = type.component();
                if (componentType == null) {
                    this.unsupportedType(type.name);
                    return null;
                }
            }
            Class componentClass = library.getGeometryClass(componentType);
            int n = ogr.getGeometryCount.invokeExact(geom);
            if (n <= 0) {
                return null;
            }
            Object[] children = (Object[])Array.newInstance(componentClass, n);
            for (int i = 0; i < n; ++i) {
                MemorySegment child = ogr.getGeometryRef.invokeExact(geom, i);
                children[i] = this.geometry(ogr, child);
            }
            return library.getGeometry(library.createFromComponents(type, (Object)children));
        }
        int pointCount = ogr.getPointCount.invokeExact(geom);
        if (pointCount <= 0) {
            return null;
        }
        boolean hasZ = GeometryType.hasZ((int)code) && library.supports(Capability.Z_COORDINATE);
        boolean hasM = GeometryType.hasM((int)code) && library.supports(Capability.M_COORDINATE);
        Dimensions dimensions = Dimensions.forZorM((boolean)hasZ, (boolean)hasM);
        int stride = dimensions.count * 8;
        long capacity = Math.multiplyFull(pointCount, stride);
        if (this.buffer.byteSize() < capacity) {
            this.arena = this.layer.store.changeArena(this.arena, true);
            this.buffer = this.arena.allocate(capacity);
        }
        MemorySegment cx = this.buffer;
        MemorySegment cy = this.day;
        MemorySegment memorySegment = cz = hasZ ? this.minute : MemorySegment.NULL;
        MemorySegment cm = hasM ? (hasZ ? this.timezone : this.minute) : MemorySegment.NULL;
        pointCount = ogr.getPoints.invokeExact(geom, cx, stride, cy, stride, cz, stride, cm, stride);
        assert (Math.multiplyFull(pointCount, stride) <= cx.byteSize()) : pointCount;
        if (pointCount <= 0) {
            return null;
        }
        if (pointCount == 1) {
            double x = cx.get(ValueLayout.JAVA_DOUBLE, 0L);
            double y = cy.get(ValueLayout.JAVA_DOUBLE, 0L);
            if (hasZ) {
                double z = cz.get(ValueLayout.JAVA_DOUBLE, 0L);
                return library.createPoint(x, y, z);
            }
            return library.createPoint(x, y);
        }
        MemorySegment coords = cx.reinterpret(Math.multiplyFull(pointCount, stride));
        DoubleBuffer coordinates = coords.asByteBuffer().order(ByteOrder.nativeOrder()).asDoubleBuffer();
        DoubleBuffer closingPoint = null;
        if (code == 101 && pointCount >= 3) {
            int last = pointCount - dimensions.count;
            double[] point = new double[dimensions.count];
            for (int i = 0; i < point.length; ++i) {
                point[i] = coordinates.get(i);
                if (closingPoint != null || Numerics.equalsIgnoreZeroSign((double)point[i], (double)coordinates.get(last + i))) continue;
                closingPoint = DoubleBuffer.wrap(point);
            }
        }
        switch (type) {
            case POINT: {
                return library.createPoint(false, dimensions, coordinates);
            }
            case MULTIPOINT: {
                return library.createMultiPoint(false, dimensions, coordinates);
            }
        }
        return library.createPolyline(false, false, dimensions, new DoubleBuffer[]{coordinates, closingPoint});
    }

    private void unsupportedType(String type) {
        if (this.unsupportedTypes.add(type)) {
            this.layer.store.warning(FeatureLayer.class, "features", new LogRecord(Level.WARNING, this.layer.errors().getString((short)200, (Object)type)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        GDALStore gDALStore = this.layer.store;
        synchronized (gDALStore) {
            this.layer.iterationInProgress = null;
            this.arena = this.layer.store.changeArena(this.arena, false);
        }
    }
}

