/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.sis.io.stream.ChannelDataInput;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.InternalDataStoreException;
import org.apache.sis.storage.geotiff.DeferredEntry;
import org.apache.sis.storage.geotiff.FormatModifier;
import org.apache.sis.storage.geotiff.GeoTiffStore;
import org.apache.sis.storage.geotiff.IOBase;
import org.apache.sis.storage.geotiff.ImageFileDirectory;
import org.apache.sis.storage.geotiff.MultiResolutionImage;
import org.apache.sis.storage.geotiff.base.Tags;
import org.apache.sis.storage.geotiff.reader.Type;
import org.apache.sis.storage.geotiff.reader.XMLMetadata;

final class Reader
extends IOBase {
    final ChannelDataInput input;
    final byte intSizeExpansion;
    private ImageFileDirectory lastIFD;
    private long nextIFD;
    private boolean endOfFile;
    private final Set<Long> doneIFD;
    private final List<GridCoverageResource> images = new ArrayList<GridCoverageResource>();
    private final LinkedList<DeferredEntry> deferredEntries = new LinkedList();
    private boolean deferredNeedsSort;

    Reader(GeoTiffStore store, ChannelDataInput input) throws IOException, DataStoreException {
        super(store);
        boolean isBigEndian;
        this.input = input;
        this.doneIFD = new HashSet<Long>();
        input.relocateOrigin();
        short order = input.readShort();
        boolean bl = isBigEndian = order == 19789;
        if (isBigEndian || order == 18761) {
            input.buffer.order(isBigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
            switch (input.readShort()) {
                case 42: {
                    this.intSizeExpansion = 0;
                    this.readNextImageOffset();
                    return;
                }
                case 43: {
                    int numBits = input.readUnsignedShort();
                    int powerOf2 = Integer.numberOfTrailingZeros(numBits);
                    if ((long)numBits != 1L << powerOf2 || input.readShort() != 0) break;
                    this.intSizeExpansion = (byte)(powerOf2 - 2);
                    if (this.intSizeExpansion != 1) break;
                    this.readNextImageOffset();
                    return;
                }
            }
        }
        throw new DataStoreContentException(this.errors().getString((short)170, (Object)"TIFF", (Object)input.filename));
    }

    @Override
    public final Set<FormatModifier> getModifiers() {
        return this.intSizeExpansion != 0 ? Set.of(FormatModifier.BIG_TIFF) : Set.of();
    }

    private void readNextImageOffset() throws IOException, DataStoreException {
        long p = this.input.getStreamPosition();
        this.nextIFD = this.readUnsignedInt();
        boolean bl = this.endOfFile = this.nextIFD == 0L;
        if (this.endOfFile) {
            this.nextIFD = p;
        } else if (!this.doneIFD.add(this.nextIFD)) {
            throw new DataStoreContentException(this.resources().getString((short)1, this.input.filename));
        }
    }

    private long readUnsignedInt() throws IOException, DataStoreException {
        if (this.intSizeExpansion == 0) {
            return this.input.readUnsignedInt();
        }
        long pointer = this.input.readLong();
        if (pointer >= 0L) {
            return pointer;
        }
        throw new DataStoreContentException(this.store.getLocale(), "TIFF", this.input.filename, null);
    }

    private long readUnsignedShort() throws IOException, DataStoreException {
        if (this.intSizeExpansion == 0) {
            return this.input.readUnsignedShort();
        }
        long entry = this.input.readLong();
        if (entry >= 0L) {
            return entry;
        }
        throw new DataStoreContentException(this.store.getLocale(), "TIFF", this.input.filename, null);
    }

    private ImageFileDirectory readNextIFD(int index) throws IOException, DataStoreException {
        if (this.endOfFile || this.nextIFD == 0L) {
            return null;
        }
        this.resolveDeferredEntries(null, this.nextIFD);
        this.input.seek(this.nextIFD);
        this.nextIFD = 0L;
        int offsetSize = 4 << this.intSizeExpansion;
        ImageFileDirectory dir = new ImageFileDirectory(this, index);
        long remaining = this.readUnsignedShort();
        while (--remaining >= 0L) {
            long size;
            short tag = (short)this.input.readUnsignedShort();
            Type type = Type.valueOf(this.input.readShort());
            long count = this.readUnsignedInt();
            long l = size = type != null ? Math.multiplyExact((long)type.size, count) : 0L;
            if (size <= (long)offsetSize) {
                long position = this.input.getStreamPosition();
                if (size != 0L) {
                    Object error;
                    try {
                        error = dir.addEntry(tag, type, count);
                    }
                    catch (IOException | DataStoreException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        error = e;
                    }
                    if (error != null) {
                        this.warning(tag, error);
                    }
                }
                this.input.seek(position + (long)offsetSize);
                continue;
            }
            this.deferredEntries.add(new DeferredEntry(dir, tag, type, count, this.readUnsignedInt()));
            dir.hasDeferredEntries = true;
            this.deferredNeedsSort = true;
        }
        this.readNextImageOffset();
        return dir;
    }

    final void resolveDeferredEntries(ImageFileDirectory dir) throws IOException, DataStoreException {
        if (dir.hasDeferredEntries) {
            this.resolveDeferredEntries(dir, Long.MAX_VALUE);
            dir.hasDeferredEntries = false;
        }
        dir.validateMandatoryTags();
    }

    private void resolveDeferredEntries(ImageFileDirectory dir, long ignoreAfter) throws IOException, DataStoreException {
        Iterator<DeferredEntry> it;
        if (this.deferredNeedsSort) {
            this.deferredEntries.sort(null);
            this.deferredNeedsSort = false;
        }
        long ignoreBefore = this.input.getStreamPosition();
        DeferredEntry stopAfter = null;
        if (dir != null) {
            it = this.deferredEntries.descendingIterator();
            while (it.hasNext()) {
                stopAfter = it.next();
                if (stopAfter.owner != dir) continue;
            }
        }
        it = this.deferredEntries.iterator();
        while (it.hasNext()) {
            DeferredEntry entry = it.next();
            if (entry.owner == dir || entry.offset >= ignoreBefore && entry.offset <= ignoreAfter) {
                Object error;
                this.input.seek(entry.offset);
                try {
                    error = entry.owner.addEntry(entry.tag, entry.type, entry.count);
                }
                catch (IOException | DataStoreException e) {
                    throw e;
                }
                catch (Exception e) {
                    error = e;
                }
                if (error != null) {
                    this.warning(entry.tag, error);
                }
                it.remove();
            }
            if (entry != stopAfter) continue;
            break;
        }
    }

    final int getImageCacheSize() {
        return this.images.size();
    }

    public final GridCoverageResource getImage(int index) throws IOException, DataStoreException {
        while (index >= this.images.size()) {
            ImageFileDirectory image;
            int imageIndex = this.images.size();
            ImageFileDirectory fullResolution = this.lastIFD;
            if (fullResolution == null && (fullResolution = this.readNextIFD(imageIndex)) == null) {
                return null;
            }
            this.lastIFD = null;
            ++imageIndex;
            ArrayList<ImageFileDirectory> overviews = new ArrayList<ImageFileDirectory>();
            while ((image = this.readNextIFD(imageIndex)) != null) {
                if (image.isReducedResolution()) {
                    overviews.add(image);
                    continue;
                }
                this.lastIFD = image;
                break;
            }
            if (overviews.isEmpty()) {
                this.images.add((GridCoverageResource)fullResolution);
                continue;
            }
            overviews.add(0, fullResolution);
            this.images.add((GridCoverageResource)new MultiResolutionImage(overviews));
        }
        GridCoverageResource image = this.images.get(index);
        if (image instanceof ImageFileDirectory) {
            this.resolveDeferredEntries((ImageFileDirectory)image);
        }
        return image;
    }

    final XMLMetadata readXML(Type type, long count, short tag) throws IOException {
        return new XMLMetadata(this.input, this.store.encoding, this.store.listeners(), type, count, tag);
    }

    private void warning(short tag, Object error) {
        Exception exception;
        Object[] args;
        short key;
        if (error instanceof Exception) {
            key = 24;
            args = new Object[1];
            exception = (Exception)error;
        } else {
            key = 179;
            args = new Object[2];
            args[1] = error;
            exception = null;
        }
        args[0] = Tags.name(tag);
        this.store.listeners().warning(this.errors().getString(key, (Object)args), exception);
    }

    final long offsetOfWritableIFD() throws IOException, DataStoreException {
        if (this.getImage(Integer.MAX_VALUE) == null && this.endOfFile) {
            return this.nextIFD;
        }
        throw new InternalDataStoreException();
    }

    final void offsetOfWrittenIFD(long position) throws IOException, DataStoreException {
        if (this.getImage(Integer.MAX_VALUE) != null || !this.endOfFile) {
            throw new InternalDataStoreException();
        }
        this.nextIFD = position;
        this.endOfFile = false;
    }

    @Override
    public void close() throws IOException {
        this.input.channel.close();
    }
}

