/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.parser;

import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlFeatures;
import org.apache.commons.jexl3.parser.ASTJexlScript;
import org.apache.commons.jexl3.parser.Parser;
import org.apache.commons.jexl3.parser.StringParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ParserTest {
    static final JexlFeatures FEATURES = new JexlFeatures();

    @Test
    void testControlCharacters() {
        String[][] strings;
        for (String[] pair : strings = new String[][]{{"a\nb\tc", "'a\nb\tc'"}, {"a\nb\tc", "'a\\nb\\tc'"}, {"a\nb\tc", "\"a\\nb\\tc\""}, {"\b\t\n\f\r", "'\\b\\t\\n\\f\\r'"}, {"'hi'", "'\\'hi\\''"}, {"\"hi\"", "'\"hi\"'"}, {"\"hi\"", "'\"hi\"'"}}) {
            String output = StringParser.buildString((CharSequence)pair[1], (boolean)true);
            Assertions.assertEquals((Object)pair[0], (Object)output);
        }
    }

    @Test
    void testErrorAmbiguous() throws Exception {
        Parser parser = new Parser(";");
        Assertions.assertThrows(JexlException.Ambiguous.class, () -> parser.parse(null, FEATURES, "x = 1 y = 5", null), (String)"should have failed on ambiguous statement");
    }

    @Test
    void testErrorAssign() throws Exception {
        String[] ops;
        for (String op : ops = new String[]{"=", "+=", "-=", "/=", "*=", "^=", "&=", "|="}) {
            Parser parser = new Parser(";");
            JexlException.Parsing xparse = (JexlException.Parsing)Assertions.assertThrows(JexlException.Parsing.class, () -> parser.parse(null, FEATURES, "foo() " + op + " 1;", null), () -> "should have failed on invalid assignment " + op);
            Assertions.assertNotNull((Object)xparse.getDetail());
            Assertions.assertNotNull((Object)xparse.toString());
        }
    }

    @Test
    void testIdentifierEscape() {
        String[] ids;
        for (String id : ids = new String[]{"a\\ b", "a\\ b\\ c", "a\\'b\\\"c", "a\\ \\ c"}) {
            String esc0 = StringParser.unescapeIdentifier((String)id);
            Assertions.assertFalse((boolean)esc0.contains("\\"));
            String esc1 = StringParser.escapeIdentifier((String)esc0);
            Assertions.assertEquals((Object)id, (Object)esc1);
        }
    }

    @Test
    void testParse() throws Exception {
        Parser parser = new Parser(";");
        ASTJexlScript sn = parser.parse(null, FEATURES, "foo = 1;", null);
        Assertions.assertNotNull((Object)sn, (String)"parsed node is null");
        sn = parser.parse(null, FEATURES, "foo = \"bar\";", null);
        Assertions.assertNotNull((Object)sn, (String)"parsed node is null");
        sn = parser.parse(null, FEATURES, "foo = 'bar';", null);
        Assertions.assertNotNull((Object)sn, (String)"parsed node is null");
    }
}

