/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.operation;

import jakarta.xml.bind.JAXBElement;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.sts.QNameConstants;
import org.apache.cxf.sts.event.STSIssueFailureEvent;
import org.apache.cxf.sts.event.STSIssueSuccessEvent;
import org.apache.cxf.sts.operation.AbstractOperation;
import org.apache.cxf.sts.request.KeyRequirements;
import org.apache.cxf.sts.request.ReceivedToken;
import org.apache.cxf.sts.request.RequestRequirements;
import org.apache.cxf.sts.request.TokenRequirements;
import org.apache.cxf.sts.service.EncryptionProperties;
import org.apache.cxf.sts.token.provider.TokenProvider;
import org.apache.cxf.sts.token.provider.TokenProviderParameters;
import org.apache.cxf.sts.token.provider.TokenProviderResponse;
import org.apache.cxf.sts.token.provider.TokenReference;
import org.apache.cxf.sts.token.validator.TokenValidatorResponse;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.cxf.ws.security.sts.provider.model.BinarySecretType;
import org.apache.cxf.ws.security.sts.provider.model.EntropyType;
import org.apache.cxf.ws.security.sts.provider.model.LifetimeType;
import org.apache.cxf.ws.security.sts.provider.model.RequestSecurityTokenCollectionType;
import org.apache.cxf.ws.security.sts.provider.model.RequestSecurityTokenResponseCollectionType;
import org.apache.cxf.ws.security.sts.provider.model.RequestSecurityTokenResponseType;
import org.apache.cxf.ws.security.sts.provider.model.RequestSecurityTokenType;
import org.apache.cxf.ws.security.sts.provider.model.RequestedReferenceType;
import org.apache.cxf.ws.security.sts.provider.model.RequestedSecurityTokenType;
import org.apache.cxf.ws.security.sts.provider.operation.IssueOperation;
import org.apache.cxf.ws.security.sts.provider.operation.IssueSingleOperation;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.principal.SAMLTokenPrincipalImpl;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.stax.securityEvent.WSSecurityEventConstants;
import org.apache.wss4j.stax.securityToken.SamlSecurityToken;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.securityToken.SecurityToken;

public class TokenIssueOperation
extends AbstractOperation
implements IssueOperation,
IssueSingleOperation {
    static final Logger LOG = LogUtils.getL7dLogger(TokenIssueOperation.class);

    public RequestSecurityTokenResponseCollectionType issue(RequestSecurityTokenType request, Principal principal, Map<String, Object> messageContext) {
        RequestSecurityTokenResponseType response = this.issueSingle(request, principal, messageContext);
        RequestSecurityTokenResponseCollectionType responseCollection = QNameConstants.WS_TRUST_FACTORY.createRequestSecurityTokenResponseCollectionType();
        responseCollection.getRequestSecurityTokenResponse().add(response);
        return responseCollection;
    }

    public RequestSecurityTokenResponseCollectionType issue(RequestSecurityTokenCollectionType requestCollection, Principal principal, Map<String, Object> messageContext) {
        RequestSecurityTokenResponseCollectionType responseCollection = QNameConstants.WS_TRUST_FACTORY.createRequestSecurityTokenResponseCollectionType();
        for (RequestSecurityTokenType request : requestCollection.getRequestSecurityToken()) {
            RequestSecurityTokenResponseType response = this.issueSingle(request, principal, messageContext);
            responseCollection.getRequestSecurityTokenResponse().add(response);
        }
        return responseCollection;
    }

    public RequestSecurityTokenResponseType issueSingle(RequestSecurityTokenType request, Principal principal, Map<String, Object> messageContext) {
        long start = System.currentTimeMillis();
        TokenProviderParameters providerParameters = new TokenProviderParameters();
        try {
            ReceivedToken validateTarget;
            SamlAssertionWrapper assertion;
            RequestRequirements requestRequirements = this.parseRequest(request, messageContext);
            providerParameters = this.createTokenProviderParameters(requestRequirements, principal, messageContext);
            providerParameters.setClaimsManager(this.claimsManager);
            String realm = providerParameters.getRealm();
            TokenRequirements tokenRequirements = requestRequirements.getTokenRequirements();
            String tokenType = tokenRequirements.getTokenType();
            if (this.stsProperties.getSamlRealmCodec() != null && (assertion = TokenIssueOperation.fetchSAMLAssertionFromWSSecuritySAMLToken(messageContext)) != null) {
                String wssecRealm = this.stsProperties.getSamlRealmCodec().getRealmFromToken(assertion);
                SAMLTokenPrincipalImpl samlPrincipal = new SAMLTokenPrincipalImpl(assertion);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("SAML token realm of user '" + samlPrincipal.getName() + "' is " + (String)wssecRealm);
                }
                ReceivedToken wssecToken = new ReceivedToken(assertion.getElement());
                wssecToken.setState(ReceivedToken.STATE.VALID);
                TokenValidatorResponse tokenResponse = new TokenValidatorResponse();
                tokenResponse.setPrincipal((Principal)samlPrincipal);
                tokenResponse.setToken(wssecToken);
                tokenResponse.setTokenRealm(wssecRealm);
                tokenResponse.setAdditionalProperties(new HashMap<String, Object>());
                this.processValidToken(providerParameters, wssecToken, tokenResponse);
                providerParameters.setPrincipal(wssecToken.getPrincipal());
            }
            if (providerParameters.getTokenRequirements().getOnBehalfOf() != null) {
                validateTarget = providerParameters.getTokenRequirements().getOnBehalfOf();
                this.handleDelegationToken(validateTarget, providerParameters, principal, messageContext, realm, requestRequirements);
            }
            if (providerParameters.getTokenRequirements().getActAs() != null) {
                validateTarget = providerParameters.getTokenRequirements().getActAs();
                this.handleDelegationToken(validateTarget, providerParameters, principal, messageContext, realm, requestRequirements);
            }
            TokenProviderResponse tokenResponse = null;
            for (TokenProvider tokenProvider : this.tokenProviders) {
                boolean canHandle = realm == null ? tokenProvider.canHandleToken(tokenType) : tokenProvider.canHandleToken(tokenType, realm);
                if (!canHandle) continue;
                try {
                    tokenResponse = tokenProvider.createToken(providerParameters);
                    break;
                }
                catch (STSException ex) {
                    LOG.log(Level.WARNING, "", ex);
                    throw ex;
                }
                catch (RuntimeException ex) {
                    LOG.log(Level.WARNING, "", ex);
                    throw new STSException("Error in providing a token", (Throwable)ex, STSException.REQUEST_FAILED);
                }
            }
            if (tokenResponse == null || tokenResponse.getToken() == null) {
                LOG.log(Level.WARNING, "No token provider found for requested token type: " + tokenType);
                throw new STSException("No token provider found for requested token type: " + tokenType, STSException.REQUEST_FAILED);
            }
            try {
                KeyRequirements keyRequirements = requestRequirements.getKeyRequirements();
                EncryptionProperties encryptionProperties = providerParameters.getEncryptionProperties();
                RequestSecurityTokenResponseType response = this.createResponse(encryptionProperties, tokenResponse, tokenRequirements, keyRequirements);
                STSIssueSuccessEvent event = new STSIssueSuccessEvent(providerParameters, System.currentTimeMillis() - start);
                this.publishEvent(event);
                this.cleanRequest(requestRequirements);
                return response;
            }
            catch (Throwable ex) {
                LOG.log(Level.WARNING, "", ex);
                throw new STSException("Error in creating the response", ex, STSException.REQUEST_FAILED);
            }
        }
        catch (RuntimeException ex) {
            LOG.log(Level.SEVERE, "Cannot issue token: " + ex.getMessage(), ex);
            STSIssueFailureEvent event = new STSIssueFailureEvent(providerParameters, System.currentTimeMillis() - start, (Exception)ex);
            this.publishEvent(event);
            throw ex;
        }
    }

    private void handleDelegationToken(ReceivedToken validateTarget, TokenProviderParameters providerParameters, Principal principal, Map<String, Object> messageContext, String realm, RequestRequirements requestRequirements) {
        TokenValidatorResponse tokenResponse = this.validateReceivedToken(principal, messageContext, realm, requestRequirements.getTokenRequirements(), validateTarget);
        if (tokenResponse == null) {
            LOG.fine("No Token Validator has been found that can handle this token");
        } else {
            if (validateTarget.getState() == ReceivedToken.STATE.INVALID) {
                throw new STSException("Incoming token is invalid", STSException.REQUEST_FAILED);
            }
            if (validateTarget.getState() == ReceivedToken.STATE.VALID) {
                this.processValidToken(providerParameters, validateTarget, tokenResponse);
            }
        }
        Principal tokenPrincipal = null;
        Set<Principal> tokenRoles = null;
        if (tokenResponse != null) {
            Map<String, Object> additionalProperties = tokenResponse.getAdditionalProperties();
            if (additionalProperties != null) {
                providerParameters.setAdditionalProperties(additionalProperties);
            }
            tokenPrincipal = tokenResponse.getPrincipal();
            tokenRoles = tokenResponse.getRoles();
        }
        this.performDelegationHandling(requestRequirements, principal, messageContext, validateTarget, tokenPrincipal, tokenRoles);
    }

    protected RequestSecurityTokenResponseType createResponse(EncryptionProperties encryptionProperties, TokenProviderResponse tokenResponse, TokenRequirements tokenRequirements, KeyRequirements keyRequirements) throws WSSecurityException {
        long keySize;
        Object token;
        RequestSecurityTokenResponseType response = QNameConstants.WS_TRUST_FACTORY.createRequestSecurityTokenResponseType();
        String context = tokenRequirements.getContext();
        if (context != null) {
            response.setContext(context);
        }
        JAXBElement jaxbTokenType = QNameConstants.WS_TRUST_FACTORY.createTokenType(tokenRequirements.getTokenType());
        response.getAny().add(jaxbTokenType);
        RequestedSecurityTokenType requestedTokenType = QNameConstants.WS_TRUST_FACTORY.createRequestedSecurityTokenType();
        JAXBElement requestedToken = QNameConstants.WS_TRUST_FACTORY.createRequestedSecurityToken(requestedTokenType);
        this.tokenWrapper.wrapToken(tokenResponse.getToken(), requestedTokenType);
        response.getAny().add(requestedToken);
        if (this.returnReferences) {
            TokenReference attachedReference = tokenResponse.getAttachedReference();
            RequestedReferenceType requestedAttachedReferenceType = attachedReference != null ? TokenIssueOperation.createRequestedReference(attachedReference, true) : TokenIssueOperation.createRequestedReference(tokenResponse.getTokenId(), tokenRequirements.getTokenType(), true);
            JAXBElement requestedAttachedReference = QNameConstants.WS_TRUST_FACTORY.createRequestedAttachedReference(requestedAttachedReferenceType);
            response.getAny().add(requestedAttachedReference);
            TokenReference unAttachedReference = tokenResponse.getUnAttachedReference();
            RequestedReferenceType requestedUnattachedReferenceType = unAttachedReference != null ? TokenIssueOperation.createRequestedReference(unAttachedReference, false) : TokenIssueOperation.createRequestedReference(tokenResponse.getTokenId(), tokenRequirements.getTokenType(), false);
            JAXBElement requestedUnattachedReference = QNameConstants.WS_TRUST_FACTORY.createRequestedUnattachedReference(requestedUnattachedReferenceType);
            response.getAny().add(requestedUnattachedReference);
        }
        response.getAny().add(tokenRequirements.getAppliesTo());
        if (tokenResponse.isComputedKey() && keyRequirements.getComputedKeyAlgorithm() != null) {
            JAXBElement computedKey = QNameConstants.WS_TRUST_FACTORY.createComputedKey(keyRequirements.getComputedKeyAlgorithm());
            requestedProofTokenType = QNameConstants.WS_TRUST_FACTORY.createRequestedProofTokenType();
            requestedProofTokenType.setAny((Object)computedKey);
            requestedProofToken = QNameConstants.WS_TRUST_FACTORY.createRequestedProofToken(requestedProofTokenType);
            response.getAny().add(requestedProofToken);
        } else if (tokenResponse.getEntropy() != null) {
            token = this.constructSecretToken(tokenResponse.getEntropy(), encryptionProperties, keyRequirements);
            requestedProofTokenType = QNameConstants.WS_TRUST_FACTORY.createRequestedProofTokenType();
            requestedProofTokenType.setAny(token);
            requestedProofToken = QNameConstants.WS_TRUST_FACTORY.createRequestedProofToken(requestedProofTokenType);
            response.getAny().add(requestedProofToken);
        }
        if (tokenResponse.isComputedKey() && tokenResponse.getEntropy() != null) {
            token = this.constructSecretToken(tokenResponse.getEntropy(), encryptionProperties, keyRequirements);
            EntropyType entropyType = QNameConstants.WS_TRUST_FACTORY.createEntropyType();
            entropyType.getAny().add(token);
            JAXBElement entropyElement = QNameConstants.WS_TRUST_FACTORY.createEntropy(entropyType);
            response.getAny().add(entropyElement);
        }
        if (this.includeLifetimeElement) {
            LifetimeType lifetime = TokenIssueOperation.createLifetime(tokenResponse.getCreated(), tokenResponse.getExpires());
            JAXBElement lifetimeType = QNameConstants.WS_TRUST_FACTORY.createLifetime(lifetime);
            response.getAny().add(lifetimeType);
        }
        if ((keySize = tokenResponse.getKeySize()) <= 0L) {
            keySize = keyRequirements.getKeySize();
        }
        if (keyRequirements.getKeySize() > 0L) {
            JAXBElement keySizeType = QNameConstants.WS_TRUST_FACTORY.createKeySize(Long.valueOf(keySize));
            response.getAny().add(keySizeType);
        }
        return response;
    }

    private static SamlAssertionWrapper fetchSAMLAssertionFromWSSecuritySAMLToken(Map<String, Object> messageContext) {
        List handlerResults = CastUtils.cast((List)((List)messageContext.get("RECV_RESULTS")));
        if (handlerResults != null && !handlerResults.isEmpty()) {
            WSHandlerResult handlerResult = (WSHandlerResult)handlerResults.get(0);
            List engineResults = handlerResult.getResults();
            for (WSSecurityEngineResult engineResult : engineResults) {
                Object token = engineResult.get((Object)"saml-assertion");
                if (!(token instanceof SamlAssertionWrapper)) continue;
                return (SamlAssertionWrapper)token;
            }
        }
        try {
            SecurityToken securityToken = TokenIssueOperation.findInboundSecurityToken(WSSecurityEventConstants.SAML_TOKEN, messageContext);
            if (securityToken instanceof SamlSecurityToken && ((SamlSecurityToken)securityToken).getSamlAssertionWrapper() != null) {
                return ((SamlSecurityToken)securityToken).getSamlAssertionWrapper();
            }
        }
        catch (XMLSecurityException e) {
            LOG.log(Level.FINE, e.getMessage(), e);
            return null;
        }
        return null;
    }

    private Object constructSecretToken(byte[] secret, EncryptionProperties encryptionProperties, KeyRequirements keyRequirements) throws WSSecurityException {
        BinarySecretType binarySecretType = QNameConstants.WS_TRUST_FACTORY.createBinarySecretType();
        String nonce = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Nonce";
        binarySecretType.setType(nonce);
        binarySecretType.setValue(secret);
        return QNameConstants.WS_TRUST_FACTORY.createBinarySecret(binarySecretType);
    }
}

