/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.clustering;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.clustering.FailoverFailedException;
import org.apache.cxf.clustering.FailoverStrategy;
import org.apache.cxf.clustering.FailoverTargetSelector;
import org.apache.cxf.clustering.circuitbreaker.CircuitBreaker;
import org.apache.cxf.clustering.circuitbreaker.ZestCircuitBreaker;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.Conduit;

public class CircuitBreakerTargetSelector
extends FailoverTargetSelector {
    public static final int DEFAULT_TIMEOUT = 60000;
    public static final int DEFAULT_THESHOLD = 1;
    private static final String IS_SELECTED = "org.apache.cxf.clustering.CircuitBreakerTargetSelector.IS_SELECTED";
    private static final Logger LOG = LogUtils.getL7dLogger(CircuitBreakerTargetSelector.class);
    private static final CircuitBreaker NOOP_CIRCUIT_BREAKER = new CircuitBreaker(){

        @Override
        public boolean allowRequest() {
            return true;
        }

        @Override
        public void markFailure(Throwable cause) {
        }

        @Override
        public void markSuccess() {
        }
    };
    private final int threshold;
    private final long timeout;
    private final Map<String, CircuitBreaker> circuits = new LinkedHashMap<String, CircuitBreaker>();

    public CircuitBreakerTargetSelector(int threshold, long timeout) {
        this.threshold = threshold;
        this.timeout = timeout;
    }

    public CircuitBreakerTargetSelector(int threshold, long timeout, String clientBootstrapAddress) {
        super(clientBootstrapAddress);
        this.threshold = threshold;
        this.timeout = timeout;
    }

    public CircuitBreakerTargetSelector() {
        this(1, 60000L);
    }

    @Override
    public synchronized void setStrategy(FailoverStrategy strategy) {
        List<String> alternatives;
        String address;
        super.setStrategy(strategy);
        if (this.getEndpoint() != null && !StringUtils.isEmpty((String)(address = this.getEndpoint().getEndpointInfo().getAddress()))) {
            this.circuits.putIfAbsent(address, new ZestCircuitBreaker(this.threshold, this.timeout));
        }
        if (strategy != null && (alternatives = strategy.getAlternateAddresses(null)) != null) {
            for (String alternative : alternatives) {
                if (StringUtils.isEmpty((String)alternative)) continue;
                this.circuits.putIfAbsent(alternative, new ZestCircuitBreaker(this.threshold, this.timeout));
            }
        }
    }

    @Override
    public synchronized Conduit selectConduit(Message message) {
        String address;
        Conduit c = (Conduit)message.get(Conduit.class);
        if (c != null) {
            return c;
        }
        Exchange exchange = message.getExchange();
        String key = String.valueOf(System.identityHashCode(exchange));
        FailoverTargetSelector.InvocationContext invocation = this.getInvocationContext(key);
        if (invocation != null && !invocation.getContext().containsKey(IS_SELECTED) && this.isFailoverRequired(address = (String)message.get((Object)Message.ENDPOINT_ADDRESS))) {
            Endpoint target = this.getFailoverTarget(exchange, invocation);
            if (target == null) {
                throw new Fault((Throwable)new FailoverFailedException("None of alternative addresses are available at the moment"));
            }
            if (this.isEndpointChanged(address, target)) {
                this.setEndpoint(target);
                message.put((Object)Message.ENDPOINT_ADDRESS, (Object)target.getEndpointInfo().getAddress());
                this.overrideAddressProperty(invocation.getContext());
                invocation.getContext().put(IS_SELECTED, null);
            }
        }
        return this.getSelectedConduit(message);
    }

    @Override
    protected Endpoint getFailoverTarget(Exchange exchange, FailoverTargetSelector.InvocationContext invocation) {
        String alternateAddress;
        if (this.circuits.isEmpty()) {
            LOG.log(Level.SEVERE, "No alternative addresses configured");
            return null;
        }
        List<String> alternateAddresses = this.updateContextAlternatives(exchange, invocation);
        if (alternateAddresses != null) {
            Iterator<String> alternateAddressIterator = alternateAddresses.iterator();
            while (alternateAddressIterator.hasNext()) {
                alternateAddress = alternateAddressIterator.next();
                CircuitBreaker circuitBreaker = this.getCircuitBreaker(alternateAddress);
                if (circuitBreaker.allowRequest()) continue;
                alternateAddressIterator.remove();
            }
        }
        Endpoint failoverTarget = null;
        if (alternateAddresses != null && !alternateAddresses.isEmpty()) {
            alternateAddress = this.getStrategy().selectAlternateAddress(alternateAddresses);
            if (alternateAddress != null) {
                failoverTarget = this.getEndpoint();
                failoverTarget.getEndpointInfo().setAddress(alternateAddress);
            }
        } else {
            List<Endpoint> alternateEndpoints = invocation.getAlternateEndpoints();
            if (alternateEndpoints != null) {
                Iterator<Endpoint> alternateEndpointIterator = alternateEndpoints.iterator();
                while (alternateEndpointIterator.hasNext()) {
                    Endpoint endpoint = alternateEndpointIterator.next();
                    CircuitBreaker circuitBreaker = this.getCircuitBreaker(endpoint);
                    if (circuitBreaker.allowRequest()) continue;
                    alternateEndpointIterator.remove();
                }
            }
            failoverTarget = this.getStrategy().selectAlternateEndpoint(alternateEndpoints);
        }
        return failoverTarget;
    }

    @Override
    protected void onFailure(FailoverTargetSelector.InvocationContext context, Exception ex) {
        super.onFailure(context, ex);
        Map requestContext = CastUtils.cast((Map)((Map)context.getContext().get("RequestContext")));
        if (requestContext != null) {
            String address = (String)requestContext.get(Message.ENDPOINT_ADDRESS);
            this.getCircuitBreaker(address).markFailure(ex);
        }
    }

    @Override
    protected void onSuccess(FailoverTargetSelector.InvocationContext context) {
        super.onSuccess(context);
        Map requestContext = CastUtils.cast((Map)((Map)context.getContext().get("RequestContext")));
        if (requestContext != null) {
            String address = (String)requestContext.get(Message.ENDPOINT_ADDRESS);
            this.getCircuitBreaker(address).markSuccess();
        }
    }

    private CircuitBreaker getCircuitBreaker(Endpoint endpoint) {
        return this.getCircuitBreaker(endpoint.getEndpointInfo().getAddress());
    }

    private synchronized CircuitBreaker getCircuitBreaker(String alternateAddress) {
        CircuitBreaker circuitBreaker = null;
        if (!StringUtils.isEmpty((String)alternateAddress)) {
            for (Map.Entry<String, CircuitBreaker> entry : this.circuits.entrySet()) {
                if (!alternateAddress.startsWith(entry.getKey())) continue;
                circuitBreaker = entry.getValue();
                break;
            }
            if (circuitBreaker == null) {
                circuitBreaker = new ZestCircuitBreaker(this.threshold, this.timeout);
                this.circuits.put(alternateAddress, circuitBreaker);
            }
        }
        if (circuitBreaker == null) {
            circuitBreaker = NOOP_CIRCUIT_BREAKER;
        }
        return circuitBreaker;
    }

    private boolean isEndpointChanged(String address, Endpoint target) {
        if (!StringUtils.isEmpty((String)address)) {
            return !address.startsWith(target.getEndpointInfo().getAddress());
        }
        if (this.getEndpoint().equals((Object)target)) {
            return false;
        }
        return !this.getEndpoint().getEndpointInfo().getAddress().startsWith(target.getEndpointInfo().getAddress());
    }

    private boolean isFailoverRequired(String address) {
        if (!StringUtils.isEmpty((String)address)) {
            for (Map.Entry<String, CircuitBreaker> entry : this.circuits.entrySet()) {
                if (!address.startsWith(entry.getKey())) continue;
                return !entry.getValue().allowRequest();
            }
        }
        LOG.log(Level.WARNING, "No circuit breaker present for address: " + address);
        return false;
    }
}

