/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Objects;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipUtil {
    public static boolean isZip(byte[] bytes) {
        if (bytes != null) {
            boolean bl;
            ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(bytes));
            try {
                ZipEntry nextEntry = zipInputStream.getNextEntry();
                bl = nextEntry != null;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        zipInputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            zipInputStream.close();
            return bl;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean containsFile(byte[] bytes, String filename) {
        Objects.requireNonNull(bytes, "Byte cannot be null");
        Objects.requireNonNull(filename, "File name cannot be null");
        try (ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(bytes));){
            ZipEntry nextEntry = zipInputStream.getNextEntry();
            while (nextEntry != null) {
                String name = nextEntry.getName();
                if (name.equals(filename)) {
                    boolean bl = true;
                    return bl;
                }
                nextEntry = zipInputStream.getNextEntry();
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean containsFileWithContents(byte[] bytes, String filename, String contents) {
        Objects.requireNonNull(bytes, "Byte cannot be null");
        Objects.requireNonNull(filename, "File name cannot be null");
        Objects.requireNonNull(contents, "Contents cannot be null");
        try (ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(bytes));){
            ZipEntry nextEntry = zipInputStream.getNextEntry();
            while (nextEntry != null) {
                String name = nextEntry.getName();
                if (name.equals(filename)) {
                    String zipContents = ZipUtil.readZipContents(zipInputStream);
                    boolean bl = zipContents.contains(contents);
                    return bl;
                }
                nextEntry = zipInputStream.getNextEntry();
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static String readZipContents(ZipInputStream zipInputStream) {
        Scanner sc = new Scanner(zipInputStream);
        StringBuilder builder = new StringBuilder();
        while (sc.hasNextLine()) {
            builder.append(sc.nextLine());
        }
        return builder.toString();
    }
}

