/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.codec.http.websocketx;

import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.stream.ChunkedInput;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;

public final class WebSocketChunkedInput
implements ChunkedInput<WebSocketFrame> {
    private final ChunkedInput<ByteBuf> input;
    private final int rsv;

    public WebSocketChunkedInput(ChunkedInput<ByteBuf> input) {
        this(input, 0);
    }

    public WebSocketChunkedInput(ChunkedInput<ByteBuf> input, int rsv) {
        this.input = ObjectUtil.checkNotNull(input, "input");
        this.rsv = rsv;
    }

    @Override
    public boolean isEndOfInput() throws Exception {
        return this.input.isEndOfInput();
    }

    @Override
    public void close() throws Exception {
        this.input.close();
    }

    @Override
    @Deprecated
    public WebSocketFrame readChunk(ChannelHandlerContext ctx) throws Exception {
        return this.readChunk(ctx.alloc());
    }

    @Override
    public WebSocketFrame readChunk(ByteBufAllocator allocator) throws Exception {
        ByteBuf buf = this.input.readChunk(allocator);
        if (buf == null) {
            return null;
        }
        return new ContinuationWebSocketFrame(this.input.isEndOfInput(), this.rsv, buf);
    }

    @Override
    public long length() {
        return this.input.length();
    }

    @Override
    public long progress() {
        return this.input.progress();
    }
}

