/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.dialog;

import java.util.ArrayList;
import lombok.Generated;
import org.apache.hop.core.Const;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.FormDataBuilder;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class MessageBox
extends Dialog {
    private static final Class<?> PKG = MessageBox.class;
    private final PropsUi props;
    private final int style;
    private String text;
    private String message;
    private int returnValue;
    private Shell shell;
    private int minimumWidth = -1;
    private int minimumHeight = -1;

    public MessageBox(Shell parent) {
        this(parent, 65538);
    }

    public MessageBox(Shell parent, int style) {
        super(parent, style);
        this.style = style;
        this.props = PropsUi.getInstance();
        this.returnValue = 0;
    }

    public int open() {
        Shell parent = this.getParent();
        int shellStyle = this.style & 0x38000;
        this.shell = new Shell(parent, 0xCF0 | shellStyle);
        PropsUi.setLook((Widget)this.shell);
        this.shell.setImage(GuiResource.getInstance().getImageHop());
        this.shell.setText(Const.NVL((String)this.text, (String)""));
        FormLayout layout = new FormLayout();
        layout.marginLeft = PropsUi.getFormMargin();
        layout.marginRight = PropsUi.getFormMargin();
        layout.marginTop = PropsUi.getFormMargin();
        layout.marginBottom = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)layout);
        int margin = PropsUi.getMargin();
        Composite composite = new Composite((Composite)this.shell, 0);
        PropsUi.setLook((Widget)composite);
        composite.setLayout((Layout)new GridLayout());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 15;
        composite.setLayout((Layout)gridLayout);
        Label wMessage = new Label(composite, 16448);
        PropsUi.setLook((Widget)wMessage);
        wMessage.setText(this.message);
        wMessage.setLayoutData((Object)new GridData(1808));
        Image iconImage = this.getIconImage(this.style);
        if (iconImage != null) {
            Label wImage = new Label(composite, 0);
            wImage.setImage(iconImage);
            wImage.setLayoutData((Object)new GridData());
        }
        ArrayList<Button> buttons = new ArrayList<Button>();
        if ((this.style & 0x40) != 0) {
            Button wYes = new Button((Composite)this.shell, 8);
            wYes.setText(BaseMessages.getString(PKG, (String)"System.Button.Yes", (String[])new String[0]));
            wYes.addListener(13, e -> this.yes());
            this.shell.setDefaultButton(wYes);
            buttons.add(wYes);
        }
        if ((this.style & 0x80) != 0) {
            Button wNo = new Button((Composite)this.shell, 8);
            wNo.setText(BaseMessages.getString(PKG, (String)"System.Button.No", (String[])new String[0]));
            wNo.addListener(13, e -> this.no());
            buttons.add(wNo);
        }
        if ((this.style & 0x100) != 0) {
            Button wCancel = new Button((Composite)this.shell, 8);
            wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
            wCancel.addListener(13, e -> this.cancel());
            buttons.add(wCancel);
        }
        if ((this.style & 0x20) != 0 || buttons.isEmpty()) {
            Button wOk = new Button((Composite)this.shell, 8);
            wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
            wOk.addListener(13, e -> this.ok());
            this.shell.setDefaultButton(wOk);
            buttons.add(0, wOk);
        }
        composite.setLayoutData((Object)new FormDataBuilder().top().left().right(100, 0).bottom(100, -50).result());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, buttons.toArray(new Button[0]), margin, (Control)composite);
        if (!buttons.isEmpty()) {
            for (Button button : buttons) {
                FormData fd = (FormData)button.getLayoutData();
                fd.top = null;
                fd.bottom = new FormAttachment(100, -margin);
            }
            composite.setLayoutData((Object)new FormDataBuilder().top().left().right(100, 0).bottom((Control)buttons.get(0), -margin).result());
        }
        this.shell.addListener(21, e -> this.cancel());
        BaseTransformDialog.setSize(this.shell);
        if (this.minimumWidth > 0 || this.minimumHeight > 0) {
            this.shell.layout();
            this.shell.pack();
            int width = Math.max(this.shell.getSize().x, this.minimumWidth > 0 ? this.minimumWidth : 0);
            int height = Math.max(this.shell.getSize().y, this.minimumHeight > 0 ? this.minimumHeight : 0);
            this.shell.setSize(width, height);
            this.shell.setMinimumSize(this.minimumWidth > 0 ? this.minimumWidth : 0, this.minimumHeight > 0 ? this.minimumHeight : 0);
        } else {
            this.shell.pack();
        }
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.returnValue;
    }

    private Image getIconImage(int style) {
        if ((style & 2) != 0) {
            return this.shell.getDisplay().getSystemImage(2);
        }
        if ((style & 1) != 0) {
            return this.shell.getDisplay().getSystemImage(1);
        }
        if ((style & 4) != 0) {
            return this.shell.getDisplay().getSystemImage(4);
        }
        if ((style & 8) != 0) {
            return this.shell.getDisplay().getSystemImage(8);
        }
        if ((style & 0x100) != 0) {
            return this.shell.getDisplay().getSystemImage(256);
        }
        if ((style & 0x200) != 0) {
            return this.shell.getDisplay().getSystemImage(512);
        }
        if ((style & 0x10) != 0) {
            return this.shell.getDisplay().getSystemImage(16);
        }
        return null;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void ok() {
        this.returnValue = 32;
        this.dispose();
    }

    public void cancel() {
        this.returnValue = 256;
        this.dispose();
    }

    public void yes() {
        this.returnValue = 64;
        this.dispose();
    }

    public void no() {
        this.returnValue = 128;
        this.dispose();
    }

    public int getStyle() {
        return this.style;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setMinimumSize(int width, int height) {
        this.minimumWidth = width;
        this.minimumHeight = height;
    }

    @Generated
    public PropsUi getProps() {
        return this.props;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public int getReturnValue() {
        return this.returnValue;
    }

    @Generated
    public Shell getShell() {
        return this.shell;
    }

    @Generated
    public int getMinimumWidth() {
        return this.minimumWidth;
    }

    @Generated
    public int getMinimumHeight() {
        return this.minimumHeight;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setReturnValue(int returnValue) {
        this.returnValue = returnValue;
    }

    @Generated
    public void setShell(Shell shell) {
        this.shell = shell;
    }

    @Generated
    public void setMinimumWidth(int minimumWidth) {
        this.minimumWidth = minimumWidth;
    }

    @Generated
    public void setMinimumHeight(int minimumHeight) {
        this.minimumHeight = minimumHeight;
    }
}

