/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.common;

import java.util.function.Function;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.function.ThrowingConsumer;
import org.apache.beam.sdk.io.aws2.common.ClientBuilderFactory;
import org.apache.beam.sdk.io.aws2.common.ClientConfiguration;
import org.apache.beam.sdk.io.aws2.options.AwsOptions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.BiMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.HashBiMap;
import org.apache.commons.lang3.tuple.Pair;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.core.SdkClient;

@Internal
public class ObjectPool<@UnknownKeyFor KeyT, @UnknownKeyFor ObjectT> {
    private final @UnknownKeyFor @NonNull @Initialized BiMap<KeyT, @UnknownKeyFor @NonNull @Initialized ObjectPool. @UnknownKeyFor @NonNull @Initialized RefCounted> pool = HashBiMap.create((int)2);
    private final @UnknownKeyFor @NonNull @Initialized Function<KeyT, ObjectT> builder;
    private final @Nullable @UnknownKeyFor @Initialized ThrowingConsumer<@UnknownKeyFor @NonNull @Initialized Exception, ObjectT> finalizer;

    public ObjectPool(@UnknownKeyFor @NonNull @Initialized Function<KeyT, ObjectT> builder) {
        this(builder, null);
    }

    public ObjectPool(@UnknownKeyFor @NonNull @Initialized Function<KeyT, ObjectT> builder, @Nullable @UnknownKeyFor @Initialized ThrowingConsumer<@UnknownKeyFor @NonNull @Initialized Exception, ObjectT> finalizer) {
        this.builder = builder;
        this.finalizer = finalizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectT retain(KeyT key) {
        BiMap<KeyT, RefCounted> biMap = this.pool;
        synchronized (biMap) {
            RefCounted ref = (RefCounted)this.pool.computeIfAbsent(key, k -> new RefCounted(this.builder.apply(k)));
            ref.count++;
            return (ObjectT)ref.shared;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseByKey(KeyT key) {
        RefCounted ref;
        BiMap<KeyT, RefCounted> biMap = this.pool;
        synchronized (biMap) {
            ref = (RefCounted)this.pool.get(key);
            if (ref == null || --ref.count > 0) {
                return;
            }
            this.pool.remove(key);
        }
        if (this.finalizer != null) {
            try {
                this.finalizer.accept(ref.shared);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(ObjectPool.class).warn("Exception destroying pooled object.", (Throwable)e);
            }
        }
    }

    public void release(ObjectT object) {
        Object key = this.pool.inverse().get((Object)new RefCounted(object));
        if (key != null) {
            this.releaseByKey(key);
        }
    }

    public static <ClientT extends SdkClient, BuilderT extends AwsClientBuilder<BuilderT, ClientT>> @UnknownKeyFor @NonNull @Initialized ClientPool<ClientT> pooledClientFactory(BuilderT builder) {
        return new ClientPool(c -> (SdkClient)ClientBuilderFactory.buildClient((AwsOptions)c.getLeft(), builder, (ClientConfiguration)c.getRight()));
    }

    private class RefCounted {
        private @UnknownKeyFor @NonNull @Initialized int count = 0;
        private final ObjectT shared;

        RefCounted(ObjectT client) {
            this.shared = client;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.shared == ((RefCounted)o).shared;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return this.shared.hashCode();
        }
    }

    public static class ClientPool<@UnknownKeyFor ClientT extends @UnknownKeyFor @NonNull @Initialized SdkClient>
    extends ObjectPool<Pair<AwsOptions, ClientConfiguration>, ClientT> {
        private ClientPool(@UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Pair<@UnknownKeyFor @NonNull @Initialized AwsOptions, @UnknownKeyFor @NonNull @Initialized ClientConfiguration>, ClientT> builder) {
            super(builder, c -> c.close());
        }

        public ClientT retain(@UnknownKeyFor @NonNull @Initialized AwsOptions provider, @UnknownKeyFor @NonNull @Initialized ClientConfiguration config) {
            return (ClientT)((SdkClient)this.retain(Pair.of((Object)provider, (Object)config)));
        }
    }
}

