/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;

public class DateDetector {
    private static final String LOCALE_EN_US = "en_US";
    private static final String DEFAULT_DATE_FORMAT = "dd/MM/yy";
    private static final String DEFAULT_DATE_FORMAT_2 = "dd/MM/yyyy";
    static final BidiMap<String, String> DATE_FORMAT_TO_REGEXPS_US = new DualHashBidiMap<String, String>(){
        {
            this.put("MM-dd-yyyy", "^[0-1]?[0-9]-[0-3]?[0-9]-\\d{4}$");
            this.put(DateDetector.DEFAULT_DATE_FORMAT_2, "^[0-3]?[0-9]/[0-1]?[0-9]/\\d{4}$");
            this.put("MM-dd-yy", "^[0-1]?[0-9]-[0-3]?[0-9]-\\d{2}$");
            this.put(DateDetector.DEFAULT_DATE_FORMAT, "^[0-3]?[0-9]/[0-1]?[0-9]/\\d{2}$");
            this.put("yyyyMMdd", "^\\d{8}$");
            this.put("dd-MM-yy", "^\\d{1,2}-\\d{1,2}-\\d{2}$");
            this.put("dd-MM-yyyy", "^\\d{1,2}-\\d{1,2}-\\d{4}$");
            this.put("dd.MM.yy", "^\\d{1,2}\\.\\d{1,2}\\.\\d{2}$");
            this.put("dd.MM.yyyy", "^\\d{1,2}\\.\\d{1,2}\\.\\d{4}$");
            this.put("MM/dd/yy", "^\\d{1,2}/\\d{1,2}/\\d{2}$");
            this.put("MM/dd/yyyy", "^\\d{1,2}/\\d{1,2}/\\d{4}$");
            this.put("yyyy-MM-dd", "^\\d{4}-\\d{1,2}-\\d{1,2}$");
            this.put("yyyy.MM.dd", "^\\d{4}\\.\\d{1,2}\\.\\d{1,2}$");
            this.put("yyyy/MM/dd", "^\\d{4}/\\d{1,2}/\\d{1,2}$");
            this.put("dd MMM yyyy", "^\\d{1,2}\\s[a-z]{3}\\s\\d{4}$");
            this.put("dd MMMM yyyy", "^\\d{1,2}\\s[a-z]{4,}\\s\\d{4}$");
            this.put("yyyyMMddHHmm", "^\\d{12}$");
            this.put("yyyyMMdd HHmm", "^\\d{8}\\s\\d{4}$");
            this.put("dd-MM-yy HH:mm", "^\\d{1,2}-\\d{1,2}-\\d{2}\\s\\d{1,2}:\\d{2}$");
            this.put("dd-MM-yyyy HH:mm", "^\\d{1,2}-\\d{1,2}-\\d{4}\\s\\d{1,2}:\\d{2}$");
            this.put("dd.MM.yy HH:mm", "^\\d{1,2}\\.\\d{1,2}\\.\\d{2}\\s\\d{1,2}:\\d{2}$");
            this.put("dd.MM.yyyy HH:mm", "^\\d{1,2}\\.\\d{1,2}\\.\\d{4}\\s\\d{1,2}:\\d{2}$");
            this.put("MM/dd/yy HH:mm", "^\\d{1,2}/\\d{1,2}/\\d{2}\\s\\d{1,2}:\\d{2}$");
            this.put("MM/dd/yyyy HH:mm", "^\\d{1,2}/\\d{1,2}/\\d{4}\\s\\d{1,2}:\\d{2}$");
            this.put("yyyy-MM-dd HH:mm", "^\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{2}$");
            this.put("yyyy.MM.dd HH:mm", "^\\d{4}\\.\\d{1,2}\\.\\d{1,2}\\s\\d{1,2}:\\d{2}$");
            this.put("yyyy/MM/dd HH:mm", "^\\d{4}/\\d{1,2}/\\d{1,2}\\s\\d{1,2}:\\d{2}$");
            this.put("dd MMM yyyy HH:mm", "^\\d{1,2}\\s[a-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{2}$");
            this.put("dd MMMM yyyy HH:mm", "^\\d{1,2}\\s[a-z]{4,}\\s\\d{4}\\s\\d{1,2}:\\d{2}$");
            this.put("yyyyMMddHHmmss", "^\\d{14}$");
            this.put("yyyyMMdd HHmmss", "^\\d{8}\\s\\d{6}$");
            this.put("dd-MM-yy HH:mm:ss", "^\\d{1,2}-\\d{1,2}-\\d{2}\\s\\d{1,2}:\\d{2}:\\d{2}$");
            this.put("dd-MM-yyyy HH:mm:ss", "^\\d{1,2}-\\d{1,2}-\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}$");
            this.put("dd.MM.yy HH:mm:ss", "^\\d{1,2}\\.\\d{1,2}\\.\\d{2}\\s\\d{1,2}:\\d{2}:\\d{2}$");
            this.put("dd.MM.yyyy HH:mm:ss", "^\\d{1,2}\\.\\d{1,2}\\.\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}$");
            this.put("MM/dd/yy HH:mm:ss", "^\\d{1,2}/\\d{1,2}/\\d{2}\\s\\d{1,2}:\\d{2}:\\d{2}$");
            this.put("MM/dd/yyyy HH:mm:ss", "^\\d{1,2}/\\d{1,2}/\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}$");
            this.put("yyyy-MM-dd HH:mm:ss", "^\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{2}:\\d{2}$");
            this.put("yyyy.MM.dd HH:mm:ss", "^\\d{4}\\.\\d{1,2}\\.\\d{1,2}\\s\\d{1,2}:\\d{2}:\\d{2}$");
            this.put("yyyy/MM/dd HH:mm:ss", "^\\d{4}/\\d{1,2}/\\d{1,2}\\s\\d{1,2}:\\d{2}:\\d{2}$");
            this.put("dd MMM yyyy HH:mm:ss", "^\\d{1,2}\\s[a-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}$");
            this.put("dd MMMM yyyy HH:mm:ss", "^\\d{1,2}\\s[a-z]{4,}\\s\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}$");
            this.put("dd-MM-yy HH:mm:ss.SSS", "^\\d{1,2}-\\d{1,2}-\\d{2}\\s\\d{1,2}:\\d{2}:\\d{2}\\.\\d{3}$");
            this.put("dd-MM-yyyy HH:mm:ss.SSS", "^\\d{1,2}-\\d{1,2}-\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}\\.\\d{3}$");
            this.put("dd.MM.yy HH:mm:ss.SSS", "^\\d{1,2}\\.\\d{1,2}\\.\\d{2}\\s\\d{1,2}:\\d{2}:\\d{2}\\.\\d{3}$");
            this.put("dd.MM.yyyy HH:mm:ss.SSS", "^\\d{1,2}\\.\\d{1,2}\\.\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}\\.\\d{3}$");
            this.put("MM/dd/yy HH:mm:ss.SSS", "^\\d{1,2}/\\d{1,2}/\\d{2}\\s\\d{1,2}:\\d{2}:\\d{2}\\.\\d{3}$");
            this.put("MM/dd/yyyy HH:mm:ss.SSS", "^\\d{1,2}/\\d{1,2}/\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}\\.\\d{3}$");
            this.put("yyyy-MM-dd HH:mm:ss.SSS", "^\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{2}:\\d{2}\\.\\d{3}$");
            this.put("yyyy.MM.dd HH:mm:ss.SSS", "^\\d{4}\\.\\d{1,2}\\.\\d{1,2}\\s\\d{1,2}:\\d{2}:\\d{2}\\.\\d{3}$");
            this.put("yyyy/MM/dd HH:mm:ss.SSS", "^\\d{4}/\\d{1,2}/\\d{1,2}\\s\\d{1,2}:\\d{2}:\\d{2}\\.\\d{3}$");
            this.put("dd MMM yyyy HH:mm:ss.SSS", "^\\d{1,2}\\s[a-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}\\.\\d{3}$");
            this.put("dd MMMM yyyy HH:mm:ss.SSS", "^\\d{1,2}\\s[a-z]{4,}\\s\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}\\.\\d{3}$");
        }
    };
    static final BidiMap DATE_FORMAT_TO_REGEXPS = new DualHashBidiMap(){
        {
            this.put("MM-dd-yyyy", "^[0-1]?[0-9]-[0-3]?[0-9]-\\d{4}$");
            this.put(DateDetector.DEFAULT_DATE_FORMAT_2, "^[0-3]?[0-9]/[0-1]?[0-9]/\\d{4}$");
            this.put("MM-dd-yy", "^[0-1]?[0-9]-[0-3]?[0-9]-\\d{2}$");
            this.put(DateDetector.DEFAULT_DATE_FORMAT, "^[0-3]?[0-9]/[0-1]?[0-9]/\\d{2}$");
            this.put("yyyyMMdd", "^\\d{8}$");
            this.put("dd-MM-yy", "^\\d{1,2}-\\d{1,2}-\\d{2}$");
            this.put("dd-MM-yyyy", "^\\d{1,2}-\\d{1,2}-\\d{4}$");
            this.put("dd.MM.yy", "^\\d{1,2}\\.\\d{1,2}\\.\\d{2}$");
            this.put("dd.MM.yyyy", "^\\d{1,2}\\.\\d{1,2}\\.\\d{4}$");
            this.put(DateDetector.DEFAULT_DATE_FORMAT, "^\\d{1,2}/\\d{1,2}/\\d{2}$");
            this.put(DateDetector.DEFAULT_DATE_FORMAT_2, "^\\d{1,2}/\\d{1,2}/\\d{4}$");
            this.put("yyyy-MM-dd", "^\\d{4}-\\d{1,2}-\\d{1,2}$");
            this.put("yyyy.MM.dd", "^\\d{4}\\.\\d{1,2}\\.\\d{1,2}$");
            this.put("yyyy/MM/dd", "^\\d{4}/\\d{1,2}/\\d{1,2}$");
            this.put("dd MMM yyyy", "^\\d{1,2}\\s[a-z]{3}\\s\\d{4}$");
            this.put("dd MMMM yyyy", "^\\d{1,2}\\s[a-z]{4,}\\s\\d{4}$");
            this.put("yyyyMMddHHmm", "^\\d{12}$");
            this.put("yyyyMMdd HHmm", "^\\d{8}\\s\\d{4}$");
            this.put("dd-MM-yy HH:mm", "^\\d{1,2}-\\d{1,2}-\\d{2}\\s\\d{1,2}:\\d{2}$");
            this.put("dd-MM-yyyy HH:mm", "^\\d{1,2}-\\d{1,2}-\\d{4}\\s\\d{1,2}:\\d{2}$");
            this.put("dd.MM.yy HH:mm", "^\\d{1,2}\\.\\d{1,2}\\.\\d{2}\\s\\d{1,2}:\\d{2}$");
            this.put("dd.MM.yyyy HH:mm", "^\\d{1,2}\\.\\d{1,2}\\.\\d{4}\\s\\d{1,2}:\\d{2}$");
            this.put("dd/MM/yy HH:mm", "^\\d{1,2}/\\d{1,2}/\\d{2}\\s\\d{1,2}:\\d{2}$");
            this.put("dd/MM/yyyy HH:mm", "^\\d{1,2}/\\d{1,2}/\\d{4}\\s\\d{1,2}:\\d{2}$");
            this.put("yyyy-MM-dd HH:mm", "^\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{2}$");
            this.put("yyyy.MM.dd HH:mm", "^\\d{4}\\.\\d{1,2}\\.\\d{1,2}\\s\\d{1,2}:\\d{2}$");
            this.put("yyyy/MM/dd HH:mm", "^\\d{4}/\\d{1,2}/\\d{1,2}\\s\\d{1,2}:\\d{2}$");
            this.put("dd MMM yyyy HH:mm", "^\\d{1,2}\\s[a-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{2}$");
            this.put("dd MMMM yyyy HH:mm", "^\\d{1,2}\\s[a-z]{4,}\\s\\d{4}\\s\\d{1,2}:\\d{2}$");
            this.put("yyyyMMddHHmmss", "^\\d{14}$");
            this.put("yyyyMMdd HHmmss", "^\\d{8}\\s\\d{6}$");
            this.put("dd-MM-yy HH:mm:ss", "^\\d{1,2}-\\d{1,2}-\\d{2}\\s\\d{1,2}:\\d{2}:\\d{2}$");
            this.put("dd-MM-yyyy HH:mm:ss", "^\\d{1,2}-\\d{1,2}-\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}$");
            this.put("dd.MM.yy HH:mm:ss", "^\\d{1,2}\\.\\d{1,2}\\.\\d{2}\\s\\d{1,2}:\\d{2}:\\d{2}$");
            this.put("dd.MM.yyyy HH:mm:ss", "^\\d{1,2}\\.\\d{1,2}\\.\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}$");
            this.put("dd/MM/yy HH:mm:ss", "^\\d{1,2}/\\d{1,2}/\\d{2}\\s\\d{1,2}:\\d{2}:\\d{2}$");
            this.put("dd/MM/yyyy HH:mm:ss", "^\\d{1,2}/\\d{1,2}/\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}$");
            this.put("yyyy-MM-dd HH:mm:ss", "^\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{2}:\\d{2}$");
            this.put("yyyy.MM.dd HH:mm:ss", "^\\d{4}\\.\\d{1,2}\\.\\d{1,2}\\s\\d{1,2}:\\d{2}:\\d{2}$");
            this.put("yyyy/MM/dd HH:mm:ss", "^\\d{4}/\\d{1,2}/\\d{1,2}\\s\\d{1,2}:\\d{2}:\\d{2}$");
            this.put("dd MMM yyyy HH:mm:ss", "^\\d{1,2}\\s[a-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}$");
            this.put("dd MMMM yyyy HH:mm:ss", "^\\d{1,2}\\s[a-z]{4,}\\s\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}$");
            this.put("dd-MM-yy HH:mm:ss.SSS", "^\\d{1,2}-\\d{1,2}-\\d{2}\\s\\d{1,2}:\\d{2}:\\d{2}\\.\\d{3}$");
            this.put("dd-MM-yyyy HH:mm:ss.SSS", "^\\d{1,2}-\\d{1,2}-\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}\\.\\d{3}$");
            this.put("dd.MM.yy HH:mm:ss.SSS", "^\\d{1,2}\\.\\d{1,2}\\.\\d{2}\\s\\d{1,2}:\\d{2}:\\d{2}\\.\\d{3}$");
            this.put("dd.MM.yyyy HH:mm:ss.SSS", "^\\d{1,2}\\.\\d{1,2}\\.\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}\\.\\d{3}$");
            this.put("dd/MM/yy HH:mm:ss.SSS", "^\\d{1,2}/\\d{1,2}/\\d{2}\\s\\d{1,2}:\\d{2}:\\d{2}\\.\\d{3}$");
            this.put("dd/MM/yyyy HH:mm:ss.SSS", "^\\d{1,2}/\\d{1,2}/\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}\\.\\d{3}$");
            this.put("yyyy-MM-dd HH:mm:ss.SSS", "^\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{2}:\\d{2}\\.\\d{3}$");
            this.put("yyyy.MM.dd HH:mm:ss.SSS", "^\\d{4}\\.\\d{1,2}\\.\\d{1,2}\\s\\d{1,2}:\\d{2}:\\d{2}\\.\\d{3}$");
            this.put("yyyy/MM/dd HH:mm:ss.SSS", "^\\d{4}/\\d{1,2}/\\d{1,2}\\s\\d{1,2}:\\d{2}:\\d{2}\\.\\d{3}$");
            this.put("dd MMM yyyy HH:mm:ss.SSS", "^\\d{1,2}\\s[a-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}\\.\\d{3}$");
            this.put("dd MMMM yyyy HH:mm:ss.SSS", "^\\d{1,2}\\s[a-z]{4,}\\s\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}\\.\\d{3}$");
        }
    };

    private DateDetector() {
    }

    public static String getRegexpByDateFormat(String dateFormat) {
        return DateDetector.getRegexpByDateFormat(dateFormat, null);
    }

    public static String getRegexpByDateFormat(String dateFormat, String locale) {
        if (LOCALE_EN_US.equalsIgnoreCase(locale)) {
            return (String)DATE_FORMAT_TO_REGEXPS_US.get((Object)dateFormat);
        }
        return (String)DATE_FORMAT_TO_REGEXPS.get((Object)dateFormat);
    }

    public static String getDateFormatByRegex(String regex) {
        return DateDetector.getDateFormatByRegex(regex, null);
    }

    public static String getDateFormatByRegex(String regex, String locale) {
        if (LOCALE_EN_US.equalsIgnoreCase(locale)) {
            return (String)DATE_FORMAT_TO_REGEXPS_US.getKey((Object)regex);
        }
        return (String)DATE_FORMAT_TO_REGEXPS.getKey((Object)regex);
    }

    public static Date getDateFromString(String dateString) throws ParseException {
        String dateFormat = DateDetector.detectDateFormat(dateString);
        if (dateFormat == null) {
            throw new ParseException("Unknown date format.", 0);
        }
        return DateDetector.getDateFromStringByFormat(dateString, dateFormat);
    }

    public static Date getDateFromString(String dateString, String locale) throws ParseException {
        String dateFormat = DateDetector.detectDateFormat(dateString, locale);
        if (dateFormat == null) {
            throw new ParseException("Unknown date format.", 0);
        }
        return DateDetector.getDateFromStringByFormat(dateString, dateFormat);
    }

    public static Date getDateFromStringByFormat(String dateString, String dateFormat) throws ParseException {
        if (dateFormat == null) {
            throw new ParseException("Unknown date format. Format is null. ", 0);
        }
        if (dateString == null) {
            throw new ParseException("Unknown date string. Date string is null. ", 0);
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
        simpleDateFormat.setLenient(false);
        return simpleDateFormat.parse(dateString);
    }

    public static String detectDateFormat(String dateString) {
        return DateDetector.detectDateFormat(dateString, null);
    }

    public static String detectDateFormat(String dateString, String locale) {
        if (dateString == null) {
            return null;
        }
        for (Object regexp : DateDetector.getDateFormatToRegExps(locale).values()) {
            if (!dateString.toLowerCase().matches((String)regexp)) continue;
            return (String)DateDetector.getDateFormatToRegExps(locale).getKey(regexp);
        }
        return null;
    }

    public static String detectDateFormatBiased(String dateString, String locale, String desiredKey) {
        if (dateString == null) {
            return null;
        }
        String regex = (String)DateDetector.getDateFormatToRegExps(locale).get((Object)desiredKey);
        if (regex != null && dateString.toLowerCase().matches(regex)) {
            return desiredKey;
        }
        return DateDetector.detectDateFormat(dateString, locale);
    }

    public static BidiMap getDateFormatToRegExps(String locale) {
        if (locale == null || LOCALE_EN_US.equalsIgnoreCase(locale)) {
            return DATE_FORMAT_TO_REGEXPS_US;
        }
        return DATE_FORMAT_TO_REGEXPS;
    }

    public static boolean isValidDate(String dateString, String dateFormat) {
        try {
            DateDetector.getDateFromStringByFormat(dateString, dateFormat);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isValidDate(String dateString) {
        try {
            DateDetector.getDateFromString(dateString);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isValidDateFormatToStringDate(String dateFormat, String dateString) {
        String detectedDateFormat = DateDetector.detectDateFormat(dateString);
        return dateFormat != null && dateFormat.equals(detectedDateFormat);
    }

    public static boolean isValidDateFormatToStringDate(String dateFormat, String dateString, String locale) {
        String detectedDateFormat = dateFormat != null ? DateDetector.detectDateFormatBiased(dateString, locale, dateFormat) : DateDetector.detectDateFormat(dateString, locale);
        return dateFormat != null && dateFormat.equals(detectedDateFormat);
    }
}

