/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.dtoa;

import org.mozilla.javascript.dtoa.Decimal;
import org.mozilla.javascript.dtoa.MathUtils;

public class DoubleFormatter {
    static final int P = 53;
    private static final int W = 11;
    static final int Q_MIN = -1074;
    static final int Q_MAX = 971;
    static final int E_MIN = -323;
    static final int E_MAX = 309;
    static final long C_TINY = 3L;
    static final int H = 17;
    private static final long C_MIN = 0x10000000000000L;
    private static final int BQ_MASK = 2047;
    private static final long T_MASK = 0xFFFFFFFFFFFFFL;
    private static final long MASK_63 = Long.MAX_VALUE;

    public static String toString(double v) {
        long bits = Double.doubleToRawLongBits(v);
        long t = bits & 0xFFFFFFFFFFFFFL;
        int bq = (int)(bits >>> 52) & 0x7FF;
        if (bq < 2047) {
            if (bq == 0 && t == 0L) {
                return "0";
            }
            return DoubleFormatter.toDecimalImpl(bits, t, bq).toString();
        }
        if (t != 0L) {
            return "NaN";
        }
        return bits > 0L ? "Infinity" : "-Infinity";
    }

    public static Decimal toDecimal(double v) {
        assert (Double.isFinite(v));
        long bits = Double.doubleToRawLongBits(v);
        long t = bits & 0xFFFFFFFFFFFFFL;
        int bq = (int)(bits >>> 52) & 0x7FF;
        return DoubleFormatter.toDecimalImpl(bits, t, bq);
    }

    private static Decimal toDecimalImpl(long bits, long t, int bq) {
        assert (bq < 2047);
        boolean negative = false;
        if (bits < 0L) {
            negative = true;
        }
        if (bq != 0) {
            long f;
            int mq = 1075 - bq;
            long c = 0x10000000000000L | t;
            if (0 < mq && mq < 53 && (f = c >> mq) << mq == c) {
                return new Decimal(f, 0, negative);
            }
            return DoubleFormatter.toDecimalFull(-mq, c, 0, negative);
        }
        if (t != 0L) {
            return t < 3L ? DoubleFormatter.toDecimalFull(-1074, 10L * t, -1, negative) : DoubleFormatter.toDecimalFull(-1074, t, 0, negative);
        }
        return new Decimal(0L, 1, false);
    }

    private static Decimal toDecimalFull(int q, long c, int dk, boolean negative) {
        boolean win;
        int k;
        long cbl;
        int out = (int)c & 1;
        long cb = c << 2;
        long cbr = cb + 2L;
        if (c != 0x10000000000000L || q == -1074) {
            cbl = cb - 2L;
            k = MathUtils.flog10pow2(q);
        } else {
            cbl = cb - 1L;
            k = MathUtils.flog10threeQuartersPow2(q);
        }
        int h = q + MathUtils.flog2pow10(-k) + 2;
        long g1 = MathUtils.g1(k);
        long g0 = MathUtils.g0(k);
        long vb = DoubleFormatter.rop(g1, g0, cb << h);
        long vbl = DoubleFormatter.rop(g1, g0, cbl << h);
        long vbr = DoubleFormatter.rop(g1, g0, cbr << h);
        long s = vb >> 2;
        if (s >= 100L) {
            boolean wpin;
            long sp10 = 10L * MathUtils.multiplyHigh(s, 1844674407370955168L);
            long tp10 = sp10 + 10L;
            boolean upin = vbl + (long)out <= sp10 << 2;
            boolean bl = wpin = (tp10 << 2) + (long)out <= vbr;
            if (upin != wpin) {
                return new Decimal(upin ? sp10 : tp10, k, negative);
            }
        }
        long t = s + 1L;
        boolean uin = vbl + (long)out <= s << 2;
        boolean bl = win = (t << 2) + (long)out <= vbr;
        if (uin != win) {
            return new Decimal(uin ? s : t, k + dk, negative);
        }
        long cmp = vb - (s + t << 1);
        return new Decimal(cmp < 0L || cmp == 0L && (s & 1L) == 0L ? s : t, k + dk, negative);
    }

    private static long rop(long g1, long g0, long cp) {
        long x1 = MathUtils.multiplyHigh(g0, cp);
        long y0 = g1 * cp;
        long y1 = MathUtils.multiplyHigh(g1, cp);
        long z = (y0 >>> 1) + x1;
        long vbp = y1 + (z >>> 63);
        return vbp | (z & Long.MAX_VALUE) + Long.MAX_VALUE >>> 63;
    }
}

