/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.salesforceinsert;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceTransformMeta;
import org.apache.hop.pipeline.transforms.salesforceinsert.SalesforceInsert;
import org.apache.hop.pipeline.transforms.salesforceinsert.SalesforceInsertData;
import org.apache.hop.pipeline.transforms.salesforceinsert.SalesforceInsertField;

@Transform(id="SalesforceInsert", name="i18n::SalesforceInsert.TypeLongDesc.SalesforceInsert", description="i18n::SalesforceInsert.TypeTooltipDesc.SalesforceInsert", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Output", keywords={"i18n::SalesforceInsertMeta.keyword"}, image="salesforceinsert.svg", documentationUrl="/pipeline/transforms/salesforceinsert.html")
public class SalesforceInsertMeta
extends SalesforceTransformMeta<SalesforceInsert, SalesforceInsertData> {
    private static final Class<?> PKG = SalesforceInsertMeta.class;
    public static final String CONST_SPACES = "        ";
    public static final String CONST_FIELD = "field";
    @HopMetadataProperty(key="field", groupKey="fields")
    private List<SalesforceInsertField> fields;
    @HopMetadataProperty
    private String batchSize;
    @HopMetadataProperty
    private String salesforceIDFieldName;
    @HopMetadataProperty
    private boolean rollbackAllChangesOnError;

    public int getBatchSizeInt() {
        return Const.toInt((String)this.batchSize, (int)10);
    }

    @Override
    public Object clone() {
        SalesforceInsertMeta retval = (SalesforceInsertMeta)((Object)super.clone());
        retval.fields = new ArrayList<SalesforceInsertField>();
        int nrFields = this.fields.size();
        for (int i = 0; i < this.fields.size(); ++i) {
            if (this.fields.get(i) == null) continue;
            retval.fields.add((SalesforceInsertField)this.fields.get(i).clone());
        }
        return retval;
    }

    @Override
    public void setDefault() {
        super.setDefault();
        this.setFields(new ArrayList<SalesforceInsertField>());
        this.setBatchSize("10");
        this.setSalesforceIDFieldName("Id");
        this.setRollbackAllChangesOnError(false);
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        String realfieldname = variables.resolve(this.getSalesforceIDFieldName());
        if (!Utils.isEmpty((CharSequence)realfieldname)) {
            ValueMetaString v = new ValueMetaString(realfieldname);
            v.setLength(18);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
    }

    @Override
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        super.check(remarks, pipelineMeta, transformMeta, prev, input, output, info, variables, metadataProvider);
        CheckResult cr = input != null && input.length > 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInsertMeta.CheckResult.NoInputExpected", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceInsertMeta.CheckResult.NoInput", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = this.getFields().size() == 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInsertMeta.CheckResult.NoFields", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceInsertMeta.CheckResult.FieldsOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    @Generated
    public List<SalesforceInsertField> getFields() {
        return this.fields;
    }

    @Generated
    public String getBatchSize() {
        return this.batchSize;
    }

    @Generated
    public String getSalesforceIDFieldName() {
        return this.salesforceIDFieldName;
    }

    @Generated
    public boolean isRollbackAllChangesOnError() {
        return this.rollbackAllChangesOnError;
    }

    @Generated
    public void setFields(List<SalesforceInsertField> fields) {
        this.fields = fields;
    }

    @Generated
    public void setBatchSize(String batchSize) {
        this.batchSize = batchSize;
    }

    @Generated
    public void setSalesforceIDFieldName(String salesforceIDFieldName) {
        this.salesforceIDFieldName = salesforceIDFieldName;
    }

    @Generated
    public void setRollbackAllChangesOnError(boolean rollbackAllChangesOnError) {
        this.rollbackAllChangesOnError = rollbackAllChangesOnError;
    }
}

