/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.team.MemberAddArgBase;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MemberAddV2Arg
extends MemberAddArgBase {
    @Nullable
    protected final List<String> roleIds;

    public MemberAddV2Arg(@Nonnull String memberEmail, @Nullable String memberGivenName, @Nullable String memberSurname, @Nullable String memberExternalId, @Nullable String memberPersistentId, boolean sendWelcomeEmail, @Nullable Boolean isDirectoryRestricted, @Nullable List<String> roleIds) {
        super(memberEmail, memberGivenName, memberSurname, memberExternalId, memberPersistentId, sendWelcomeEmail, isDirectoryRestricted);
        if (roleIds != null) {
            if (roleIds.size() > 1) {
                throw new IllegalArgumentException("List 'roleIds' has more than 1 items");
            }
            for (String x : roleIds) {
                if (x == null) {
                    throw new IllegalArgumentException("An item in list 'roleIds' is null");
                }
                if (x.length() > 128) {
                    throw new IllegalArgumentException("Stringan item in list 'roleIds' is longer than 128");
                }
                if (Pattern.matches("pid_dbtmr:.*", x)) continue;
                throw new IllegalArgumentException("Stringan item in list 'roleIds' does not match pattern");
            }
        }
        this.roleIds = roleIds;
    }

    public MemberAddV2Arg(@Nonnull String memberEmail) {
        this(memberEmail, null, null, null, null, true, null, null);
    }

    @Override
    @Nonnull
    public String getMemberEmail() {
        return this.memberEmail;
    }

    @Override
    @Nullable
    public String getMemberGivenName() {
        return this.memberGivenName;
    }

    @Override
    @Nullable
    public String getMemberSurname() {
        return this.memberSurname;
    }

    @Override
    @Nullable
    public String getMemberExternalId() {
        return this.memberExternalId;
    }

    @Override
    @Nullable
    public String getMemberPersistentId() {
        return this.memberPersistentId;
    }

    @Override
    public boolean getSendWelcomeEmail() {
        return this.sendWelcomeEmail;
    }

    @Override
    @Nullable
    public Boolean getIsDirectoryRestricted() {
        return this.isDirectoryRestricted;
    }

    @Nullable
    public List<String> getRoleIds() {
        return this.roleIds;
    }

    public static Builder newBuilder(String memberEmail) {
        return new Builder(memberEmail);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.roleIds});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            MemberAddV2Arg other = (MemberAddV2Arg)obj;
            return (this.memberEmail == other.memberEmail || this.memberEmail.equals(other.memberEmail)) && (this.memberGivenName == other.memberGivenName || this.memberGivenName != null && this.memberGivenName.equals(other.memberGivenName)) && (this.memberSurname == other.memberSurname || this.memberSurname != null && this.memberSurname.equals(other.memberSurname)) && (this.memberExternalId == other.memberExternalId || this.memberExternalId != null && this.memberExternalId.equals(other.memberExternalId)) && (this.memberPersistentId == other.memberPersistentId || this.memberPersistentId != null && this.memberPersistentId.equals(other.memberPersistentId)) && this.sendWelcomeEmail == other.sendWelcomeEmail && (this.isDirectoryRestricted == other.isDirectoryRestricted || this.isDirectoryRestricted != null && this.isDirectoryRestricted.equals(other.isDirectoryRestricted)) && (this.roleIds == other.roleIds || this.roleIds != null && this.roleIds.equals(other.roleIds));
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<MemberAddV2Arg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(MemberAddV2Arg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("member_email");
            StoneSerializers.string().serialize(value.memberEmail, g);
            if (value.memberGivenName != null) {
                g.writeFieldName("member_given_name");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.memberGivenName, g);
            }
            if (value.memberSurname != null) {
                g.writeFieldName("member_surname");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.memberSurname, g);
            }
            if (value.memberExternalId != null) {
                g.writeFieldName("member_external_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.memberExternalId, g);
            }
            if (value.memberPersistentId != null) {
                g.writeFieldName("member_persistent_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.memberPersistentId, g);
            }
            g.writeFieldName("send_welcome_email");
            StoneSerializers.boolean_().serialize((Boolean)value.sendWelcomeEmail, g);
            if (value.isDirectoryRestricted != null) {
                g.writeFieldName("is_directory_restricted");
                StoneSerializers.nullable(StoneSerializers.boolean_()).serialize(value.isDirectoryRestricted, g);
            }
            if (value.roleIds != null) {
                g.writeFieldName("role_ids");
                StoneSerializers.nullable(StoneSerializers.list(StoneSerializers.string())).serialize(value.roleIds, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public MemberAddV2Arg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            List<String> f_roleIds;
            Boolean f_isDirectoryRestricted;
            Boolean f_sendWelcomeEmail;
            String f_memberPersistentId;
            String f_memberExternalId;
            String f_memberSurname;
            String f_memberGivenName;
            String f_memberEmail;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_memberEmail = null;
                f_memberGivenName = null;
                f_memberSurname = null;
                f_memberExternalId = null;
                f_memberPersistentId = null;
                f_sendWelcomeEmail = true;
                f_isDirectoryRestricted = null;
                f_roleIds = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("member_email".equals(field)) {
                        f_memberEmail = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("member_given_name".equals(field)) {
                        f_memberGivenName = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("member_surname".equals(field)) {
                        f_memberSurname = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("member_external_id".equals(field)) {
                        f_memberExternalId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("member_persistent_id".equals(field)) {
                        f_memberPersistentId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("send_welcome_email".equals(field)) {
                        f_sendWelcomeEmail = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("is_directory_restricted".equals(field)) {
                        f_isDirectoryRestricted = StoneSerializers.nullable(StoneSerializers.boolean_()).deserialize(p);
                        continue;
                    }
                    if ("role_ids".equals(field)) {
                        f_roleIds = StoneSerializers.nullable(StoneSerializers.list(StoneSerializers.string())).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_memberEmail == null) {
                    throw new JsonParseException(p, "Required field \"member_email\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            MemberAddV2Arg value = new MemberAddV2Arg(f_memberEmail, f_memberGivenName, f_memberSurname, f_memberExternalId, f_memberPersistentId, f_sendWelcomeEmail, f_isDirectoryRestricted, f_roleIds);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder
    extends MemberAddArgBase.Builder {
        protected List<String> roleIds = null;

        protected Builder(String memberEmail) {
            super(memberEmail);
        }

        public Builder withRoleIds(List<String> roleIds) {
            if (roleIds != null) {
                if (roleIds.size() > 1) {
                    throw new IllegalArgumentException("List 'roleIds' has more than 1 items");
                }
                for (String x : roleIds) {
                    if (x == null) {
                        throw new IllegalArgumentException("An item in list 'roleIds' is null");
                    }
                    if (x.length() > 128) {
                        throw new IllegalArgumentException("Stringan item in list 'roleIds' is longer than 128");
                    }
                    if (Pattern.matches("pid_dbtmr:.*", x)) continue;
                    throw new IllegalArgumentException("Stringan item in list 'roleIds' does not match pattern");
                }
            }
            this.roleIds = roleIds;
            return this;
        }

        @Override
        public Builder withMemberGivenName(String memberGivenName) {
            super.withMemberGivenName(memberGivenName);
            return this;
        }

        @Override
        public Builder withMemberSurname(String memberSurname) {
            super.withMemberSurname(memberSurname);
            return this;
        }

        @Override
        public Builder withMemberExternalId(String memberExternalId) {
            super.withMemberExternalId(memberExternalId);
            return this;
        }

        @Override
        public Builder withMemberPersistentId(String memberPersistentId) {
            super.withMemberPersistentId(memberPersistentId);
            return this;
        }

        @Override
        public Builder withSendWelcomeEmail(Boolean sendWelcomeEmail) {
            super.withSendWelcomeEmail(sendWelcomeEmail);
            return this;
        }

        @Override
        public Builder withIsDirectoryRestricted(Boolean isDirectoryRestricted) {
            super.withIsDirectoryRestricted(isDirectoryRestricted);
            return this;
        }

        @Override
        public MemberAddV2Arg build() {
            return new MemberAddV2Arg(this.memberEmail, this.memberGivenName, this.memberSurname, this.memberExternalId, this.memberPersistentId, this.sendWelcomeEmail, this.isDirectoryRestricted, this.roleIds);
        }
    }
}

