/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.time.Duration;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.TextElement;

@PublicEvolving
public class BatchExecutionOptions {
    @Documentation.Section(value={"expert_scheduling"})
    public static final ConfigOption<Boolean> ADAPTIVE_AUTO_PARALLELISM_ENABLED = ConfigOptions.key("execution.batch.adaptive.auto-parallelism.enabled").booleanType().defaultValue(true).withDescription("If true, Flink will automatically decide the parallelism of operators in batch jobs.");
    @Documentation.Section(value={"expert_scheduling"})
    public static final ConfigOption<Integer> ADAPTIVE_AUTO_PARALLELISM_MIN_PARALLELISM = ConfigOptions.key("execution.batch.adaptive.auto-parallelism.min-parallelism").intType().defaultValue(1).withDeprecatedKeys("jobmanager.adaptive-batch-scheduler.min-parallelism").withDescription(Description.builder().text("The lower bound of allowed parallelism to set adaptively if %s has been set to %s", TextElement.code(JobManagerOptions.SCHEDULER.key()), TextElement.code(JobManagerOptions.SchedulerType.AdaptiveBatch.name())).build());
    @Documentation.Section(value={"expert_scheduling"})
    public static final ConfigOption<Integer> ADAPTIVE_AUTO_PARALLELISM_MAX_PARALLELISM = ConfigOptions.key("execution.batch.adaptive.auto-parallelism.max-parallelism").intType().defaultValue(128).withDeprecatedKeys("jobmanager.adaptive-batch-scheduler.max-parallelism").withDescription(Description.builder().text("The upper bound of allowed parallelism to set adaptively if %s has been set to %s", TextElement.code(JobManagerOptions.SCHEDULER.key()), TextElement.code(JobManagerOptions.SchedulerType.AdaptiveBatch.name())).build());
    @Documentation.Section(value={"expert_scheduling"})
    public static final ConfigOption<MemorySize> ADAPTIVE_AUTO_PARALLELISM_AVG_DATA_VOLUME_PER_TASK = ConfigOptions.key("execution.batch.adaptive.auto-parallelism.avg-data-volume-per-task").memoryType().defaultValue(MemorySize.ofMebiBytes(16L)).withDeprecatedKeys("jobmanager.adaptive-batch-scheduler.avg-data-volume-per-task").withDescription(Description.builder().text("The average size of data volume to expect each task instance to process if %s has been set to %s. Note that when data skew occurs or the decided parallelism reaches the %s (due to too much data), the data actually processed by some tasks may far exceed this value.", TextElement.code(JobManagerOptions.SCHEDULER.key()), TextElement.code(JobManagerOptions.SchedulerType.AdaptiveBatch.name()), TextElement.code(ADAPTIVE_AUTO_PARALLELISM_MAX_PARALLELISM.key())).build());
    @Documentation.Section(value={"expert_scheduling"})
    public static final ConfigOption<Integer> ADAPTIVE_AUTO_PARALLELISM_DEFAULT_SOURCE_PARALLELISM = ConfigOptions.key("execution.batch.adaptive.auto-parallelism.default-source-parallelism").intType().noDefaultValue().withDeprecatedKeys("jobmanager.adaptive-batch-scheduler.default-source-parallelism").withDescription(Description.builder().text("The default parallelism of source vertices or the upper bound of source parallelism to set adaptively if %s has been set to %s. Note that %s will be used if this configuration is not configured. If %s is not set either, then the default parallelism set via %s will be used instead.", TextElement.code(JobManagerOptions.SCHEDULER.key()), TextElement.code(JobManagerOptions.SchedulerType.AdaptiveBatch.name()), TextElement.code(ADAPTIVE_AUTO_PARALLELISM_MAX_PARALLELISM.key()), TextElement.code(ADAPTIVE_AUTO_PARALLELISM_MAX_PARALLELISM.key()), TextElement.code(CoreOptions.DEFAULT_PARALLELISM.key())).build());
    @Documentation.Section(value={"expert_scheduling"})
    public static final ConfigOption<Boolean> SPECULATIVE_ENABLED = ConfigOptions.key("execution.batch.speculative.enabled").booleanType().defaultValue(false).withDeprecatedKeys("jobmanager.adaptive-batch-scheduler.speculative.enabled").withDescription("Controls whether to enable speculative execution.");
    @Documentation.Section(value={"expert_scheduling"})
    public static final ConfigOption<Integer> SPECULATIVE_MAX_CONCURRENT_EXECUTIONS = ConfigOptions.key("execution.batch.speculative.max-concurrent-executions").intType().defaultValue(2).withDeprecatedKeys("jobmanager.adaptive-batch-scheduler.speculative.max-concurrent-executions").withDescription("Controls the maximum number of execution attempts of each operator that can execute concurrently, including the original one and speculative ones.");
    @Documentation.Section(value={"expert_scheduling"})
    public static final ConfigOption<Duration> BLOCK_SLOW_NODE_DURATION = ConfigOptions.key("execution.batch.speculative.block-slow-node-duration").durationType().defaultValue(Duration.ofMinutes(1L)).withDeprecatedKeys("jobmanager.adaptive-batch-scheduler.speculative.block-slow-node-duration").withDescription("Controls how long an detected slow node should be blocked for.");

    private BatchExecutionOptions() {
        throw new UnsupportedOperationException("This class should never be instantiated.");
    }
}

