/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.datagrid;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.datagrid.DataGrid;
import org.apache.hop.pipeline.transforms.datagrid.DataGridData;
import org.apache.hop.pipeline.transforms.datagrid.DataGridDataMeta;
import org.apache.hop.pipeline.transforms.datagrid.DataGridFieldMeta;

@Transform(id="DataGrid", image="datagrid.svg", name="i18n::DataGrid.Name", description="i18n::DataGrid.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", keywords={"i18n::DataGridMeta.keyword"}, documentationUrl="/pipeline/transforms/datagrid.html")
public class DataGridMeta
extends BaseTransformMeta<DataGrid, DataGridData> {
    @HopMetadataProperty(groupKey="fields", key="field", injectionGroupDescription="DataGridDialog.Meta.Label")
    private List<DataGridFieldMeta> dataGridFields;
    @HopMetadataProperty(groupKey="data", key="line", injectionGroupDescription="DataGridDialog.Data.Label")
    private List<DataGridDataMeta> dataLines;

    public DataGridMeta() {
        this.dataGridFields = new ArrayList<DataGridFieldMeta>();
        this.dataLines = new ArrayList<DataGridDataMeta>();
    }

    public DataGridMeta(DataGridMeta m) {
        this.dataGridFields = m.dataGridFields;
        this.dataLines = m.dataLines;
    }

    public DataGridMeta clone() {
        return new DataGridMeta(this);
    }

    public List<DataGridDataMeta> getDataLines() {
        return this.dataLines;
    }

    public void setDataLines(List<DataGridDataMeta> dataLines) {
        this.dataLines = dataLines;
    }

    public List<DataGridFieldMeta> getDataGridFields() {
        return this.dataGridFields;
    }

    public void setDataGridFields(List<DataGridFieldMeta> dataGridFields) {
        this.dataGridFields = dataGridFields;
    }

    public void getFields(IRowMeta rowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        for (DataGridFieldMeta dataGridField : this.dataGridFields) {
            try {
                if (Utils.isEmpty((CharSequence)dataGridField.getName())) continue;
                int type = ValueMetaFactory.getIdForValueMeta((String)dataGridField.getType());
                if (type == 0) {
                    type = 2;
                }
                IValueMeta v = ValueMetaFactory.createValueMeta((String)dataGridField.getName(), (int)type);
                v.setLength(dataGridField.getLenght());
                v.setPrecision(dataGridField.getPrecision());
                v.setOrigin(name);
                v.setConversionMask(dataGridField.getFormat());
                v.setCurrencySymbol(dataGridField.getCurrency());
                v.setGroupingSymbol(dataGridField.getGroup());
                v.setDecimalSymbol(dataGridField.getDecimal());
                rowMeta.addValueMeta(v);
            }
            catch (Exception e) {
                throw new HopTransformException("Unable to create value of type " + dataGridField.getType(), (Throwable)e);
            }
        }
    }
}

