/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.stanford.nlp.simple;

import edu.stanford.nlp.simple.Document;
import edu.stanford.nlp.simple.Sentence;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.Bag;
import org.apache.hop.pipeline.transforms.stanford.nlp.simple.ParsedSentenceImpl;

public interface ParsedSentence {
    public Object[] getInputRow();

    public String getSentenceText();

    public List<String> getSentenceWords();

    public List<String> getSentencePosTags();

    public Bag<String> getSentencePosBag();

    public long getIndex();

    public long getIndexBegin();

    public long getIndexEnd();

    public long getCharacterCount();

    public long getWordCount();

    public String getSentenceTextPosTagged();

    public static final class Builder {
        private boolean includePartOfSpeech;

        private Builder() {
        }

        public static Builder parsedSentenceBuilder() {
            return new Builder();
        }

        public Builder includePartOfSpeech(boolean includePartOfSpeech) {
            this.includePartOfSpeech = includePartOfSpeech;
            return this;
        }

        public ParsedSentence buildSentence(Object[] inputRow, Sentence sentence) {
            return new ParsedSentenceImpl(inputRow, sentence, this.includePartOfSpeech);
        }

        public List<ParsedSentence> buildSentences(Object[] inputRow, String corpus) {
            Document doc = new Document(corpus);
            List sentences = doc.sentences();
            ArrayList<ParsedSentence> parsedSentences = new ArrayList<ParsedSentence>(sentences.size());
            for (Sentence sentence : sentences) {
                parsedSentences.add(this.buildSentence(inputRow, sentence));
            }
            return parsedSentences;
        }
    }
}

