/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.avro.transforms.avrooutput;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.metadata.api.HopMetadataProperty;

public class AvroOutputField
implements Cloneable,
Comparable<AvroOutputField> {
    @HopMetadataProperty(key="name", injectionKeyDescription="AvroOutput.Injection.STREAM_NAME")
    private String name;
    @HopMetadataProperty(key="avroname", injectionKeyDescription="AvroOutput.Injection.AVRO_PATH")
    private String avroName;
    private String avroTypeDesc;
    @HopMetadataProperty(key="avrotype", injectionKeyDescription="AvroOutput.Injection.AVRO_TYPE")
    private int avroType;
    @HopMetadataProperty(key="nullable", injectionKeyDescription="AvroOutput.Injection.NULLABLE")
    private boolean nullable;
    public static final int AVRO_TYPE_NONE = 0;
    public static final int AVRO_TYPE_BOOLEAN = 1;
    public static final int AVRO_TYPE_DOUBLE = 2;
    public static final int AVRO_TYPE_FLOAT = 3;
    public static final int AVRO_TYPE_INT = 4;
    public static final int AVRO_TYPE_LONG = 5;
    public static final int AVRO_TYPE_STRING = 6;
    public static final int AVRO_TYPE_ENUM = 7;
    private static String[] avroDescriptions = new String[]{"", "Boolean", "Double", "Float", "Int", "Long", "String", "Enum"};

    public AvroOutputField(String name, String avroName, int avroType, boolean nullable) {
        this.name = name;
        this.avroName = avroName;
        this.avroType = avroType;
        this.nullable = nullable;
    }

    public AvroOutputField(AvroOutputField f) {
        this.name = f.name;
        this.avroName = f.avroName;
        this.avroType = f.avroType;
        this.nullable = f.nullable;
    }

    public AvroOutputField() {
    }

    public int compare(Object obj) {
        AvroOutputField field = (AvroOutputField)obj;
        return this.name.compareTo(field.getName());
    }

    public boolean equal(Object obj) {
        AvroOutputField field = (AvroOutputField)obj;
        return this.name.equals(field.getName());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String fieldname) {
        this.name = fieldname;
    }

    public String getAvroName() {
        return this.avroName != null ? this.avroName : this.name;
    }

    public void setAvroName(String avroName) {
        this.avroName = avroName;
    }

    public int getAvroType() {
        if (this.avroTypeDesc != null) {
            this.setAvroType(this.avroTypeDesc);
        }
        return this.avroType;
    }

    public String getAvroTypeDesc() {
        if (this.avroTypeDesc != null) {
            this.setAvroType(this.avroTypeDesc);
        }
        return avroDescriptions[this.avroType];
    }

    public static String getAvroTypeDesc(int avroType) {
        return avroDescriptions[avroType];
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public static String[] getAvroTypeArraySorted() {
        Object[] sorted = avroDescriptions;
        Arrays.sort(sorted, 1, avroDescriptions.length - 1);
        return sorted;
    }

    public void setAvroType(int avroType) {
        this.avroType = avroType;
        this.avroTypeDesc = null;
    }

    public void setAvroType(String avroTypeDesc) {
        for (int i = 0; i < avroDescriptions.length; ++i) {
            if (!avroTypeDesc.equalsIgnoreCase(avroDescriptions[i])) continue;
            this.avroType = i;
            break;
        }
        this.avroTypeDesc = null;
    }

    public static int getDefaultAvroType(int pentahoType) {
        return switch (pentahoType) {
            case 1, 6 -> 2;
            case 5 -> 5;
            case 4 -> 1;
            default -> 6;
        };
    }

    public Schema.Type getAvroSchemaType() throws HopException {
        return switch (this.avroType) {
            case 1 -> Schema.Type.BOOLEAN;
            case 2 -> Schema.Type.DOUBLE;
            case 3 -> Schema.Type.FLOAT;
            case 4 -> Schema.Type.INT;
            case 5 -> Schema.Type.LONG;
            case 6 -> Schema.Type.STRING;
            case 7 -> Schema.Type.ENUM;
            default -> throw new HopException("Unsupported Avro Type " + avroDescriptions[this.avroType]);
        };
    }

    public void setAvroTypeDesc(String avroTypeDesc) {
        this.avroTypeDesc = avroTypeDesc;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public static String[] getAvroDescriptions() {
        return avroDescriptions;
    }

    public static void setAvroDescriptions(String[] avroDescriptions) {
        AvroOutputField.avroDescriptions = avroDescriptions;
    }

    public static String[] mapAvroType(Schema schema, Schema.Type type) {
        Object[] avroTypeDesc = new String[1];
        switch (type) {
            case BOOLEAN: {
                avroTypeDesc[0] = avroDescriptions[1];
                break;
            }
            case DOUBLE: {
                avroTypeDesc[0] = avroDescriptions[2];
                break;
            }
            case FLOAT: {
                avroTypeDesc[0] = avroDescriptions[3];
                break;
            }
            case INT: {
                avroTypeDesc[0] = avroDescriptions[4];
                break;
            }
            case LONG: {
                avroTypeDesc[0] = avroDescriptions[5];
                break;
            }
            case STRING: {
                avroTypeDesc[0] = avroDescriptions[6];
                break;
            }
            case ENUM: {
                avroTypeDesc[0] = avroDescriptions[7];
                break;
            }
            case UNION: {
                List schemas = schema.getTypes();
                Iterator it = schemas.iterator();
                ArrayList<String[]> avroTypes = new ArrayList<String[]>();
                int arrayLength = 0;
                while (it.hasNext()) {
                    String[] unionAvroType;
                    Schema s = (Schema)it.next();
                    if (s.getType() == Schema.Type.NULL || (unionAvroType = AvroOutputField.mapAvroType(s, s.getType())).length <= 0) continue;
                    avroTypes.add(unionAvroType);
                    ++arrayLength;
                }
                Iterator itUnion = avroTypes.iterator();
                avroTypeDesc = new String[arrayLength];
                int i = 0;
                while (itUnion.hasNext()) {
                    String[] union;
                    for (String s : union = (String[])itUnion.next()) {
                        avroTypeDesc[i] = s;
                        ++i;
                    }
                }
                break;
            }
            default: {
                return new String[0];
            }
        }
        Arrays.sort(avroTypeDesc);
        return avroTypeDesc;
    }

    public boolean validate() throws HopException {
        if (this.avroType == 0 || this.avroType < 0 || this.avroType >= avroDescriptions.length) {
            throw new HopException("Validation error: Invalid Avro data type " + this.avroType);
        }
        if (this.name == null) {
            throw new HopException("Validation error: Stream field name is required.");
        }
        return true;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(AvroOutputField compareField) {
        return this.getAvroName() != null ? (compareField.getAvroName() != null ? this.getAvroName().compareTo(compareField.getAvroName()) : -1) : -1;
    }
}

