/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.AbstractManagedIdentitySource;
import com.microsoft.aad.msal4j.AppServiceManagedIdentitySource;
import com.microsoft.aad.msal4j.AzureArcManagedIdentitySource;
import com.microsoft.aad.msal4j.CloudShellManagedIdentitySource;
import com.microsoft.aad.msal4j.IEnvironmentVariables;
import com.microsoft.aad.msal4j.IMDSManagedIdentitySource;
import com.microsoft.aad.msal4j.ManagedIdentityApplication;
import com.microsoft.aad.msal4j.ManagedIdentityIdType;
import com.microsoft.aad.msal4j.ManagedIdentityParameters;
import com.microsoft.aad.msal4j.ManagedIdentityResponse;
import com.microsoft.aad.msal4j.ManagedIdentitySourceType;
import com.microsoft.aad.msal4j.MsalRequest;
import com.microsoft.aad.msal4j.ServiceBundle;
import com.microsoft.aad.msal4j.ServiceFabricManagedIdentitySource;
import com.microsoft.aad.msal4j.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ManagedIdentityClient {
    private static final Logger LOG = LoggerFactory.getLogger(ManagedIdentityClient.class);
    private static ManagedIdentitySourceType managedIdentitySourceType;
    AbstractManagedIdentitySource managedIdentitySource;

    protected static void resetManagedIdentitySourceType() {
        managedIdentitySourceType = ManagedIdentitySourceType.NONE;
    }

    static ManagedIdentitySourceType getManagedIdentitySource() {
        if (managedIdentitySourceType != null && managedIdentitySourceType != ManagedIdentitySourceType.NONE) {
            return managedIdentitySourceType;
        }
        IEnvironmentVariables environmentVariables = AbstractManagedIdentitySource.getEnvironmentVariables();
        managedIdentitySourceType = !StringHelper.isNullOrBlank(environmentVariables.getEnvironmentVariable("IDENTITY_ENDPOINT")) && !StringHelper.isNullOrBlank(environmentVariables.getEnvironmentVariable("IDENTITY_HEADER")) ? (!StringHelper.isNullOrBlank(environmentVariables.getEnvironmentVariable("IDENTITY_SERVER_THUMBPRINT")) ? ManagedIdentitySourceType.SERVICE_FABRIC : ManagedIdentitySourceType.APP_SERVICE) : (!StringHelper.isNullOrBlank(environmentVariables.getEnvironmentVariable("MSI_ENDPOINT")) ? ManagedIdentitySourceType.CLOUD_SHELL : (!StringHelper.isNullOrBlank(environmentVariables.getEnvironmentVariable("IDENTITY_ENDPOINT")) && !StringHelper.isNullOrBlank(environmentVariables.getEnvironmentVariable("IMDS_ENDPOINT")) ? ManagedIdentitySourceType.AZURE_ARC : ManagedIdentitySourceType.DEFAULT_TO_IMDS));
        return managedIdentitySourceType;
    }

    ManagedIdentityClient(MsalRequest msalRequest, ServiceBundle serviceBundle) {
        this.managedIdentitySource = ManagedIdentityClient.createManagedIdentitySource(msalRequest, serviceBundle);
        ManagedIdentityApplication managedIdentityApplication = (ManagedIdentityApplication)msalRequest.application();
        ManagedIdentityIdType identityIdType = managedIdentityApplication.getManagedIdentityId().getIdType();
        if (!identityIdType.equals((Object)ManagedIdentityIdType.SYSTEM_ASSIGNED)) {
            this.managedIdentitySource.setUserAssignedManagedIdentity(true);
            String userAssignedId = managedIdentityApplication.getManagedIdentityId().getUserAssignedId();
            if (identityIdType.equals((Object)ManagedIdentityIdType.CLIENT_ID)) {
                this.managedIdentitySource.setManagedIdentityUserAssignedClientId(userAssignedId);
            } else if (identityIdType.equals((Object)ManagedIdentityIdType.RESOURCE_ID)) {
                this.managedIdentitySource.setManagedIdentityUserAssignedResourceId(userAssignedId);
            }
        }
    }

    ManagedIdentityResponse getManagedIdentityResponse(ManagedIdentityParameters parameters) {
        return this.managedIdentitySource.getManagedIdentityResponse(parameters);
    }

    private static AbstractManagedIdentitySource createManagedIdentitySource(MsalRequest msalRequest, ServiceBundle serviceBundle) {
        if (managedIdentitySourceType == null || managedIdentitySourceType == ManagedIdentitySourceType.NONE) {
            managedIdentitySourceType = ManagedIdentityClient.getManagedIdentitySource();
        }
        switch (managedIdentitySourceType) {
            case SERVICE_FABRIC: {
                return ServiceFabricManagedIdentitySource.create(msalRequest, serviceBundle);
            }
            case APP_SERVICE: {
                return AppServiceManagedIdentitySource.create(msalRequest, serviceBundle);
            }
            case CLOUD_SHELL: {
                return CloudShellManagedIdentitySource.create(msalRequest, serviceBundle);
            }
            case AZURE_ARC: {
                return AzureArcManagedIdentitySource.create(msalRequest, serviceBundle);
            }
        }
        return new IMDSManagedIdentitySource(msalRequest, serviceBundle);
    }
}

