/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.ftpput;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.actions.util.FtpClientUtil;
import org.apache.hop.workflow.actions.util.FtpHelper;
import org.apache.hop.workflow.actions.util.IFtpConnection;
import org.w3c.dom.Node;

@Action(id="FTP_PUT", name="i18n::ActionFTPPut.Name", description="i18n::ActionFTPPut.Description", image="FTPPut.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.FileTransfer", keywords={"i18n::ActionFtpPut.keyword"}, documentationUrl="/workflow/actions/ftpput.html")
public class ActionFtpPut
extends ActionBase
implements Cloneable,
IAction,
IFtpConnection {
    private static final Class<?> PKG = ActionFtpPut.class;
    private static final String CONST_SPACE_SHORT = "      ";
    private static final String CONST_PASSWORD = "password";
    private static final String CONST_LOCAL_DIRECTORY = "localDirectory";
    public static final String FTP_DEFAULT_PORT = "21";
    public static final String FTP_DEFAULT_PROXY_PORT = "1080";
    private String serverName = null;
    private String serverPort = "21";
    private String userName;
    private String password;
    private String remoteDirectory = null;
    private String localDirectory = null;
    private String wildcard;
    private boolean binaryMode;
    private int timeout;
    private boolean remove;
    private boolean onlyPuttingNewFiles;
    private boolean activeConnection;
    private String controlEncoding;
    private String proxyHost;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private String socksProxyHost;
    private String socksProxyPort = "1080";
    private String socksProxyUsername;
    private String socksProxyPassword;
    private static final String LEGACY_CONTROL_ENCODING = "US-ASCII";
    private static final String DEFAULT_CONTROL_ENCODING = "ISO-8859-1";

    public ActionFtpPut(String n) {
        super(n, "");
        this.setControlEncoding(DEFAULT_CONTROL_ENCODING);
    }

    public ActionFtpPut() {
        this("");
    }

    public String getXml() {
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
        tags.put("servername", this.serverName);
        tags.put("serverport", this.serverPort);
        tags.put("username", this.userName);
        tags.put(CONST_PASSWORD, Encr.encryptPasswordIfNotUsingVariables((String)this.getPassword()));
        tags.put("remoteDirectory", this.remoteDirectory);
        tags.put(CONST_LOCAL_DIRECTORY, this.localDirectory);
        tags.put("wildcard", this.wildcard);
        tags.put("binary", this.binaryMode ? "Y" : "N");
        tags.put("timeout", String.valueOf(this.timeout));
        tags.put("remove", this.remove ? "Y" : "N");
        tags.put("only_new", this.onlyPuttingNewFiles ? "Y" : "N");
        tags.put("active", this.activeConnection ? "Y" : "N");
        tags.put("control_encoding", this.controlEncoding);
        tags.put("proxy_host", this.proxyHost);
        tags.put("proxy_port", this.proxyPort);
        tags.put("proxy_username", this.proxyUsername);
        tags.put("proxy_password", Encr.encryptPasswordIfNotUsingVariables((String)this.proxyPassword));
        tags.put("socksproxy_host", this.socksProxyHost);
        tags.put("socksproxy_port", this.socksProxyPort);
        tags.put("socksproxy_username", this.socksProxyUsername);
        tags.put("socksproxy_password", Encr.encryptPasswordIfNotUsingVariables((String)this.socksProxyPassword));
        StringBuilder xml = new StringBuilder(450);
        xml.append(super.getXml());
        tags.forEach((k, v) -> xml.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)k, (String)v)));
        return xml.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.serverName = this.extractString(entrynode, "servername");
            this.serverPort = this.extractString(entrynode, "serverport");
            this.userName = this.extractString(entrynode, "username");
            this.password = this.extractDecrypted(entrynode, CONST_PASSWORD);
            this.remoteDirectory = this.extractString(entrynode, "remoteDirectory");
            this.localDirectory = this.extractString(entrynode, CONST_LOCAL_DIRECTORY);
            this.wildcard = this.extractString(entrynode, "wildcard");
            this.binaryMode = this.extractBoolean(entrynode, "binary");
            this.timeout = this.extractTimeout(entrynode);
            this.remove = this.extractBoolean(entrynode, "remove");
            this.onlyPuttingNewFiles = this.extractBoolean(entrynode, "only_new");
            this.activeConnection = this.extractBoolean(entrynode, "active");
            this.controlEncoding = this.extractString(entrynode, "control_encoding");
            this.proxyHost = this.extractString(entrynode, "proxy_host");
            this.proxyPort = this.extractString(entrynode, "proxy_port");
            this.proxyUsername = this.extractString(entrynode, "proxy_username");
            this.proxyPassword = this.extractDecrypted(entrynode, "proxy_password");
            this.socksProxyHost = this.extractString(entrynode, "socksproxy_host");
            this.socksProxyPort = this.extractString(entrynode, "socksproxy_port");
            this.socksProxyUsername = this.extractString(entrynode, "socksproxy_username");
            this.socksProxyPassword = this.extractDecrypted(entrynode, "socksproxy_password");
            if (Utils.isEmpty((CharSequence)this.controlEncoding)) {
                this.controlEncoding = LEGACY_CONTROL_ENCODING;
            }
        }
        catch (HopXmlException ex) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"ActionFtpPut.Log.UnableToLoadFromXml", (String[])new String[0]), (Throwable)ex);
        }
    }

    public Object clone() {
        return super.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Result prevResult, int nr) throws HopException {
        prevResult.setResult(false);
        long filesPut = 0L;
        if (this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFtpPut.Log.Starting", (String[])new String[0]));
        }
        FTPClient ftpClient = null;
        try {
            ftpClient = this.prepareFtpClient();
            this.changeRemoteDirectory(ftpClient);
            String realLocalDirectory = this.resolveLocalDirectory();
            List<String> files = this.listLocalFiles(realLocalDirectory);
            Pattern pattern = this.createPattern(this.resolve(this.wildcard));
            for (String file : files) {
                if (this.parentWorkflow.isStopped()) break;
                if (!this.shouldProcessFile(file, pattern) || !this.uploadFile(ftpClient, realLocalDirectory, file)) continue;
                ++filesPut;
                this.deleteLocalFileIfNeeded(realLocalDirectory + Const.FILE_SEPARATOR + file);
            }
            prevResult.setResult(true);
            if (this.isBasic()) {
                this.logBasic(BaseMessages.getString(PKG, (String)"ActionFtpPut.Log.WeHavePut", (String[])new String[]{"" + filesPut}));
            }
        }
        catch (Exception e) {
            prevResult.setNrErrors(1L);
            this.logError(Const.getStackTracker((Throwable)e));
        }
        finally {
            this.closeFtpClient(ftpClient);
        }
        return prevResult;
    }

    public boolean isEvaluation() {
        return true;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies((IVariables)this, workflowMeta);
        FtpHelper.addServerResourceReferenceIfPresent(references, this.serverName, this, (IResourceHolder)this);
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "serverName", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, CONST_LOCAL_DIRECTORY, remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator(), ActionValidatorUtils.fileExistsValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "userName", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, CONST_PASSWORD, remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "serverPort", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.integerValidator()}));
    }

    private FTPClient prepareFtpClient() throws HopException {
        FTPClient ftpClient = this.createAndSetUpFtpClient();
        if (ftpClient == null || !ftpClient.isConnected()) {
            throw new HopException("Failed to connect FTP server.");
        }
        int code = ftpClient.getReplyCode();
        String msg = ftpClient.getReplyString();
        if (!FTPReply.isPositiveCompletion((int)code)) {
            throw new HopException("FTP server refused connection. reply code: " + code + ", result: " + msg);
        }
        if (this.isBasic()) {
            this.logBasic("FTP connection success, reply code: {0}, result: {1}", new Object[]{code, msg});
        }
        return ftpClient;
    }

    private void changeRemoteDirectory(FTPClient ftpClient) throws IOException {
        String realRemoteDirectory = this.resolve(this.remoteDirectory);
        if (Utils.isEmpty((CharSequence)realRemoteDirectory)) {
            return;
        }
        ftpClient.changeWorkingDirectory(realRemoteDirectory);
        if (this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFtpPut.Log.ChangedDirectory", (String[])new String[]{realRemoteDirectory}));
        }
    }

    private String resolveLocalDirectory() throws HopException, URISyntaxException {
        String realLocalDirectory = this.resolve(this.localDirectory);
        if (realLocalDirectory == null) {
            throw new HopException(BaseMessages.getString(PKG, (String)"ActionFtpPut.LocalDir.NotSpecified", (String[])new String[0]));
        }
        if (realLocalDirectory.startsWith("file:")) {
            realLocalDirectory = new URI(realLocalDirectory).getPath();
        }
        return realLocalDirectory;
    }

    private List<String> listLocalFiles(String localDir) {
        File[] children = new File(localDir).listFiles();
        if (children == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(children).filter(f -> !f.isDirectory()).map(File::getName).toList();
    }

    private Pattern createPattern(String wildcard) {
        return Utils.isEmpty((CharSequence)wildcard) ? null : Pattern.compile(wildcard);
    }

    private boolean shouldProcessFile(String file, Pattern pattern) {
        return pattern == null || pattern.matcher(file).matches();
    }

    private boolean uploadFile(FTPClient ftpClient, String localDir, String file) {
        boolean bl;
        block11: {
            String localFilename = localDir + Const.FILE_SEPARATOR + file;
            InputStream inputStream = HopVfs.getInputStream((String)localFilename);
            try {
                boolean success;
                boolean fileExist = FtpClientUtil.fileExists(ftpClient, file);
                if (fileExist && !this.onlyPuttingNewFiles) {
                    ftpClient.deleteFile(file);
                }
                if (this.binaryMode) {
                    ftpClient.setFileType(2);
                }
                if (!(success = ftpClient.storeFile(file, inputStream))) {
                    this.logError("Failed to upload file '" + localFilename + "' \u2192 " + ftpClient.getReplyString());
                }
                bl = success;
                if (inputStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.logError("Error uploading file: " + localFilename, e);
                    return false;
                }
            }
            inputStream.close();
        }
        return bl;
    }

    private void deleteLocalFileIfNeeded(String localFilename) throws IOException {
        if (this.remove) {
            Files.deleteIfExists(Path.of(localFilename, new String[0]));
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFtpPut.Log.DeletedFile", (String[])new String[]{localFilename}));
            }
        }
    }

    private void closeFtpClient(FTPClient ftpClient) {
        if (ftpClient != null && ftpClient.isConnected()) {
            try {
                ftpClient.quit();
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionFtpPut.Log.ErrorQuitingFTP", (String[])new String[]{e.getMessage()}));
            }
        }
        FtpClientUtil.clearSocksJvmSettings();
    }

    FTPClient createAndSetUpFtpClient() throws HopException {
        return FtpClientUtil.connectAndLogin(this.getLogChannel(), (IVariables)this, this, this.getName());
    }

    private boolean extractBoolean(Node node, String tagName) {
        return "Y".equalsIgnoreCase(this.extractString(node, tagName));
    }

    private int extractTimeout(Node node) {
        return Const.toInt((String)this.extractString(node, "timeout"), (int)10000);
    }

    private String extractDecrypted(Node node, String tagName) {
        return Encr.decryptPasswordOptionallyEncrypted((String)this.extractString(node, tagName));
    }

    private String extractString(Node node, String tagName) {
        return XmlHandler.getTagValue((Node)node, (String)tagName);
    }

    @Override
    @Generated
    public String getServerName() {
        return this.serverName;
    }

    @Override
    @Generated
    public String getServerPort() {
        return this.serverPort;
    }

    @Override
    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Override
    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getRemoteDirectory() {
        return this.remoteDirectory;
    }

    @Generated
    public String getLocalDirectory() {
        return this.localDirectory;
    }

    @Generated
    public String getWildcard() {
        return this.wildcard;
    }

    @Override
    @Generated
    public boolean isBinaryMode() {
        return this.binaryMode;
    }

    @Override
    @Generated
    public int getTimeout() {
        return this.timeout;
    }

    @Generated
    public boolean isRemove() {
        return this.remove;
    }

    @Generated
    public boolean isOnlyPuttingNewFiles() {
        return this.onlyPuttingNewFiles;
    }

    @Override
    @Generated
    public boolean isActiveConnection() {
        return this.activeConnection;
    }

    @Override
    @Generated
    public String getControlEncoding() {
        return this.controlEncoding;
    }

    @Override
    @Generated
    public String getProxyHost() {
        return this.proxyHost;
    }

    @Override
    @Generated
    public String getProxyPort() {
        return this.proxyPort;
    }

    @Override
    @Generated
    public String getProxyUsername() {
        return this.proxyUsername;
    }

    @Override
    @Generated
    public String getProxyPassword() {
        return this.proxyPassword;
    }

    @Override
    @Generated
    public String getSocksProxyHost() {
        return this.socksProxyHost;
    }

    @Override
    @Generated
    public String getSocksProxyPort() {
        return this.socksProxyPort;
    }

    @Override
    @Generated
    public String getSocksProxyUsername() {
        return this.socksProxyUsername;
    }

    @Override
    @Generated
    public String getSocksProxyPassword() {
        return this.socksProxyPassword;
    }

    @Generated
    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    @Generated
    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    @Generated
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setRemoteDirectory(String remoteDirectory) {
        this.remoteDirectory = remoteDirectory;
    }

    @Generated
    public void setLocalDirectory(String localDirectory) {
        this.localDirectory = localDirectory;
    }

    @Generated
    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    @Generated
    public void setBinaryMode(boolean binaryMode) {
        this.binaryMode = binaryMode;
    }

    @Generated
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Generated
    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    @Generated
    public void setOnlyPuttingNewFiles(boolean onlyPuttingNewFiles) {
        this.onlyPuttingNewFiles = onlyPuttingNewFiles;
    }

    @Generated
    public void setActiveConnection(boolean activeConnection) {
        this.activeConnection = activeConnection;
    }

    @Generated
    public void setControlEncoding(String controlEncoding) {
        this.controlEncoding = controlEncoding;
    }

    @Generated
    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    @Generated
    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    @Generated
    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    @Generated
    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    @Generated
    public void setSocksProxyHost(String socksProxyHost) {
        this.socksProxyHost = socksProxyHost;
    }

    @Generated
    public void setSocksProxyPort(String socksProxyPort) {
        this.socksProxyPort = socksProxyPort;
    }

    @Generated
    public void setSocksProxyUsername(String socksProxyUsername) {
        this.socksProxyUsername = socksProxyUsername;
    }

    @Generated
    public void setSocksProxyPassword(String socksProxyPassword) {
        this.socksProxyPassword = socksProxyPassword;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActionFtpPut)) {
            return false;
        }
        ActionFtpPut other = (ActionFtpPut)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isBinaryMode() != other.isBinaryMode()) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        if (this.isRemove() != other.isRemove()) {
            return false;
        }
        if (this.isOnlyPuttingNewFiles() != other.isOnlyPuttingNewFiles()) {
            return false;
        }
        if (this.isActiveConnection() != other.isActiveConnection()) {
            return false;
        }
        String this$serverName = this.getServerName();
        String other$serverName = other.getServerName();
        if (this$serverName == null ? other$serverName != null : !this$serverName.equals(other$serverName)) {
            return false;
        }
        String this$serverPort = this.getServerPort();
        String other$serverPort = other.getServerPort();
        if (this$serverPort == null ? other$serverPort != null : !this$serverPort.equals(other$serverPort)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$remoteDirectory = this.getRemoteDirectory();
        String other$remoteDirectory = other.getRemoteDirectory();
        if (this$remoteDirectory == null ? other$remoteDirectory != null : !this$remoteDirectory.equals(other$remoteDirectory)) {
            return false;
        }
        String this$localDirectory = this.getLocalDirectory();
        String other$localDirectory = other.getLocalDirectory();
        if (this$localDirectory == null ? other$localDirectory != null : !this$localDirectory.equals(other$localDirectory)) {
            return false;
        }
        String this$wildcard = this.getWildcard();
        String other$wildcard = other.getWildcard();
        if (this$wildcard == null ? other$wildcard != null : !this$wildcard.equals(other$wildcard)) {
            return false;
        }
        String this$controlEncoding = this.getControlEncoding();
        String other$controlEncoding = other.getControlEncoding();
        if (this$controlEncoding == null ? other$controlEncoding != null : !this$controlEncoding.equals(other$controlEncoding)) {
            return false;
        }
        String this$proxyHost = this.getProxyHost();
        String other$proxyHost = other.getProxyHost();
        if (this$proxyHost == null ? other$proxyHost != null : !this$proxyHost.equals(other$proxyHost)) {
            return false;
        }
        String this$proxyPort = this.getProxyPort();
        String other$proxyPort = other.getProxyPort();
        if (this$proxyPort == null ? other$proxyPort != null : !this$proxyPort.equals(other$proxyPort)) {
            return false;
        }
        String this$proxyUsername = this.getProxyUsername();
        String other$proxyUsername = other.getProxyUsername();
        if (this$proxyUsername == null ? other$proxyUsername != null : !this$proxyUsername.equals(other$proxyUsername)) {
            return false;
        }
        String this$proxyPassword = this.getProxyPassword();
        String other$proxyPassword = other.getProxyPassword();
        if (this$proxyPassword == null ? other$proxyPassword != null : !this$proxyPassword.equals(other$proxyPassword)) {
            return false;
        }
        String this$socksProxyHost = this.getSocksProxyHost();
        String other$socksProxyHost = other.getSocksProxyHost();
        if (this$socksProxyHost == null ? other$socksProxyHost != null : !this$socksProxyHost.equals(other$socksProxyHost)) {
            return false;
        }
        String this$socksProxyPort = this.getSocksProxyPort();
        String other$socksProxyPort = other.getSocksProxyPort();
        if (this$socksProxyPort == null ? other$socksProxyPort != null : !this$socksProxyPort.equals(other$socksProxyPort)) {
            return false;
        }
        String this$socksProxyUsername = this.getSocksProxyUsername();
        String other$socksProxyUsername = other.getSocksProxyUsername();
        if (this$socksProxyUsername == null ? other$socksProxyUsername != null : !this$socksProxyUsername.equals(other$socksProxyUsername)) {
            return false;
        }
        String this$socksProxyPassword = this.getSocksProxyPassword();
        String other$socksProxyPassword = other.getSocksProxyPassword();
        return !(this$socksProxyPassword == null ? other$socksProxyPassword != null : !this$socksProxyPassword.equals(other$socksProxyPassword));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ActionFtpPut;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isBinaryMode() ? 79 : 97);
        result = result * 59 + this.getTimeout();
        result = result * 59 + (this.isRemove() ? 79 : 97);
        result = result * 59 + (this.isOnlyPuttingNewFiles() ? 79 : 97);
        result = result * 59 + (this.isActiveConnection() ? 79 : 97);
        String $serverName = this.getServerName();
        result = result * 59 + ($serverName == null ? 43 : $serverName.hashCode());
        String $serverPort = this.getServerPort();
        result = result * 59 + ($serverPort == null ? 43 : $serverPort.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $remoteDirectory = this.getRemoteDirectory();
        result = result * 59 + ($remoteDirectory == null ? 43 : $remoteDirectory.hashCode());
        String $localDirectory = this.getLocalDirectory();
        result = result * 59 + ($localDirectory == null ? 43 : $localDirectory.hashCode());
        String $wildcard = this.getWildcard();
        result = result * 59 + ($wildcard == null ? 43 : $wildcard.hashCode());
        String $controlEncoding = this.getControlEncoding();
        result = result * 59 + ($controlEncoding == null ? 43 : $controlEncoding.hashCode());
        String $proxyHost = this.getProxyHost();
        result = result * 59 + ($proxyHost == null ? 43 : $proxyHost.hashCode());
        String $proxyPort = this.getProxyPort();
        result = result * 59 + ($proxyPort == null ? 43 : $proxyPort.hashCode());
        String $proxyUsername = this.getProxyUsername();
        result = result * 59 + ($proxyUsername == null ? 43 : $proxyUsername.hashCode());
        String $proxyPassword = this.getProxyPassword();
        result = result * 59 + ($proxyPassword == null ? 43 : $proxyPassword.hashCode());
        String $socksProxyHost = this.getSocksProxyHost();
        result = result * 59 + ($socksProxyHost == null ? 43 : $socksProxyHost.hashCode());
        String $socksProxyPort = this.getSocksProxyPort();
        result = result * 59 + ($socksProxyPort == null ? 43 : $socksProxyPort.hashCode());
        String $socksProxyUsername = this.getSocksProxyUsername();
        result = result * 59 + ($socksProxyUsername == null ? 43 : $socksProxyUsername.hashCode());
        String $socksProxyPassword = this.getSocksProxyPassword();
        result = result * 59 + ($socksProxyPassword == null ? 43 : $socksProxyPassword.hashCode());
        return result;
    }
}

