/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.NativeScalarFunction;
import org.apache.cassandra.cql3.functions.PartialScalarFunction;
import org.apache.cassandra.cql3.functions.ScalarFunction;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.transport.ProtocolVersion;

class PreComputedScalarFunction
extends NativeScalarFunction
implements PartialScalarFunction {
    private final ByteBuffer value;
    private final ProtocolVersion valueVersion;
    private final ScalarFunction function;
    private final List<ByteBuffer> parameters;

    PreComputedScalarFunction(AbstractType<?> returnType, ByteBuffer value, ProtocolVersion valueVersion, ScalarFunction function, List<ByteBuffer> parameters) {
        super("__constant__", returnType, new AbstractType[0]);
        this.value = value;
        this.valueVersion = valueVersion;
        this.function = function;
        this.parameters = parameters;
    }

    @Override
    public Function getFunction() {
        return this.function;
    }

    @Override
    public List<ByteBuffer> getPartialParameters() {
        return this.parameters;
    }

    @Override
    public ByteBuffer execute(ProtocolVersion protocolVersion, List<ByteBuffer> nothing) throws InvalidRequestException {
        if (protocolVersion == this.valueVersion) {
            return this.value;
        }
        return this.function.execute(protocolVersion, this.parameters);
    }

    @Override
    public ScalarFunction partialApplication(ProtocolVersion protocolVersion, List<ByteBuffer> nothing) throws InvalidRequestException {
        return this;
    }
}

