/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.credential.AzureSasCredential;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.specialized.BlockBlobClient;
import com.azure.storage.blob.specialized.SpecializedBlobClientBuilder;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.file.datalake.DataLakeDirectoryAsyncClient;
import com.azure.storage.file.datalake.DataLakeFileClient;
import com.azure.storage.file.datalake.DataLakePathClient;
import com.azure.storage.file.datalake.DataLakePathClientBuilder;
import com.azure.storage.file.datalake.DataLakeServiceVersion;
import com.azure.storage.file.datalake.Transforms;
import com.azure.storage.file.datalake.implementation.models.CpkInfo;
import com.azure.storage.file.datalake.implementation.models.FileSystemsListPathsHeaders;
import com.azure.storage.file.datalake.implementation.models.PathList;
import com.azure.storage.file.datalake.implementation.models.PathResourceType;
import com.azure.storage.file.datalake.implementation.util.DataLakeImplUtils;
import com.azure.storage.file.datalake.implementation.util.TransformUtils;
import com.azure.storage.file.datalake.models.CustomerProvidedKey;
import com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.azure.storage.file.datalake.models.DataLakeStorageException;
import com.azure.storage.file.datalake.models.PathHttpHeaders;
import com.azure.storage.file.datalake.models.PathInfo;
import com.azure.storage.file.datalake.models.PathItem;
import com.azure.storage.file.datalake.options.DataLakePathCreateOptions;
import com.azure.storage.file.datalake.options.DataLakePathDeleteOptions;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

@ServiceClient(builder=DataLakePathClientBuilder.class)
public class DataLakeDirectoryClient
extends DataLakePathClient {
    private static final ClientLogger LOGGER = new ClientLogger(DataLakeDirectoryClient.class);
    private final DataLakeDirectoryAsyncClient dataLakeDirectoryAsyncClient;

    DataLakeDirectoryClient(DataLakeDirectoryAsyncClient dataLakeDirectoryAsyncClient, BlockBlobClient blockBlobClient, HttpPipeline pipeline, String url, DataLakeServiceVersion serviceVersion, String accountName, String fileSystemName, String directoryName, AzureSasCredential sasToken, CpkInfo customerProvidedKey, boolean isTokenCredentialAuthenticated) {
        super(dataLakeDirectoryAsyncClient, blockBlobClient, pipeline, url, serviceVersion, accountName, fileSystemName, directoryName, PathResourceType.DIRECTORY, sasToken, customerProvidedKey, isTokenCredentialAuthenticated);
        this.dataLakeDirectoryAsyncClient = dataLakeDirectoryAsyncClient;
    }

    DataLakeDirectoryClient(DataLakePathClient dataLakePathClient) {
        super(dataLakePathClient.dataLakePathAsyncClient, dataLakePathClient.blockBlobClient, dataLakePathClient.getHttpPipeline(), dataLakePathClient.getAccountUrl(), dataLakePathClient.getServiceVersion(), dataLakePathClient.getAccountName(), dataLakePathClient.getFileSystemName(), Utility.urlEncode((String)dataLakePathClient.pathName), PathResourceType.DIRECTORY, dataLakePathClient.getSasToken(), dataLakePathClient.getCpkInfo(), dataLakePathClient.isTokenCredentialAuthenticated());
        this.dataLakeDirectoryAsyncClient = new DataLakeDirectoryAsyncClient(dataLakePathClient.dataLakePathAsyncClient);
    }

    public String getDirectoryUrl() {
        return this.getPathUrl();
    }

    public String getDirectoryPath() {
        return this.getObjectPath();
    }

    public String getDirectoryName() {
        return this.getObjectName();
    }

    @Override
    public DataLakeDirectoryClient getCustomerProvidedKeyClient(CustomerProvidedKey customerProvidedKey) {
        CpkInfo finalCustomerProvidedKey = null;
        if (customerProvidedKey != null) {
            finalCustomerProvidedKey = new CpkInfo().setEncryptionKey(customerProvidedKey.getKey()).setEncryptionKeySha256(customerProvidedKey.getKeySha256()).setEncryptionAlgorithm(customerProvidedKey.getEncryptionAlgorithm());
        }
        return new DataLakeDirectoryClient(this.dataLakeDirectoryAsyncClient.getCustomerProvidedKeyAsyncClient(customerProvidedKey), this.blockBlobClient.getCustomerProvidedKeyClient(Transforms.toBlobCustomerProvidedKey(customerProvidedKey)), this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getFileSystemName(), this.getObjectPath(), this.getSasToken(), finalCustomerProvidedKey, this.isTokenCredentialAuthenticated());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete() {
        this.deleteWithResponse(false, (DataLakeRequestConditions)null, (Duration)null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteRecursively() {
        this.deleteRecursivelyWithResponse(null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteRecursivelyWithResponse(DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        return this.deleteWithResponse(true, requestConditions, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(boolean recursive, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        return super.deleteWithResponse(recursive, requestConditions, timeout, context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean deleteIfExists() {
        return (Boolean)this.deleteIfExistsWithResponse(new DataLakePathDeleteOptions(), null, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> deleteIfExistsWithResponse(DataLakePathDeleteOptions options, Duration timeout, Context context) {
        return super.deleteIfExistsWithResponse(options, timeout, context);
    }

    public DataLakeFileClient getFileClient(String fileName) {
        Objects.requireNonNull(fileName, "'fileName' can not be set to null");
        String pathPrefix = this.getObjectPath().isEmpty() ? "" : this.getObjectPath() + "/";
        BlockBlobClient blockBlobClient = this.dataLakeDirectoryAsyncClient.prepareBuilderAppendPath(pathPrefix + fileName).buildBlockBlobClient();
        return new DataLakeFileClient(this.dataLakeDirectoryAsyncClient.getFileAsyncClient(fileName), blockBlobClient, this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getFileSystemName(), pathPrefix + fileName, this.getSasToken(), this.getCpkInfo(), this.isTokenCredentialAuthenticated());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeFileClient createFile(String fileName) {
        return this.createFile(fileName, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeFileClient createFile(String fileName, boolean overwrite) {
        DataLakeRequestConditions requestConditions = new DataLakeRequestConditions();
        if (!overwrite) {
            requestConditions.setIfNoneMatch("*");
        }
        return (DataLakeFileClient)this.createFileWithResponse(fileName, new DataLakePathCreateOptions().setRequestConditions(requestConditions), null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakeFileClient> createFileWithResponse(String fileName, String permissions, String umask, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        DataLakePathCreateOptions options = new DataLakePathCreateOptions().setPermissions(permissions).setUmask(umask).setPathHttpHeaders(headers).setMetadata(metadata).setRequestConditions(requestConditions);
        return this.createFileWithResponse(fileName, options, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakeFileClient> createFileWithResponse(String fileName, DataLakePathCreateOptions options, Duration timeout, Context context) {
        DataLakeFileClient dataLakeFileClient = this.getFileClient(fileName);
        Response<PathInfo> response = dataLakeFileClient.createWithResponse(options, timeout, context);
        return new SimpleResponse(response, (Object)dataLakeFileClient);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeFileClient createFileIfNotExists(String fileName) {
        return (DataLakeFileClient)this.createFileIfNotExistsWithResponse(fileName, new DataLakePathCreateOptions(), null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakeFileClient> createFileIfNotExistsWithResponse(String fileName, DataLakePathCreateOptions options, Duration timeout, Context context) {
        DataLakeFileClient dataLakeFileClient = this.getFileClient(fileName);
        Response<PathInfo> response = dataLakeFileClient.createIfNotExistsWithResponse(options, timeout, context);
        return new SimpleResponse(response, (Object)dataLakeFileClient);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteFile(String fileName) {
        this.deleteFileWithResponse(fileName, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteFileWithResponse(String fileName, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        return this.getFileClient(fileName).deleteWithResponse(requestConditions, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean deleteFileIfExists(String fileName) {
        return (Boolean)this.deleteFileIfExistsWithResponse(fileName, new DataLakePathDeleteOptions().setRequestConditions(new DataLakeRequestConditions()), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> deleteFileIfExistsWithResponse(String fileName, DataLakePathDeleteOptions options, Duration timeout, Context context) {
        return this.getFileClient(fileName).deleteIfExistsWithResponse(options, timeout, context);
    }

    public DataLakeDirectoryClient getSubdirectoryClient(String subdirectoryName) {
        Objects.requireNonNull(subdirectoryName, "'subdirectoryName' can not be set to null");
        String pathPrefix = this.getObjectPath().isEmpty() ? "" : this.getObjectPath() + "/";
        BlockBlobClient blockBlobClient = this.prepareBuilderAppendPath(pathPrefix + subdirectoryName).buildBlockBlobClient();
        return new DataLakeDirectoryClient(this.dataLakeDirectoryAsyncClient.getSubdirectoryAsyncClient(subdirectoryName), blockBlobClient, this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getFileSystemName(), pathPrefix + subdirectoryName, this.getSasToken(), this.getCpkInfo(), this.isTokenCredentialAuthenticated());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeDirectoryClient createSubdirectory(String subdirectoryName) {
        return this.createSubdirectory(subdirectoryName, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeDirectoryClient createSubdirectory(String subdirectoryName, boolean overwrite) {
        DataLakeRequestConditions requestConditions = new DataLakeRequestConditions();
        if (!overwrite) {
            requestConditions.setIfNoneMatch("*");
        }
        return (DataLakeDirectoryClient)this.createSubdirectoryWithResponse(subdirectoryName, new DataLakePathCreateOptions().setRequestConditions(requestConditions), null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakeDirectoryClient> createSubdirectoryWithResponse(String subdirectoryName, String permissions, String umask, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        DataLakePathCreateOptions options = new DataLakePathCreateOptions().setPermissions(permissions).setUmask(umask).setPathHttpHeaders(headers).setMetadata(metadata).setRequestConditions(requestConditions);
        return this.createSubdirectoryWithResponse(subdirectoryName, options, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakeDirectoryClient> createSubdirectoryWithResponse(String subdirectoryName, DataLakePathCreateOptions options, Duration timeout, Context context) {
        DataLakeDirectoryClient dataLakeDirectoryClient = this.getSubdirectoryClient(subdirectoryName);
        Response<PathInfo> response = dataLakeDirectoryClient.createWithResponse(options, timeout, context);
        return new SimpleResponse(response, (Object)dataLakeDirectoryClient);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeDirectoryClient createSubdirectoryIfNotExists(String subdirectoryName) {
        return (DataLakeDirectoryClient)this.createSubdirectoryIfNotExistsWithResponse(subdirectoryName, new DataLakePathCreateOptions(), null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakeDirectoryClient> createSubdirectoryIfNotExistsWithResponse(String subdirectoryName, DataLakePathCreateOptions options, Duration timeout, Context context) {
        DataLakeDirectoryClient dataLakeDirectoryClient = this.getSubdirectoryClient(subdirectoryName);
        Response<PathInfo> response = dataLakeDirectoryClient.createIfNotExistsWithResponse(options, timeout, context);
        return new SimpleResponse(response, (Object)dataLakeDirectoryClient);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteSubdirectory(String subdirectoryName) {
        this.deleteSubdirectoryWithResponse(subdirectoryName, false, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteSubdirectoryWithResponse(String subdirectoryName, boolean recursive, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        DataLakeDirectoryClient dataLakeDirectoryClient = this.getSubdirectoryClient(subdirectoryName);
        return dataLakeDirectoryClient.deleteWithResponse(recursive, requestConditions, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean deleteSubdirectoryIfExists(String subdirectoryName) {
        return (Boolean)this.deleteSubdirectoryIfExistsWithResponse(subdirectoryName, new DataLakePathDeleteOptions().setIsRecursive(false).setRequestConditions(new DataLakeRequestConditions()), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> deleteSubdirectoryIfExistsWithResponse(String subdirectoryName, DataLakePathDeleteOptions options, Duration timeout, Context context) {
        DataLakeDirectoryClient dataLakeDirectoryClient = this.getSubdirectoryClient(subdirectoryName);
        return dataLakeDirectoryClient.deleteIfExistsWithResponse(options, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeDirectoryClient rename(String destinationFileSystem, String destinationPath) {
        return (DataLakeDirectoryClient)this.renameWithResponse(destinationFileSystem, destinationPath, null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakeDirectoryClient> renameWithResponse(String destinationFileSystem, String destinationPath, DataLakeRequestConditions sourceRequestConditions, DataLakeRequestConditions destinationRequestConditions, Duration timeout, Context context) {
        Response<DataLakePathClient> response = this.renameWithResponseWithTimeout(destinationFileSystem, destinationPath, sourceRequestConditions, destinationRequestConditions, timeout, context);
        return new SimpleResponse(response, (Object)new DataLakeDirectoryClient((DataLakePathClient)response.getValue()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PathItem> listPaths() {
        return this.listPaths(false, false, null, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PathItem> listPaths(boolean recursive, boolean userPrincipleNameReturned, Integer maxResults, Duration timeout) {
        BiFunction<String, Integer, PagedResponse> retriever = (marker, pageSize) -> {
            Callable<ResponseBase> operation = () -> this.fileSystemDataLakeStorage.getFileSystems().listPathsWithResponse(recursive, null, null, (String)marker, this.getDirectoryPath(), pageSize == null ? maxResults : pageSize, userPrincipleNameReturned, Context.NONE);
            ResponseBase response = (ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, DataLakeStorageException.class);
            List value = response.getValue() == null ? Collections.emptyList() : ((PathList)response.getValue()).getPaths().stream().map(Transforms::toPathItem).collect(Collectors.toList());
            return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), value, ((FileSystemsListPathsHeaders)response.getDeserializedHeaders()).getXMsContinuation(), (Object)((FileSystemsListPathsHeaders)response.getDeserializedHeaders()));
        };
        return new PagedIterable(pageSize -> (PagedResponse)retriever.apply((String)null, (Integer)pageSize), retriever);
    }

    SpecializedBlobClientBuilder prepareBuilderAppendPath(String pathName) {
        String blobUrl = DataLakeImplUtils.endpointToDesiredEndpoint(this.getPathUrl(), "blob", "dfs");
        return new SpecializedBlobClientBuilder().pipeline(this.getHttpPipeline()).serviceVersion(TransformUtils.toBlobServiceVersion(this.getServiceVersion())).endpoint(blobUrl).blobName(pathName);
    }
}

