/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.sortedmerge;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hop.core.IRowSet;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.sortedmerge.RowSetRow;
import org.apache.hop.pipeline.transforms.sortedmerge.SortedMergeData;
import org.apache.hop.pipeline.transforms.sortedmerge.SortedMergeMeta;

public class SortedMerge
extends BaseTransform<SortedMergeMeta, SortedMergeData> {
    private static final Class<?> PKG = SortedMergeMeta.class;

    public SortedMerge(TransformMeta transformMeta, SortedMergeMeta meta, SortedMergeData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private synchronized Object[] getRowSorted() throws HopException {
        if (this.first) {
            this.first = false;
            ((SortedMergeData)this.data).sortedBuffer = new ArrayList<RowSetRow>();
            ((SortedMergeData)this.data).rowMeta = null;
            List inputRowSets = this.getInputRowSets();
            for (int i = inputRowSets.size() - 1; i >= 0 && !this.isStopped(); --i) {
                IRowSet rowSet = (IRowSet)inputRowSets.get(i);
                Object[] row = this.getRowFrom(rowSet);
                if (row != null) {
                    ((SortedMergeData)this.data).sortedBuffer.add(new RowSetRow(rowSet, rowSet.getRowMeta(), row));
                    if (((SortedMergeData)this.data).rowMeta == null) {
                        ((SortedMergeData)this.data).rowMeta = rowSet.getRowMeta().clone();
                    }
                    if (((SortedMergeData)this.data).fieldIndices == null) {
                        ((SortedMergeData)this.data).fieldIndices = new int[((SortedMergeMeta)this.meta).getFieldName().length];
                        for (int f = 0; f < ((SortedMergeData)this.data).fieldIndices.length; ++f) {
                            ((SortedMergeData)this.data).fieldIndices[f] = ((SortedMergeData)this.data).rowMeta.indexOfValue(((SortedMergeMeta)this.meta).getFieldName()[f]);
                            if (((SortedMergeData)this.data).fieldIndices[f] < 0) {
                                throw new HopTransformException("Unable to find fieldname [" + ((SortedMergeMeta)this.meta).getFieldName()[f] + "] in row : " + String.valueOf(((SortedMergeData)this.data).rowMeta));
                            }
                            ((SortedMergeData)this.data).rowMeta.getValueMeta(((SortedMergeData)this.data).fieldIndices[f]).setSortedDescending(!((SortedMergeMeta)this.meta).getAscending()[f]);
                        }
                    }
                }
                ((SortedMergeData)this.data).comparator = (o1, o2) -> {
                    try {
                        return o1.getRowMeta().compare(o1.getRowData(), o2.getRowData(), ((SortedMergeData)this.data).fieldIndices);
                    }
                    catch (HopValueException e) {
                        return 0;
                    }
                };
                Collections.sort(((SortedMergeData)this.data).sortedBuffer, ((SortedMergeData)this.data).comparator);
            }
        }
        if (((SortedMergeData)this.data).sortedBuffer.isEmpty()) {
            return null;
        }
        RowSetRow smallestRow = ((SortedMergeData)this.data).sortedBuffer.get(0);
        ((SortedMergeData)this.data).sortedBuffer.remove(0);
        Object[] outputRowData = smallestRow.getRowData();
        Object[] extraRow = this.getRowFrom(smallestRow.getRowSet());
        if (extraRow != null) {
            RowSetRow add = new RowSetRow(smallestRow.getRowSet(), smallestRow.getRowSet().getRowMeta(), extraRow);
            int index = Collections.binarySearch(((SortedMergeData)this.data).sortedBuffer, add, ((SortedMergeData)this.data).comparator);
            if (index < 0) {
                ((SortedMergeData)this.data).sortedBuffer.add(-index - 1, add);
            } else {
                ((SortedMergeData)this.data).sortedBuffer.add(index, add);
            }
        }
        if (this.getPipeline().isSafeModeEnabled()) {
            this.safeModeChecking(smallestRow.getRowMeta());
        }
        return outputRowData;
    }

    public boolean processRow() throws HopException {
        Object[] row = this.getRowSorted();
        if (row == null) {
            this.setOutputDone();
            return false;
        }
        this.putRow(((SortedMergeData)this.data).rowMeta, row);
        if (this.checkFeedback(this.getLinesRead()) && this.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"SortedMerge.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    public boolean init() {
        return super.init();
    }
}

