/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.function.Consumer;
import org.neo4j.driver.Query;
import org.neo4j.driver.internal.DatabaseBookmark;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.handlers.LegacyPullAllResponseHandler;
import org.neo4j.driver.internal.handlers.PullAllResponseHandler;
import org.neo4j.driver.internal.handlers.PullResponseCompletionListener;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.handlers.SessionPullResponseCompletionListener;
import org.neo4j.driver.internal.handlers.TransactionPullResponseCompletionListener;
import org.neo4j.driver.internal.handlers.pulln.AutoPullResponseHandler;
import org.neo4j.driver.internal.handlers.pulln.BasicPullResponseHandler;
import org.neo4j.driver.internal.handlers.pulln.PullResponseHandler;
import org.neo4j.driver.internal.messaging.v3.BoltProtocolV3;
import org.neo4j.driver.internal.spi.Connection;

public class PullHandlers {
    public static PullAllResponseHandler newBoltV3PullAllHandler(Query query, RunResponseHandler runHandler, Connection connection, Consumer<DatabaseBookmark> bookmarkConsumer, UnmanagedTransaction tx) {
        PullResponseCompletionListener completionListener = PullHandlers.createPullResponseCompletionListener(connection, bookmarkConsumer, tx);
        return new LegacyPullAllResponseHandler(query, runHandler, connection, BoltProtocolV3.METADATA_EXTRACTOR, completionListener);
    }

    public static PullAllResponseHandler newBoltV4AutoPullHandler(Query query, RunResponseHandler runHandler, Connection connection, Consumer<DatabaseBookmark> bookmarkConsumer, UnmanagedTransaction tx, long fetchSize) {
        PullResponseCompletionListener completionListener = PullHandlers.createPullResponseCompletionListener(connection, bookmarkConsumer, tx);
        return new AutoPullResponseHandler(query, runHandler, connection, BoltProtocolV3.METADATA_EXTRACTOR, completionListener, fetchSize);
    }

    public static PullResponseHandler newBoltV4BasicPullHandler(Query query, RunResponseHandler runHandler, Connection connection, Consumer<DatabaseBookmark> bookmarkConsumer, UnmanagedTransaction tx) {
        PullResponseCompletionListener completionListener = PullHandlers.createPullResponseCompletionListener(connection, bookmarkConsumer, tx);
        return new BasicPullResponseHandler(query, runHandler, connection, BoltProtocolV3.METADATA_EXTRACTOR, completionListener);
    }

    private static PullResponseCompletionListener createPullResponseCompletionListener(Connection connection, Consumer<DatabaseBookmark> bookmarkConsumer, UnmanagedTransaction tx) {
        return tx != null ? new TransactionPullResponseCompletionListener(tx) : new SessionPullResponseCompletionListener(connection, bookmarkConsumer);
    }
}

