/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.dorisbulkloader;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.serializer.xml.XmlMetadataUtil;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.dorisbulkloader.DorisBulkLoaderData;
import org.apache.hop.pipeline.transforms.dorisbulkloader.DorisBulkLoaderMeta;
import org.apache.hop.pipeline.transforms.dorisbulkloader.DorisHeader;
import org.apache.hop.pipeline.transforms.dorisbulkloader.DorisStreamLoad;
import org.apache.hop.pipeline.transforms.dorisbulkloader.DorisStreamLoadException;
import org.apache.hop.pipeline.transforms.dorisbulkloader.ResponseContent;
import org.apache.hop.pipeline.transforms.dorisbulkloader.StreamLoadProperty;

public class DorisBulkLoader
extends BaseTransform<DorisBulkLoaderMeta, DorisBulkLoaderData> {
    private static final Class<?> PKG = DorisBulkLoaderMeta.class;

    public DorisBulkLoader(TransformMeta transformMeta, DorisBulkLoaderMeta meta, DorisBulkLoaderData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        try {
            if (r == null) {
                this.setOutputDone();
                this.processStreamLoad(null, this.first);
                return false;
            }
            if (this.first) {
                ((DorisBulkLoaderData)this.data).inputRowMeta = this.getInputRowMeta();
                ((DorisBulkLoaderData)this.data).setIndexOfBodyField(this.resolve(((DorisBulkLoaderMeta)this.meta).getDataField()));
            }
            String rowString = Const.NVL((String)((DorisBulkLoaderData)this.data).inputRowMeta.getString(r, ((DorisBulkLoaderData)this.data).getIndexOfBodyField()), null);
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"DorisBulkLoader.Log.StreamLoadRowValue", (String[])new String[]{rowString}));
            }
            this.processStreamLoad(rowString, this.first);
            if (this.checkFeedback(this.getLinesRead()) && this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"DorisBulkLoader.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
            }
            this.putRow(this.getInputRowMeta(), r);
            this.incrementLinesOutput();
            if (this.first) {
                this.first = false;
            }
            return true;
        }
        catch (Exception e) {
            boolean sendToErrorRow = false;
            String errorMessage = null;
            if (!this.getTransformMeta().isDoingErrorHandling()) {
                this.logError(BaseMessages.getString(PKG, (String)"DorisBulkLoader.ErrorInTransformRunning", (String[])new String[0]) + e.getMessage());
                this.setErrors(1L);
                this.logError(Const.getStackTracker((Throwable)e));
                this.stopAll();
                this.setOutputDone();
                return false;
            }
            sendToErrorRow = true;
            errorMessage = e.toString();
            if (sendToErrorRow) {
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, BaseMessages.getString(PKG, (String)"DorisBulkLoader.ErrorCode", (String[])new String[0]));
            }
            return true;
        }
    }

    public void processStreamLoad(String streamLoadRow, boolean first) throws DorisStreamLoadException {
        block10: {
            try {
                byte[] record;
                if (streamLoadRow == null) {
                    if (!first) {
                        ((DorisBulkLoaderData)this.data).dorisStreamLoad.endWritingIntoBuffer();
                        ResponseContent responseContent = ((DorisBulkLoaderData)this.data).dorisStreamLoad.executeDorisStreamLoad();
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"DorisBulkLoader.Log.StreamLoadResult", (String[])new String[]{responseContent.toString()}));
                        }
                        ((DorisBulkLoaderData)this.data).dorisStreamLoad.close();
                    }
                    return;
                }
                if (first) {
                    this.initStreamLoad();
                    ((DorisBulkLoaderData)this.data).dorisStreamLoad.startWritingIntoBuffer();
                }
                if (((DorisBulkLoaderData)this.data).dorisStreamLoad.canWrite((record = streamLoadRow.getBytes(StandardCharsets.UTF_8)).length)) {
                    ((DorisBulkLoaderData)this.data).dorisStreamLoad.writeRecord(record);
                    break block10;
                }
                ((DorisBulkLoaderData)this.data).dorisStreamLoad.endWritingIntoBuffer();
                ResponseContent responseContent = ((DorisBulkLoaderData)this.data).dorisStreamLoad.executeDorisStreamLoad();
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"DorisBulkLoader.Log.StreamLoadResult", (String[])new String[]{responseContent.toString()}));
                }
                ((DorisBulkLoaderData)this.data).dorisStreamLoad.startWritingIntoBuffer();
                if (((DorisBulkLoaderData)this.data).dorisStreamLoad.canWrite(record.length)) {
                    ((DorisBulkLoaderData)this.data).dorisStreamLoad.writeRecord(record);
                    break block10;
                }
                throw new DorisStreamLoadException(BaseMessages.getString(PKG, (String)"DorisBulkLoader.Log.ExceedBufferLimit", (String[])new String[]{streamLoadRow}));
            }
            catch (Exception e) {
                if (e instanceof DorisStreamLoadException) {
                    DorisStreamLoadException dorisStreamLoadException = (DorisStreamLoadException)e;
                    throw dorisStreamLoadException;
                }
                throw new DorisStreamLoadException(e);
            }
        }
    }

    private void initStreamLoad() throws HopException {
        if (this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"DorisBulkLoader.Log.StreamLoadParameter", (String[])new String[]{XmlMetadataUtil.serializeObjectToXml((Object)this.meta)}));
        }
        StreamLoadProperty streamLoadProperty = new StreamLoadProperty();
        streamLoadProperty.setFeHost(this.resolve(((DorisBulkLoaderMeta)this.meta).getFeHost()));
        streamLoadProperty.setFeHttpPort(this.resolve(((DorisBulkLoaderMeta)this.meta).getFeHttpPort()));
        streamLoadProperty.setDatabaseName(this.resolve(((DorisBulkLoaderMeta)this.meta).getDatabaseName()));
        streamLoadProperty.setTableName(this.resolve(((DorisBulkLoaderMeta)this.meta).getTableName()));
        streamLoadProperty.setLoginUser(this.resolve(((DorisBulkLoaderMeta)this.meta).getLoginUser()));
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("format", this.resolve(((DorisBulkLoaderMeta)this.meta).getFormat()));
        httpHeaders.put("line_delimiter", this.resolve(((DorisBulkLoaderMeta)this.meta).getLineDelimiter()));
        httpHeaders.put("column_separator", this.resolve(((DorisBulkLoaderMeta)this.meta).getColumnDelimiter()));
        List<DorisHeader> headers = ((DorisBulkLoaderMeta)this.meta).getHeaders();
        for (DorisHeader header : headers) {
            httpHeaders.put(header.getName(), header.getValue());
        }
        streamLoadProperty.setHttpHeaders(httpHeaders);
        streamLoadProperty.setBufferSize(((DorisBulkLoaderMeta)this.meta).getBufferSize());
        streamLoadProperty.setBufferCount(((DorisBulkLoaderMeta)this.meta).getBufferCount());
        streamLoadProperty.setLoginPassword(this.resolve(((DorisBulkLoaderMeta)this.meta).getLoginPassword()));
        ((DorisBulkLoaderData)this.data).dorisStreamLoad = new DorisStreamLoad(streamLoadProperty);
    }
}

