/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p69p0.io.grpc.alts;

import javax.net.ssl.SSLException;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.auth.oauth2.ComputeEngineCredentials;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.CallCredentials;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.ChannelCredentials;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.CompositeChannelCredentials;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.Status;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.alts.FailingCallCredentials;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.alts.HandshakerServiceChannel;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.alts.InternalCheckGcpEnvironment;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.alts.internal.AltsProtocolNegotiator;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.auth.MoreCallCredentials;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.internal.SharedResourcePool;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.netty.GrpcSslContexts;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.netty.InternalNettyChannelCredentials;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.netty.InternalProtocolNegotiator;
import org.apache.beam.vendor.grpc.v1p69p0.io.netty.handler.ssl.SslContext;

public final class ComputeEngineChannelCredentials {
    private ComputeEngineChannelCredentials() {
    }

    public static ChannelCredentials create() {
        ChannelCredentials nettyCredentials = InternalNettyChannelCredentials.create(ComputeEngineChannelCredentials.createClientFactory());
        CallCredentials callCredentials = InternalCheckGcpEnvironment.isOnGcp() ? MoreCallCredentials.from(ComputeEngineCredentials.create()) : new FailingCallCredentials(Status.INTERNAL.withDescription("Compute Engine Credentials can only be used on Google Cloud Platform"));
        return CompositeChannelCredentials.create(nettyCredentials, callCredentials);
    }

    private static InternalProtocolNegotiator.ClientFactory createClientFactory() {
        SslContext sslContext;
        try {
            sslContext = GrpcSslContexts.forClient().build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
        return new AltsProtocolNegotiator.GoogleDefaultProtocolNegotiatorFactory(ImmutableList.of(), SharedResourcePool.forResource(HandshakerServiceChannel.SHARED_HANDSHAKER_CHANNEL), sslContext);
    }
}

