/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.numberrange;

import java.util.Objects;
import org.apache.hop.core.util.Utils;
import org.apache.hop.metadata.api.HopMetadataProperty;

public class NumberRangeRule {
    @HopMetadataProperty(key="lower_bound", injectionKey="LOWER_BOUND", injectionKeyDescription="NumberRangeMeta.Injection.LOWER_BOUND")
    private String lowerBound;
    @HopMetadataProperty(key="upper_bound", injectionKey="UPPER_BOUND", injectionKeyDescription="NumberRangeMeta.Injection.UPPER_BOUND")
    private String upperBound;
    @HopMetadataProperty(key="value", injectionKey="VALUE", injectionKeyDescription="NumberRangeMeta.Injection.VALUE")
    private String value;
    private double lowerBoundValue;
    private double upperBoundValue;

    public NumberRangeRule() {
    }

    public NumberRangeRule(String lowerBound, String upperBound, String value) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.value = value;
    }

    public void init() {
        try {
            this.lowerBoundValue = Utils.isEmpty((CharSequence)this.lowerBound) ? -1.7976931348623157E308 : Double.parseDouble(this.lowerBound);
            this.upperBoundValue = Utils.isEmpty((CharSequence)this.upperBound) ? Double.MAX_VALUE : Double.parseDouble(this.upperBound);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Bounds of this rule are not numeric: lowerBound=" + this.lowerBound + ", upperBound=" + this.upperBound + ", value=" + this.value, e);
        }
    }

    public String evaluate(double compareValue) {
        if (compareValue >= this.lowerBoundValue && compareValue < this.upperBoundValue) {
            return this.value;
        }
        return null;
    }

    public void setLowerBound(String value) {
        this.lowerBound = value;
    }

    public String getLowerBound() {
        return this.lowerBound;
    }

    public void setUpperBound(String value) {
        this.upperBound = value;
    }

    public String getUpperBound() {
        return this.upperBound;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        NumberRangeRule target = (NumberRangeRule)obj;
        return this.getLowerBound().equals(target.getLowerBound()) && this.getUpperBound().equals(target.getUpperBound()) && this.getValue().equals(target.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.lowerBound, this.upperBound, this.value);
    }
}

