/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.debug.transform;

import org.apache.hop.core.Const;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.debug.transform.TransformDebugLevel;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.ConditionEditor;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class TransformDebugLevelDialog
extends Dialog {
    private static final Class<?> PKG = TransformDebugLevelDialog.class;
    private TransformDebugLevel input;
    private TransformDebugLevel debugLevel;
    private IRowMeta inputRowMeta;
    private Shell shell;
    private Combo wLogLevel;
    private Text wStartRow;
    private Text wEndRow;
    private PropsUi props;
    private boolean ok;

    public TransformDebugLevelDialog(Shell par, TransformDebugLevel debugLevel, IRowMeta inputRowMeta) {
        super(par, 0);
        this.input = debugLevel;
        this.inputRowMeta = inputRowMeta;
        this.props = PropsUi.getInstance();
        this.ok = false;
        this.debugLevel = this.input.clone();
    }

    public boolean open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.shell.setImage(GuiResource.getInstance().getImageServer());
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin() + 2;
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setText("Transform debug Level");
        this.shell.setLayout((Layout)formLayout);
        Label wlName = new Label((Composite)this.shell, 131072);
        PropsUi.setLook((Widget)wlName);
        wlName.setText("Log level to set ");
        FormData fdlName = new FormData();
        fdlName.top = new FormAttachment(0, margin);
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        wlName.setLayoutData((Object)fdlName);
        this.wLogLevel = new Combo((Composite)this.shell, 18436);
        this.wLogLevel.setItems(LogLevel.getLogLevelDescriptions());
        PropsUi.setLook((Widget)this.wLogLevel);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment((Control)wlName, 0, 0x1000000);
        fdName.left = new FormAttachment(middle, 0);
        fdName.right = new FormAttachment(100, 0);
        this.wLogLevel.setLayoutData((Object)fdName);
        Combo lastControl = this.wLogLevel;
        Label wlStartRow = new Label((Composite)this.shell, 131072);
        PropsUi.setLook((Widget)wlStartRow);
        wlStartRow.setText("Start row ");
        FormData fdlStartRow = new FormData();
        fdlStartRow.top = new FormAttachment((Control)lastControl, margin);
        fdlStartRow.left = new FormAttachment(0, 0);
        fdlStartRow.right = new FormAttachment(middle, -margin);
        wlStartRow.setLayoutData((Object)fdlStartRow);
        this.wStartRow = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wStartRow);
        FormData fdStartRow = new FormData();
        fdStartRow.top = new FormAttachment((Control)wlStartRow, 0, 0x1000000);
        fdStartRow.left = new FormAttachment(middle, 0);
        fdStartRow.right = new FormAttachment(100, 0);
        this.wStartRow.setLayoutData((Object)fdStartRow);
        lastControl = this.wStartRow;
        Label wlEndRow = new Label((Composite)this.shell, 131072);
        PropsUi.setLook((Widget)wlEndRow);
        wlEndRow.setText("End row ");
        FormData fdlEndRow = new FormData();
        fdlEndRow.top = new FormAttachment((Control)lastControl, margin);
        fdlEndRow.left = new FormAttachment(0, 0);
        fdlEndRow.right = new FormAttachment(middle, -margin);
        wlEndRow.setLayoutData((Object)fdlEndRow);
        this.wEndRow = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wEndRow);
        FormData fdEndRow = new FormData();
        fdEndRow.top = new FormAttachment((Control)wlEndRow, 0, 0x1000000);
        fdEndRow.left = new FormAttachment(middle, 0);
        fdEndRow.right = new FormAttachment(100, 0);
        this.wEndRow.setLayoutData((Object)fdEndRow);
        lastControl = this.wEndRow;
        Button wOK = new Button((Composite)this.shell, 8);
        wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOK.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        Button[] buttons = new Button[]{wOK, wCancel};
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])buttons, (int)margin, null);
        Label wlCondition = new Label((Composite)this.shell, 131072);
        wlCondition.setText("Condition : ");
        PropsUi.setLook((Widget)wlCondition);
        FormData fdlCondition = new FormData();
        fdlCondition.top = new FormAttachment((Control)lastControl, margin);
        fdlCondition.left = new FormAttachment(0, 0);
        fdlCondition.right = new FormAttachment(middle, -margin);
        wlCondition.setLayoutData((Object)fdlCondition);
        ConditionEditor wCondition = new ConditionEditor((Composite)this.shell, 0, this.debugLevel.getCondition(), this.inputRowMeta);
        PropsUi.setLook((Widget)wCondition);
        FormData fdCondition = new FormData();
        fdCondition.top = new FormAttachment((Control)lastControl, margin);
        fdCondition.left = new FormAttachment(middle, 0);
        fdCondition.right = new FormAttachment(100, 0);
        fdCondition.bottom = new FormAttachment((Control)wOK, 0);
        wCondition.setLayoutData((Object)fdCondition);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.ok;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        this.wLogLevel.setText(this.debugLevel.getLogLevel().getDescription());
        this.wStartRow.setText(this.debugLevel.getStartRow() < 0 ? "" : Integer.toString(this.debugLevel.getStartRow()));
        this.wEndRow.setText(this.debugLevel.getEndRow() < 0 ? "" : Integer.toString(this.debugLevel.getEndRow()));
        this.wLogLevel.setFocus();
    }

    private void cancel() {
        this.ok = false;
        this.dispose();
    }

    public void ok() {
        this.getInfo(this.input);
        this.ok = true;
        this.dispose();
    }

    private void getInfo(TransformDebugLevel level) {
        int index = Const.indexOfString((String)this.wLogLevel.getText(), (String[])LogLevel.getLogLevelDescriptions());
        level.setLogLevel(LogLevel.values()[index]);
        level.setStartRow(Const.toInt((String)this.wStartRow.getText(), (int)-1));
        level.setEndRow(Const.toInt((String)this.wEndRow.getText(), (int)-1));
        level.setCondition(this.debugLevel.getCondition());
    }
}

