/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.s2a.internal.handshaker;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import io.grpc.s2a.internal.handshaker.S2AIdentity;
import io.grpc.s2a.internal.handshaker.S2AStub;
import io.grpc.s2a.internal.handshaker.SessionReq;
import io.grpc.s2a.internal.handshaker.SessionResp;
import io.grpc.s2a.internal.handshaker.ValidatePeerCertificateChainReq;
import io.grpc.s2a.internal.handshaker.ValidatePeerCertificateChainResp;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Optional;
import javax.annotation.concurrent.NotThreadSafe;
import javax.net.ssl.X509TrustManager;
import org.checkerframework.checker.nullness.qual.Nullable;

@NotThreadSafe
final class S2ATrustManager
implements X509TrustManager {
    private final Optional<S2AIdentity> localIdentity;
    private final S2AStub stub;
    private final String hostname;

    static S2ATrustManager createForClient(S2AStub stub, String hostname, Optional<S2AIdentity> localIdentity) {
        Preconditions.checkNotNull((Object)stub);
        Preconditions.checkNotNull((Object)hostname);
        return new S2ATrustManager(stub, hostname, localIdentity);
    }

    private S2ATrustManager(S2AStub stub, String hostname, Optional<S2AIdentity> localIdentity) {
        this.stub = stub;
        this.hostname = hostname;
        this.localIdentity = localIdentity;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkPeerTrusted(chain, true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkPeerTrusted(chain, false);
    }

    @Override
    public X509Certificate @Nullable [] getAcceptedIssuers() {
        return null;
    }

    private void checkPeerTrusted(X509Certificate[] chain, boolean isCheckingClientCertificateChain) throws CertificateException {
        SessionResp resp;
        Preconditions.checkNotNull((Object)chain);
        Preconditions.checkArgument((chain.length > 0 ? 1 : 0) != 0, (Object)"Certificate chain has zero certificates.");
        ValidatePeerCertificateChainReq.Builder validatePeerCertificateChainReq = ValidatePeerCertificateChainReq.newBuilder().setMode(ValidatePeerCertificateChainReq.VerificationMode.UNSPECIFIED);
        if (isCheckingClientCertificateChain) {
            validatePeerCertificateChainReq.setClientPeer(ValidatePeerCertificateChainReq.ClientPeer.newBuilder().addAllCertificateChain((Iterable<? extends ByteString>)S2ATrustManager.certificateChainToDerChain(chain)));
        } else {
            validatePeerCertificateChainReq.setServerPeer(ValidatePeerCertificateChainReq.ServerPeer.newBuilder().addAllCertificateChain((Iterable<? extends ByteString>)S2ATrustManager.certificateChainToDerChain(chain)).setServerHostname(this.hostname));
        }
        SessionReq.Builder reqBuilder = SessionReq.newBuilder().setValidatePeerCertificateChainReq(validatePeerCertificateChainReq);
        if (this.localIdentity.isPresent()) {
            reqBuilder.setLocalIdentity(this.localIdentity.get().getIdentity());
        }
        try {
            resp = this.stub.send(reqBuilder.build());
        }
        catch (IOException e) {
            throw new CertificateException("Failed to send request to S2A.", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CertificateException("Failed to send request to S2A.", e);
        }
        if (resp.hasStatus() && resp.getStatus().getCode() != 0) {
            throw new CertificateException(String.format("Error occurred in response from S2A, error code: %d, error message: %s.", resp.getStatus().getCode(), resp.getStatus().getDetails()));
        }
        if (!resp.hasValidatePeerCertificateChainResp()) {
            throw new CertificateException("No valid response received from S2A.");
        }
        ValidatePeerCertificateChainResp validationResult = resp.getValidatePeerCertificateChainResp();
        if (validationResult.getValidationResult() != ValidatePeerCertificateChainResp.ValidationResult.SUCCESS) {
            throw new CertificateException(validationResult.getValidationDetails());
        }
    }

    private static ImmutableList<ByteString> certificateChainToDerChain(X509Certificate[] chain) throws CertificateEncodingException {
        ImmutableList.Builder derChain = ImmutableList.builder();
        for (X509Certificate certificate : chain) {
            derChain.add((Object)ByteString.copyFrom((byte[])certificate.getEncoded()));
        }
        return derChain.build();
    }
}

