/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400PackedDecimal;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.DataArea;
import com.ibm.as400.access.DataAreaImpl;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.IllegalObjectTypeException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectAlreadyExistsException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.RemoteCommandImpl;
import com.ibm.as400.access.RemoteCommandImplRemote;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.Trace;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.UnknownHostException;

class DataAreaImplRemote
implements DataAreaImpl {
    private AS400ImplRemote system_;
    private String library_;
    private String name_;
    private QSYSObjectPathName ifsPathName_;
    private byte[] dataAreaSystemPathName_;
    private ConverterImplRemote converter_;
    private int ccsid_;
    private RemoteCommandImpl rmtCmd_;
    private AS400Message[] messageList_;
    private int length_;
    private boolean attributesRetrieved_;
    private int dataAreaType_ = 0;
    private static final QSYSObjectPathName PROGRAM_NAME = new QSYSObjectPathName("/QSYS.LIB/QWCRDTAA.PGM");
    private static final int RETURNED_DATA_FIXED_HEADER_LENGTH = 36;
    private static final boolean COMMAND_CALL = true;
    private static final boolean PROGRAM_CALL = false;
    private int decimalPositions_ = 5;

    DataAreaImplRemote() {
    }

    @Override
    public void clear() throws AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, ServerStartupException, UnknownHostException {
        String clrcmd = null;
        switch (this.dataAreaType_) {
            case 1: {
                clrcmd = "QSYS/CHGDTAARA DTAARA(" + this.library_ + "/" + this.name_ + ") VALUE(' ')";
                break;
            }
            case 2: {
                clrcmd = "QSYS/CHGDTAARA DTAARA(" + this.library_ + "/" + this.name_ + ") VALUE(0.0)";
                break;
            }
            case 3: {
                clrcmd = "QSYS/CHGDTAARA DTAARA(*LDA) VALUE(' ')";
                break;
            }
            case 4: {
                clrcmd = "QSYS/CHGDTAARA DTAARA(" + this.library_ + "/" + this.name_ + ") VALUE('0')";
                break;
            }
            default: {
                Trace.log(2, "Programming error: clear() was called as dataAreaType=" + this.dataAreaType_);
                throw new InternalErrorException(6, this.dataAreaType_);
            }
        }
        if (!this.run(clrcmd)) {
            DataAreaImplRemote.processExceptions(this.getMessages());
        }
    }

    @Override
    public void create(int length, String initialValue, String textDescription, String authority) throws AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectAlreadyExistsException, ObjectDoesNotExistException, ServerStartupException, UnknownHostException {
        if (this.dataAreaType_ != 1) {
            Trace.log(2, "Programming error: create(int,String,String,String) was called when dataAreaType=" + this.dataAreaType_);
            throw new InternalErrorException(6, this.dataAreaType_);
        }
        this.length_ = length;
        String crtcmd = "QSYS/CRTDTAARA DTAARA(" + this.library_ + "/" + this.name_ + ") TYPE(*CHAR) LEN(" + String.valueOf(this.length_) + " ) VALUE('" + initialValue + "') TEXT('" + textDescription + "') AUT(" + authority + ")";
        if (!this.run(crtcmd)) {
            this.processCreateExceptions(this.getMessages());
        }
        this.attributesRetrieved_ = true;
    }

    @Override
    public void create(int length, int decimalPositions, BigDecimal initialValue, String textDescription, String authority) throws AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectAlreadyExistsException, ObjectDoesNotExistException, ServerStartupException, UnknownHostException {
        if (this.dataAreaType_ != 2) {
            Trace.log(2, "Programming error: create(int,int,BigDecimal,String,String) was called when dataAreaType=" + this.dataAreaType_);
            throw new InternalErrorException(6, this.dataAreaType_);
        }
        this.length_ = length;
        this.decimalPositions_ = decimalPositions;
        String crtcmd = "QSYS/CRTDTAARA DTAARA(" + this.library_ + "/" + this.name_ + ") TYPE(*DEC) LEN(" + String.valueOf(this.length_) + " " + String.valueOf(this.decimalPositions_) + ") VALUE(" + initialValue.toString() + ") TEXT('" + textDescription + "') AUT(" + authority + ")";
        if (!this.run(crtcmd)) {
            this.processCreateExceptions(this.getMessages());
        }
        this.attributesRetrieved_ = true;
    }

    @Override
    public void create(boolean initialValue, String textDescription, String authority) throws AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectAlreadyExistsException, ObjectDoesNotExistException, ServerStartupException, UnknownHostException {
        if (this.dataAreaType_ != 4) {
            Trace.log(2, "Programming error: create(boolean,String,String) was called when dataAreaType=" + this.dataAreaType_);
            throw new InternalErrorException(6, this.dataAreaType_);
        }
        String crtcmd = "QSYS/CRTDTAARA DTAARA(" + this.library_ + "/" + this.name_ + ") TYPE(*LGL) LEN(1) VALUE('" + (initialValue ? "1" : "0") + "') TEXT('" + textDescription + "') AUT(" + authority + ")";
        if (!this.run(crtcmd)) {
            this.processCreateExceptions(this.getMessages());
        }
        this.attributesRetrieved_ = true;
    }

    @Override
    public void delete() throws AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, ServerStartupException, UnknownHostException {
        if (this.dataAreaType_ == 3) {
            Trace.log(2, "Programming error: delete() was called when dataAreaType=" + this.dataAreaType_);
            throw new InternalErrorException(6, this.dataAreaType_);
        }
        String dltcmd = "QSYS/DLTDTAARA DTAARA(" + this.library_ + "/" + this.name_ + ")";
        if (!this.run(dltcmd)) {
            DataAreaImplRemote.processExceptions(this.getMessages());
            return;
        }
        this.attributesRetrieved_ = false;
    }

    @Override
    public int getDecimalPositions() throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.dataAreaType_ != 2) {
            Trace.log(2, "Programming error: create(int,String,String,String) was called when dataAreaType=" + this.dataAreaType_);
            throw new InternalErrorException(6, this.dataAreaType_);
        }
        if (!this.attributesRetrieved_) {
            this.retrieveAttributes();
        }
        return this.decimalPositions_;
    }

    @Override
    public int getLength() throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.attributesRetrieved_) {
            this.retrieveAttributes();
        }
        return this.length_;
    }

    private AS400Message[] getMessages() {
        return this.messageList_;
    }

    void processCreateExceptions(AS400Message[] messageList) throws AS400SecurityException, ObjectAlreadyExistsException, ObjectDoesNotExistException, AS400Exception {
        if (messageList == null) {
            return;
        }
        for (int msg = 0; msg < messageList.length; ++msg) {
            Trace.log(2, messageList[msg].toString());
            String xid = messageList[msg].getID();
            if (xid.equals("CPF1023")) {
                Trace.log(2, "Re-throwing as ObjectAlreadyExistsException.");
                throw new ObjectAlreadyExistsException(1);
            }
            AS400Message[] ml = new AS400Message[]{messageList[msg]};
            DataAreaImplRemote.processExceptions(ml);
        }
    }

    static void processExceptions(AS400Message[] messageList) throws AS400SecurityException, ObjectDoesNotExistException, AS400Exception {
        if (messageList == null) {
            return;
        }
        int msg = 0;
        if (msg < messageList.length) {
            Trace.log(2, messageList[msg].toString());
            String xid = messageList[msg].getID();
            if (xid.equals("CPF1015")) {
                Trace.log(2, "Re-throwing as ObjectDoesNotExistException.");
                throw new ObjectDoesNotExistException(2);
            }
            if (xid.equals("CPF1016")) {
                Trace.log(2, "Re-throwing as AS400SecurityException.");
                throw new AS400SecurityException(4);
            }
            if (xid.equals("CPF1018")) {
                Trace.log(2, "Re-throwing as AS400SecurityException.");
                throw new AS400SecurityException(4);
            }
            if (xid.equals("CPF1021")) {
                Trace.log(2, "Re-throwing as ObjectDoesNotExistException.");
                throw new ObjectDoesNotExistException(1);
            }
            if (xid.equals("CPF1022")) {
                Trace.log(2, "Re-throwing as AS400SecurityException.");
                throw new AS400SecurityException(3);
            }
            if (xid.equals("CPF2105")) {
                Trace.log(2, "Re-throwing as ObjectDoesNotExistException.");
                throw new ObjectDoesNotExistException(2);
            }
            if (xid.equals("CPF2182")) {
                Trace.log(2, "Re-throwing as AS400SecurityException.");
                throw new AS400SecurityException(3);
            }
            if (xid.equals("CPF2189")) {
                Trace.log(2, "Re-throwing as AS400SecurityException.");
                throw new AS400SecurityException(4);
            }
            throw new AS400Exception(messageList[msg]);
        }
    }

    @Override
    public BigDecimal readBigDecimal() throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.dataAreaType_ != 2) {
            Trace.log(2, "Programming error: readBigDecimal() was called when dataAreaType=" + this.dataAreaType_);
            throw new InternalErrorException(6, this.dataAreaType_);
        }
        BigDecimal val = (BigDecimal)this.retrieveAttributes();
        return val;
    }

    @Override
    public boolean readBoolean() throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.dataAreaType_ != 4) {
            Trace.log(2, "Programming error: readBoolean() was called when dataAreaType=" + this.dataAreaType_);
            throw new InternalErrorException(6, this.dataAreaType_);
        }
        int lengthOfReceiverVariable = 37;
        byte[] dataReceived = this.retrieveDataAreaContents(lengthOfReceiverVariable, this.dataAreaSystemPathName_, -1, 1);
        String type = this.converter_.byteArrayToString(dataReceived, 8, 10).toUpperCase().trim();
        if (!type.equals("*LGL")) {
            if (type.equals("*CHAR")) {
                Trace.log(2, "Illegal data area type for logical data area object: " + type);
                throw new IllegalObjectTypeException(3);
            }
            if (type.equals("*DEC")) {
                Trace.log(2, "Illegal data area type for logical data area object: " + type);
                throw new IllegalObjectTypeException(4);
            }
            Trace.log(2, "Unknown data area type for logical data area object: " + type);
            throw new IOException(ResourceBundleLoader.getText("EXC_OBJECT_TYPE_UNKNOWN"));
        }
        this.length_ = BinaryConverter.byteArrayToInt(dataReceived, 28);
        if (this.length_ != 1) {
            Trace.log(2, "Logical data area length not valid: " + this.length_);
            throw new IOException(ResourceBundleLoader.getText("EXC_LENGTH_NOT_VALID"));
        }
        String val = this.converter_.byteArrayToString(dataReceived, 36, 1);
        boolean data = false;
        if (val.equals("1")) {
            data = true;
        } else if (!val.equals("0")) {
            Trace.log(2, "Data received not valid: " + val);
            throw new IOException(ResourceBundleLoader.getText("EXC_DATA_NOT_VALID"));
        }
        return data;
    }

    @Override
    public int readBytes(byte[] data, int dataBufferOffset, int dataAreaOffset, int dataLength) throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        int lengthOfReceiverVariable = 36 + dataLength;
        byte[] dataReceived = this.retrieveDataAreaContents(lengthOfReceiverVariable, this.dataAreaSystemPathName_, dataAreaOffset + 1, dataLength);
        int numBytesReturned = BinaryConverter.byteArrayToInt(dataReceived, 4);
        if ((numBytesReturned -= 36) > dataLength) {
            Trace.log(2, "Unexpected number of bytes returned: " + numBytesReturned);
            throw new InternalErrorException(6, numBytesReturned);
        }
        if (numBytesReturned < dataLength) {
            Trace.log(4, "Fewer bytes returned than requested: " + numBytesReturned);
        }
        System.arraycopy(dataReceived, 36, data, dataBufferOffset, numBytesReturned);
        return numBytesReturned;
    }

    private byte[] retrieveDataAreaContents(int lengthOfReceiverVariable, byte[] qualifiedDataAreaName, int startingPosition, int dataLength) throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        ProgramParameter[] parmlist = new ProgramParameter[6];
        byte[] dataReceived = new byte[lengthOfReceiverVariable];
        parmlist[0] = new ProgramParameter(dataReceived.length);
        byte[] receiverLength = new byte[4];
        BinaryConverter.intToByteArray(dataReceived.length, receiverLength, 0);
        parmlist[1] = new ProgramParameter(receiverLength);
        parmlist[2] = new ProgramParameter(qualifiedDataAreaName);
        byte[] startingPos = BinaryConverter.intToByteArray(startingPosition);
        parmlist[3] = new ProgramParameter(startingPos);
        byte[] lengthOfData = BinaryConverter.intToByteArray(dataLength);
        parmlist[4] = new ProgramParameter(lengthOfData);
        byte[] errorCode = new byte[17];
        BinaryConverter.intToByteArray(0, errorCode, 0);
        parmlist[5] = new ProgramParameter(errorCode, 17);
        if (this.rmtCmd_ == null) {
            this.setupRemoteCommand();
        }
        if (!this.rmtCmd_.runProgram("QSYS", "QWCRDTAA", parmlist)) {
            DataAreaImplRemote.processExceptions(this.rmtCmd_.getMessageList());
        }
        dataReceived = parmlist[0].getOutputData();
        if (Trace.isTraceOn() && Trace.isTraceDiagnosticOn()) {
            String areaType = DataArea.dataAreaTypeToString(this.dataAreaType_);
            Trace.log(1, areaType + " data area data retrieved:", dataReceived);
        }
        return dataReceived;
    }

    @Override
    public void refreshAttributes() throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.attributesRetrieved_ = false;
        this.retrieveAttributes();
    }

    @Override
    public String retrieve(int offset, int length) throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (AS400BidiTransform.isBidiCcsid(this.ccsid_)) {
            return this.retrieve(offset, length, AS400BidiTransform.getStringType((char)this.ccsid_));
        }
        return this.retrieve(offset, length, 0);
    }

    @Override
    public String retrieve(int offset, int length, int stringType) throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.dataAreaType_ != 1 && this.dataAreaType_ != 3) {
            Trace.log(2, "Programming error: retrieve(int,int) was called when dataAreaType=" + this.dataAreaType_);
            throw new InternalErrorException(6, this.dataAreaType_);
        }
        int lengthOfReceiverVariable = 4037;
        int startingPosition = offset == -1 ? offset : offset + 1;
        byte[] dataReceived = this.retrieveDataAreaContents(lengthOfReceiverVariable, this.dataAreaSystemPathName_, startingPosition, length);
        String type = this.converter_.byteArrayToString(dataReceived, 8, 10).toUpperCase().trim();
        if (!type.equals("*CHAR")) {
            if (type.equals("*DEC")) {
                Trace.log(2, "Illegal data area type for character data area object: " + type);
                throw new IllegalObjectTypeException(4);
            }
            if (type.equals("*LGL")) {
                Trace.log(2, "Illegal data area type for character data area object: " + type);
                throw new IllegalObjectTypeException(5);
            }
            Trace.log(2, "Illegal data area type for character data area object: " + type);
            throw new IOException(ResourceBundleLoader.getText("EXC_OBJECT_TYPE_UNKNOWN"));
        }
        if (offset == -1) {
            this.length_ = BinaryConverter.byteArrayToInt(dataReceived, 28);
        }
        int bytesReturned = BinaryConverter.byteArrayToInt(dataReceived, 4);
        return this.converter_.byteArrayToString(dataReceived, 36, bytesReturned -= 36, stringType);
    }

    private Object retrieveAttributes() throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        switch (this.dataAreaType_) {
            case 1: 
            case 3: {
                return this.retrieveAttributesString();
            }
            case 2: {
                return this.retrieveAttributesBigDecimal();
            }
            case 4: {
                return this.retrieveAttributesBoolean();
            }
        }
        Trace.log(2, "Programming error: retrieveAttributes() was called as dataAreaType=" + this.dataAreaType_);
        throw new InternalErrorException(6, this.dataAreaType_);
    }

    private Object retrieveAttributesBigDecimal() throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        int lengthOfReceiverVariable = 60;
        byte[] dataReceived = this.retrieveDataAreaContents(lengthOfReceiverVariable, this.dataAreaSystemPathName_, -1, 24);
        String type = this.converter_.byteArrayToString(dataReceived, 8, 10).toUpperCase().trim();
        if (!type.equals("*DEC")) {
            if (type.equals("*CHAR")) {
                Trace.log(2, "Illegal data area type for decimal data area object: " + type);
                throw new IllegalObjectTypeException(3);
            }
            if (type.equals("*LGL")) {
                Trace.log(2, "Illegal data area type for decimal data area object: " + type);
                throw new IllegalObjectTypeException(5);
            }
            Trace.log(2, "Illegal data area type for decimal data area object: " + type);
            throw new IOException(ResourceBundleLoader.getText("EXC_OBJECT_TYPE_UNKNOWN"));
        }
        this.length_ = BinaryConverter.byteArrayToInt(dataReceived, 28);
        this.decimalPositions_ = BinaryConverter.byteArrayToInt(dataReceived, 32);
        AS400PackedDecimal packedJava = new AS400PackedDecimal(this.length_, this.decimalPositions_);
        byte[] packed400 = new byte[24];
        System.arraycopy(dataReceived, 36, packed400, 0, 24);
        BigDecimal val = (BigDecimal)packedJava.toObject(packed400);
        this.attributesRetrieved_ = true;
        return val;
    }

    private Object retrieveAttributesBoolean() throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        boolean[] obj = new boolean[]{this.readBoolean()};
        this.attributesRetrieved_ = true;
        return obj;
    }

    private Object retrieveAttributesString() throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        String obj = this.retrieve(-1, 1);
        this.attributesRetrieved_ = true;
        return obj;
    }

    private boolean run(String command) throws AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException {
        boolean result = false;
        if (this.rmtCmd_ == null) {
            this.setupRemoteCommand();
        }
        result = this.rmtCmd_.runCommand(command);
        this.messageList_ = this.rmtCmd_.getMessageList();
        return result;
    }

    @Override
    public void setAttributes(AS400Impl system, QSYSObjectPathName path, int dataAreaType) throws IOException {
        this.setSystem((AS400ImplRemote)system);
        this.setPath(path);
        this.setType(dataAreaType);
    }

    private void setPath(QSYSObjectPathName path) throws CharConversionException, UnsupportedEncodingException {
        this.ifsPathName_ = path;
        this.library_ = this.ifsPathName_.getLibraryName();
        this.name_ = this.ifsPathName_.getObjectName();
        if (this.ccsid_ == 0) {
            this.ccsid_ = this.system_.getCcsid();
        }
        if (this.converter_ == null) {
            this.converter_ = ConverterImplRemote.getConverter(this.ccsid_, this.system_);
        }
        this.dataAreaSystemPathName_ = new byte[20];
        for (int i = 0; i < 20; ++i) {
            this.dataAreaSystemPathName_[i] = 64;
        }
        this.converter_.stringToByteArray(this.name_, this.dataAreaSystemPathName_, 0, 10);
        this.converter_.stringToByteArray(this.library_, this.dataAreaSystemPathName_, 10, 10);
    }

    private void setSystem(AS400ImplRemote system) {
        this.system_ = system;
    }

    private void setType(int dataAreaType) {
        switch (dataAreaType) {
            case 1: {
                this.length_ = 32;
                break;
            }
            case 2: {
                this.length_ = 15;
                break;
            }
            case 3: {
                this.length_ = 1024;
                break;
            }
            case 4: {
                this.length_ = 1;
                break;
            }
            default: {
                Trace.log(2, "Programming error: setType() was called with arg=" + dataAreaType);
                throw new InternalErrorException(6, dataAreaType);
            }
        }
        this.dataAreaType_ = dataAreaType;
    }

    protected synchronized void setupRemoteCommand() throws IOException {
        if (this.rmtCmd_ == null) {
            if (this.system_.canUseNativeOptimizations()) {
                try {
                    this.rmtCmd_ = (RemoteCommandImpl)Class.forName("com.ibm.as400.access.RemoteCommandImplNative").newInstance();
                }
                catch (Throwable e) {
                    Trace.log(4, "Unable to instantiate class RemoteCommandImplNative.", e);
                }
            }
            if (this.rmtCmd_ == null) {
                this.rmtCmd_ = new RemoteCommandImplRemote();
            }
            this.rmtCmd_.setSystem(this.system_);
        }
    }

    @Override
    public void write(String data, int dataAreaOffset) throws AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, ServerStartupException, UnknownHostException {
        if (AS400BidiTransform.isBidiCcsid(this.ccsid_)) {
            this.write(data, dataAreaOffset, AS400BidiTransform.getStringType((char)this.ccsid_));
        } else {
            this.write(data, dataAreaOffset, 0);
        }
    }

    @Override
    public void write(String data, int dataAreaOffset, int type) throws AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, ServerStartupException, UnknownHostException {
        byte[] part1;
        if (this.dataAreaType_ != 1 && this.dataAreaType_ != 3) {
            Trace.log(2, "Programming error: write(String,int) was called when dataAreaType=" + this.dataAreaType_);
            throw new InternalErrorException(6, this.dataAreaType_);
        }
        byte[] part2 = this.converter_.stringToByteArray(data, type);
        byte[] part3 = this.converter_.stringToByteArray("')");
        int dataLength = part2.length;
        int countSingleQuotePairs = 0;
        switch (this.dataAreaType_) {
            case 1: {
                int searchIndex = 0;
                while (searchIndex < data.length()) {
                    int foundIndex = data.indexOf("''", searchIndex);
                    if (foundIndex != -1) {
                        ++countSingleQuotePairs;
                        searchIndex = foundIndex + 2;
                        continue;
                    }
                    searchIndex = data.length();
                }
                part1 = this.converter_.stringToByteArray("QSYS/CHGDTAARA DTAARA(" + this.library_ + "/" + this.name_ + " (" + (dataAreaOffset + 1) + " " + (dataLength - countSingleQuotePairs) + ")) VALUE('");
                break;
            }
            case 3: {
                part1 = this.converter_.stringToByteArray("QSYS/CHGDTAARA DTAARA(*LDA (" + (dataAreaOffset + 1) + " " + dataLength + ")) VALUE('");
                break;
            }
            default: {
                Trace.log(2, "Programming error: write(String,int) was called as dataAreaType=" + this.dataAreaType_);
                throw new InternalErrorException(6, this.dataAreaType_);
            }
        }
        byte[] wrtcmd = new byte[part1.length + dataLength + part3.length];
        System.arraycopy(part1, 0, wrtcmd, 0, part1.length);
        System.arraycopy(part2, 0, wrtcmd, part1.length, dataLength);
        System.arraycopy(part3, 0, wrtcmd, part1.length + dataLength, part3.length);
        if (this.rmtCmd_ == null) {
            this.setupRemoteCommand();
        }
        if (Trace.isTraceOn()) {
            String wrtcmd2 = this.converter_.byteArrayToString(wrtcmd);
            Trace.log(1, "wrtcmd2=[" + wrtcmd2 + "]");
        }
        boolean result = this.rmtCmd_.runCommand(wrtcmd, "QSYS/CHGDTAARA");
        this.messageList_ = this.rmtCmd_.getMessageList();
        if (!result) {
            DataAreaImplRemote.processExceptions(this.getMessages());
        }
    }

    @Override
    public void write(BigDecimal data) throws AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, ServerStartupException, UnknownHostException {
        if (this.dataAreaType_ != 2) {
            Trace.log(2, "Programming error: write(BigDecimal) was called when dataAreaType=" + this.dataAreaType_);
            throw new InternalErrorException(6, this.dataAreaType_);
        }
        String wrtcmd = "QSYS/CHGDTAARA DTAARA(" + this.library_ + "/" + this.name_ + ") VALUE(" + data.toString() + ")";
        if (!this.run(wrtcmd)) {
            DataAreaImplRemote.processExceptions(this.getMessages());
        }
    }

    @Override
    public void write(boolean data) throws AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, ServerStartupException, UnknownHostException {
        if (this.dataAreaType_ != 4) {
            Trace.log(2, "Programming error: write(boolean) was called when dataAreaType=" + this.dataAreaType_);
            throw new InternalErrorException(6, this.dataAreaType_);
        }
        String wrtcmd = "QSYS/CHGDTAARA DTAARA(" + this.library_ + "/" + this.name_ + ") VALUE('" + (data ? "1" : "0") + "')";
        if (!this.run(wrtcmd)) {
            DataAreaImplRemote.processExceptions(this.getMessages());
        }
    }

    @Override
    public void write(byte[] data, int dataBufferOffset, int dataAreaOffset, int dataLength) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String dataAreaIdentifier = null;
        switch (this.dataAreaType_) {
            case 1: {
                dataAreaIdentifier = this.library_ + "/" + this.name_;
                break;
            }
            case 3: {
                dataAreaIdentifier = "*LDA";
                break;
            }
            default: {
                Trace.log(2, "Programming error: write(byte[],int,int,int) was called when dataAreaType=" + this.dataAreaType_);
                throw new InternalErrorException(6, this.dataAreaType_);
            }
        }
        String wrtcmd = "QSYS/CHGDTAARA DTAARA(" + dataAreaIdentifier + " (" + (dataAreaOffset + 1) + " " + dataLength + ")) VALUE(X'" + BinaryConverter.bytesToString(data, dataBufferOffset, dataLength) + "')";
        if (this.rmtCmd_ == null) {
            this.setupRemoteCommand();
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "wrtcmd=[" + wrtcmd + "]");
        }
        boolean result = this.rmtCmd_.runCommand(wrtcmd);
        this.messageList_ = this.rmtCmd_.getMessageList();
        if (!result) {
            DataAreaImplRemote.processExceptions(this.getMessages());
        }
    }
}

