/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.IFSDataStreamReq;

class IFSRenameReq
extends IFSDataStreamReq {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    private static final int SOURCE_CCSID_OFFSET = 22;
    private static final int TARGET_CCSID_OFFSET = 24;
    private static final int SOURCE_WORKING_DIR_HANDLE_OFFSET = 26;
    private static final int TARGET_WORKING_DIR_HANDLE_OFFSET = 30;
    private static final int RENAME_FLAGS_OFFSET = 34;
    private static final int SOURCE_NAME_LL_OFFSET = 36;
    private static final int SOURCE_NAME_CP_OFFSET = 40;
    private static final int SOURCE_NAME_OFFSET = 42;
    private static final int TEMPLATE_LENGTH = 16;

    IFSRenameReq(byte[] sourceName, byte[] targetName, int fileNameCCSID, boolean replaceTarget) {
        super(42 + sourceName.length + 6 + targetName.length);
        this.setLength(this.data_.length);
        this.setTemplateLen(16);
        this.setReqRepID(15);
        this.set16bit(fileNameCCSID, 22);
        this.set16bit(fileNameCCSID, 24);
        this.set32bit(1, 26);
        this.set32bit(1, 30);
        this.set16bit(replaceTarget ? 1 : 0, 34);
        this.set32bit(sourceName.length + 6, 36);
        this.set16bit(3, 40);
        System.arraycopy(sourceName, 0, this.data_, 42, sourceName.length);
        int targetNameLLOffset = 42 + sourceName.length;
        this.set32bit(targetName.length + 6, targetNameLLOffset);
        this.set16bit(4, targetNameLLOffset + 4);
        System.arraycopy(targetName, 0, this.data_, targetNameLLOffset + 6, targetName.length);
    }
}

