/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Blob;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLDatalink
extends SQLDataBase {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private int length_ = 0;
    private int maxLength_;
    private String value_;

    SQLDatalink(int maxLength, SQLConversionSettings settings) {
        super(settings);
        this.maxLength_ = maxLength;
        this.value_ = "";
    }

    @Override
    public Object clone() {
        return new SQLDatalink(this.maxLength_, this.settings_);
    }

    @Override
    public void convertFromRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter, boolean ignoreConversionErrors) throws SQLException {
        this.length_ = BinaryConverter.byteArrayToUnsignedShort(rawBytes, offset);
        this.value_ = ccsidConverter.byteArrayToString(rawBytes, offset + 2, this.length_);
    }

    @Override
    public void convertToRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter) throws SQLException {
        BinaryConverter.unsignedShortToByteArray(this.length_, rawBytes, offset);
        try {
            ccsidConverter.stringToByteArray(this.value_, rawBytes, offset + 2, this.length_);
        }
        catch (Exception e) {
            JDError.throwSQLException("HY000", e);
        }
    }

    @Override
    public void set(Object object, Calendar calendar, int scale) throws SQLException {
        if (object instanceof String) {
            this.value_ = (String)object;
        } else if (object instanceof URL) {
            this.value_ = ((URL)object).toExternalForm();
        } else {
            if (JDTrace.isTraceOn()) {
                if (object == null) {
                    JDTrace.logInformation(this, "Unable to assign null object");
                } else {
                    JDTrace.logInformation(this, "Unable to assign object(" + object + ") of class(" + object.getClass().toString() + ")");
                }
            }
            JDError.throwSQLException((Object)this, "07006");
        }
        this.length_ = this.value_.length();
    }

    @Override
    public int getSQLType() {
        return 9;
    }

    @Override
    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH", null);
    }

    @Override
    public int getDisplaySize() {
        return this.maxLength_;
    }

    @Override
    public String getJavaClassName() {
        return "java.net.URL";
    }

    @Override
    public String getLiteralPrefix() {
        return "'";
    }

    @Override
    public String getLiteralSuffix() {
        return "'";
    }

    @Override
    public String getLocalName() {
        return "DATALINK";
    }

    @Override
    public int getMaximumPrecision() {
        return 32717;
    }

    @Override
    public int getMaximumScale() {
        return 0;
    }

    @Override
    public int getMinimumScale() {
        return 0;
    }

    @Override
    public int getNativeType() {
        return 396;
    }

    @Override
    public int getPrecision() {
        return this.maxLength_;
    }

    @Override
    public int getRadix() {
        return 0;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public int getType() {
        return 70;
    }

    @Override
    public String getTypeName() {
        return "DATALINK";
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public boolean isText() {
        return true;
    }

    @Override
    public int getActualSize() {
        return this.value_.length();
    }

    @Override
    public int getTruncated() {
        return this.truncated_;
    }

    @Override
    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return new ByteArrayInputStream(ConvTable.getTable(819, null).stringToByteArray(this.value_));
        }
        catch (UnsupportedEncodingException e) {
            JDError.throwSQLException((Object)this, "HY000", e);
            return null;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int scale) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Blob getBlob() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return false;
    }

    @Override
    public byte getByte() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    @Override
    public byte[] getBytes() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public double getDouble() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0.0;
    }

    @Override
    public float getFloat() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0.0f;
    }

    @Override
    public int getInt() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    @Override
    public long getLong() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0L;
    }

    @Override
    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return new URL(this.value_);
        }
        catch (MalformedURLException e) {
            JDError.throwSQLException((Object)this, "07006", e);
            return null;
        }
    }

    @Override
    public short getShort() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    @Override
    public String getString() throws SQLException {
        return this.value_;
    }

    @Override
    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public String getNString() throws SQLException {
        return this.value_;
    }

    @Override
    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public SQLXML getSQLXML() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public void saveValue() throws SQLException {
        this.savedValue_ = this.value_;
    }
}

