/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import com.google.common.primitives.Bytes;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.util.Secret;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class GroupByEncryptedKey<@UnknownKeyFor K, @UnknownKeyFor V>
extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>> {
    private final @UnknownKeyFor @NonNull @Initialized Secret hmacKey;
    private final @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>>>>> gbk;

    private GroupByEncryptedKey(@UnknownKeyFor @NonNull @Initialized Secret hmacKey, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>>>>> gbk) {
        this.hmacKey = hmacKey;
        this.gbk = gbk;
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized GroupByEncryptedKey<K, V> create(@UnknownKeyFor @NonNull @Initialized Secret hmacKey) {
        return new GroupByEncryptedKey<K, V>(hmacKey, GroupByKey.create());
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized GroupByEncryptedKey<K, V> createWithCustomGbk(@UnknownKeyFor @NonNull @Initialized Secret hmacKey, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>>>>> gbk) {
        return new GroupByEncryptedKey<K, V>(hmacKey, gbk);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input) {
        Coder<KV<K, V>> inputCoder = input.getCoder();
        if (!(inputCoder instanceof KvCoder)) {
            throw new IllegalStateException("GroupByEncryptedKey requires its input to use KvCoder");
        }
        KvCoder inputKvCoder = (KvCoder)inputCoder;
        Coder keyCoder = inputKvCoder.getKeyCoder();
        try {
            keyCoder.verifyDeterministic();
        }
        catch (Coder.NonDeterministicException e) {
            throw new IllegalStateException("the keyCoder of a GroupByEncryptedKey must be deterministic", e);
        }
        Coder valueCoder = inputKvCoder.getValueCoder();
        PCollection<KV<byte[], Iterable<KV<byte[], byte[]>>>> grouped = ((PCollection)input.apply("EncryptMessage", ParDo.of(new EncryptMessage(this.hmacKey, keyCoder, valueCoder)))).apply(this.gbk);
        return ((PCollection)grouped.apply("DecryptMessage", ParDo.of(new DecryptMessage(this.hmacKey, keyCoder, valueCoder)))).setCoder(KvCoder.of(keyCoder, IterableCoder.of(valueCoder)));
    }

    private static class DecryptMessage<@UnknownKeyFor K, @UnknownKeyFor V>
    extends DoFn<KV<byte[], Iterable<KV<byte[], byte[]>>>, KV<K, Iterable<V>>> {
        private final @UnknownKeyFor @NonNull @Initialized Secret hmacKey;
        private final @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder;
        private final @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder;
        private transient @UnknownKeyFor @NonNull @Initialized Cipher cipher;
        private transient @UnknownKeyFor @NonNull @Initialized SecretKeySpec secretKeySpec;

        DecryptMessage(@UnknownKeyFor @NonNull @Initialized Secret hmacKey, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder) {
            this.hmacKey = hmacKey;
            this.keyCoder = keyCoder;
            this.valueCoder = valueCoder;
        }

        @DoFn.Setup
        public void setup() {
            try {
                this.cipher = Cipher.getInstance("AES/GCM/NoPadding");
                this.secretKeySpec = new SecretKeySpec(Base64.getUrlDecoder().decode(this.hmacKey.getSecretBytes()), "AES");
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to initialize cryptography libraries needed for GroupByEncryptedKey", ex);
            }
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
            HashMap decryptedKvs = new HashMap();
            for (KV kV : (Iterable)((KV)c.element()).getValue()) {
                byte[] iv = Arrays.copyOfRange((byte[])kV.getKey(), 0, 12);
                GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv);
                this.cipher.init(2, (Key)this.secretKeySpec, gcmParameterSpec);
                byte[] encryptedKey = Arrays.copyOfRange((byte[])kV.getKey(), 12, ((byte[])kV.getKey()).length);
                byte[] decryptedKeyBytes = this.cipher.doFinal(encryptedKey);
                K key = this.decode(this.keyCoder, decryptedKeyBytes);
                if (!decryptedKvs.containsKey(key)) {
                    decryptedKvs.put(key, new ArrayList());
                }
                iv = Arrays.copyOfRange((byte[])kV.getValue(), 0, 12);
                gcmParameterSpec = new GCMParameterSpec(128, iv);
                this.cipher.init(2, (Key)this.secretKeySpec, gcmParameterSpec);
                byte[] encryptedValue = Arrays.copyOfRange((byte[])kV.getValue(), 12, ((byte[])kV.getValue()).length);
                byte[] decryptedValueBytes = this.cipher.doFinal(encryptedValue);
                V value = this.decode(this.valueCoder, decryptedValueBytes);
                ((List)decryptedKvs.get(key)).add(value);
            }
            for (Map.Entry entry : decryptedKvs.entrySet()) {
                c.output(KV.of(entry.getKey(), (Iterable)entry.getValue()));
            }
        }

        private <T> T decode(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] bytes) throws @UnknownKeyFor @NonNull @Initialized Exception {
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            return coder.decode(is);
        }
    }

    private static class EncryptMessage<@UnknownKeyFor K, @UnknownKeyFor V>
    extends DoFn<KV<K, V>, KV<byte[], KV<byte[], byte[]>>> {
        private final @UnknownKeyFor @NonNull @Initialized Secret hmacKey;
        private final @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder;
        private final @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder;
        private transient @UnknownKeyFor @NonNull @Initialized Mac mac;
        private transient @UnknownKeyFor @NonNull @Initialized Cipher cipher;
        private transient @UnknownKeyFor @NonNull @Initialized SecretKeySpec secretKeySpec;
        private transient @UnknownKeyFor @NonNull @Initialized SecureRandom generator;

        EncryptMessage(@UnknownKeyFor @NonNull @Initialized Secret hmacKey, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder) {
            this.hmacKey = hmacKey;
            this.keyCoder = keyCoder;
            this.valueCoder = valueCoder;
        }

        @DoFn.Setup
        public void setup() {
            try {
                byte[] secretBytes = Base64.getUrlDecoder().decode(this.hmacKey.getSecretBytes());
                this.mac = Mac.getInstance("HmacSHA256");
                this.mac.init(new SecretKeySpec(secretBytes, "HmacSHA256"));
                this.cipher = Cipher.getInstance("AES/GCM/NoPadding");
                this.secretKeySpec = new SecretKeySpec(secretBytes, "AES");
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to initialize cryptography libraries needed for GroupByEncryptedKey", ex);
            }
            this.generator = new SecureRandom();
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
            byte[] encodedKey = this.encode(this.keyCoder, ((KV)c.element()).getKey());
            byte[] encodedValue = this.encode(this.valueCoder, ((KV)c.element()).getValue());
            byte[] hmac = this.mac.doFinal(encodedKey);
            byte[] keyIv = new byte[12];
            byte[] valueIv = new byte[12];
            this.generator.nextBytes(keyIv);
            this.generator.nextBytes(valueIv);
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, keyIv);
            this.cipher.init(1, (Key)this.secretKeySpec, gcmParameterSpec);
            byte[] encryptedKey = this.cipher.doFinal(encodedKey);
            gcmParameterSpec = new GCMParameterSpec(128, valueIv);
            this.cipher.init(1, (Key)this.secretKeySpec, gcmParameterSpec);
            byte[] encryptedValue = this.cipher.doFinal(encodedValue);
            c.output(KV.of(hmac, KV.of(Bytes.concat((byte[][])new byte[][]{keyIv, encryptedKey}), Bytes.concat((byte[][])new byte[][]{valueIv, encryptedValue}))));
        }

        private <T> @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] encode(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, T value) throws @UnknownKeyFor @NonNull @Initialized Exception {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            coder.encode(value, os);
            return os.toByteArray();
        }
    }
}

