/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.windowing.IncompatibleWindowException;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.MergeOverlappingIntervalWindows;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

public class Sessions
extends WindowFn<Object, IntervalWindow> {
    private final @UnknownKeyFor @NonNull @Initialized Duration gapDuration;

    public static @UnknownKeyFor @NonNull @Initialized Sessions withGapDuration(@UnknownKeyFor @NonNull @Initialized Duration gapDuration) {
        return new Sessions(gapDuration);
    }

    private Sessions(@UnknownKeyFor @NonNull @Initialized Duration gapDuration) {
        this.gapDuration = gapDuration;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized IntervalWindow> assignWindows(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized WindowFn. @UnknownKeyFor @NonNull @Initialized AssignContext c) {
        return Arrays.asList(new IntervalWindow(c.timestamp(), (ReadableDuration)this.gapDuration));
    }

    @Override
    public void mergeWindows(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized WindowFn. @UnknownKeyFor @NonNull @Initialized MergeContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        MergeOverlappingIntervalWindows.mergeWindows(c);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized IntervalWindow> windowCoder() {
        return IntervalWindow.getCoder();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isCompatible(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> other) {
        return other instanceof Sessions;
    }

    @Override
    public void verifyCompatibility(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> other) throws @UnknownKeyFor @NonNull @Initialized IncompatibleWindowException {
        if (!this.isCompatible(other)) {
            throw new IncompatibleWindowException(other, String.format("%s is only compatible with %s.", Sessions.class.getSimpleName(), Sessions.class.getSimpleName()));
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized IntervalWindow> getWindowTypeDescriptor() {
        return TypeDescriptor.of(IntervalWindow.class);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized WindowMappingFn<@UnknownKeyFor @NonNull @Initialized IntervalWindow> getDefaultWindowMappingFn() {
        throw new UnsupportedOperationException("Sessions is not allowed in side inputs");
    }

    public @UnknownKeyFor @NonNull @Initialized Duration getGapDuration() {
        return this.gapDuration;
    }

    @Override
    public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.add(DisplayData.item("gapDuration", this.gapDuration).withLabel("Session Gap Duration"));
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object object) {
        if (!(object instanceof Sessions)) {
            return false;
        }
        Sessions other = (Sessions)object;
        return this.getGapDuration().equals((Object)other.getGapDuration());
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.gapDuration);
    }
}

