/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.AutoValue_FailsafeValueInSingleWindow;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

@AutoValue
@Internal
public abstract class FailsafeValueInSingleWindow<@UnknownKeyFor T, @UnknownKeyFor ErrorT> {
    public abstract T getValue();

    public abstract @UnknownKeyFor @NonNull @Initialized Instant getTimestamp();

    public abstract @UnknownKeyFor @NonNull @Initialized BoundedWindow getWindow();

    public abstract @UnknownKeyFor @NonNull @Initialized PaneInfo getPaneInfo();

    public abstract ErrorT getFailsafeValue();

    public static <T, ErrorT> @UnknownKeyFor @NonNull @Initialized FailsafeValueInSingleWindow<T, ErrorT> of(T value, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo, ErrorT failsafeValue) {
        return new AutoValue_FailsafeValueInSingleWindow<T, ErrorT>(value, timestamp, window, paneInfo, failsafeValue);
    }

    public static class Coder<@UnknownKeyFor T, @UnknownKeyFor ErrorT>
    extends StructuredCoder<FailsafeValueInSingleWindow<T, ErrorT>> {
        private final @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<T> valueCoder;
        private final @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<ErrorT> failsafeValueCoder;
        private final @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<@UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder;

        public static <T, ErrorT> @UnknownKeyFor @NonNull @Initialized Coder<T, ErrorT> of(@UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<T> valueCoder, @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<ErrorT> failsafeValueCoder, @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder) {
            return new Coder<T, ErrorT>(valueCoder, failsafeValueCoder, windowCoder);
        }

        Coder(@UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<T> valueCoder, @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<ErrorT> failsafeValueCoder, @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder) {
            this.valueCoder = valueCoder;
            this.failsafeValueCoder = failsafeValueCoder;
            this.windowCoder = windowCoder;
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized FailsafeValueInSingleWindow<T, ErrorT> windowedElem, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.encode(windowedElem, outStream, Coder.Context.NESTED);
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized FailsafeValueInSingleWindow<T, ErrorT> windowedElem, @UnknownKeyFor @NonNull @Initialized OutputStream outStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException {
            InstantCoder.of().encode(windowedElem.getTimestamp(), outStream);
            this.windowCoder.encode(windowedElem.getWindow(), outStream);
            PaneInfo.PaneInfoCoder.INSTANCE.encode(windowedElem.getPaneInfo(), outStream);
            this.valueCoder.encode(windowedElem.getValue(), outStream);
            this.failsafeValueCoder.encode(windowedElem.getFailsafeValue(), outStream);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized FailsafeValueInSingleWindow<T, ErrorT> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return this.decode(inStream, Coder.Context.NESTED);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized FailsafeValueInSingleWindow<T, ErrorT> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException {
            Instant timestamp = InstantCoder.of().decode(inStream);
            BoundedWindow window = this.windowCoder.decode(inStream);
            PaneInfo paneInfo = PaneInfo.PaneInfoCoder.INSTANCE.decode(inStream);
            T value = this.valueCoder.decode(inStream);
            ErrorT failsafeValue = this.failsafeValueCoder.decode(inStream);
            return new AutoValue_FailsafeValueInSingleWindow<T, ErrorT>(value, timestamp, window, paneInfo, failsafeValue);
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
            return ImmutableList.of(this.valueCoder, this.failsafeValueCoder);
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getComponents() {
            return ImmutableList.of(this.valueCoder, this.failsafeValueCoder, this.windowCoder);
        }

        @Override
        public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
            this.valueCoder.verifyDeterministic();
            this.failsafeValueCoder.verifyDeterministic();
            this.windowCoder.verifyDeterministic();
        }
    }
}

