/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.tableoutput;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.Const;
import org.apache.hop.core.DbCache;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.exception.HopDatabaseBatchException;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.tableoutput.TableOutputData;
import org.apache.hop.pipeline.transforms.tableoutput.TableOutputField;
import org.apache.hop.pipeline.transforms.tableoutput.TableOutputMeta;

public class TableOutput
extends BaseTransform<TableOutputMeta, TableOutputData> {
    private static final Class<?> PKG = TableOutputMeta.class;
    public static final String NO_INCOMING_STREAM_FIELDS_AVAILABLE = "No incoming stream fields available";
    public static final String COULD_NOT_CLEAR_DATABASE_CACHE = "Could not clear database cache: ";
    public static final String COULD_NOT_RETRIEVE_TABLE_STRUCTURE_FOR = "Could not retrieve table structure for: ";
    public static final String COULD_NOT_ROLLBACK_TRANSACTION = "Could not rollback transaction: ";

    public TableOutput(TransformMeta transformMeta, TableOutputMeta meta, TableOutputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            if (this.first && ((TableOutputMeta)this.meta).isTruncateTable() && !((TableOutputMeta)this.meta).isOnlyWhenHaveRows()) {
                this.truncateTable();
            }
            return false;
        }
        if (this.first) {
            this.first = false;
            if (((TableOutputMeta)this.meta).isTruncateTable()) {
                this.truncateTable();
            }
            if (((TableOutputMeta)this.meta).isAutoUpdateTableStructure()) {
                this.updateTableStructure();
                if (((TableOutputData)this.data).preparedStatements != null) {
                    ((TableOutputData)this.data).preparedStatements.clear();
                    if (this.isDetailed()) {
                        this.logDetailed("Cleared prepared statement cache after table structure updates");
                    }
                }
            }
            ((TableOutputData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((TableOutputMeta)this.meta).getFields(((TableOutputData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            if (!((TableOutputMeta)this.meta).isSpecifyFields()) {
                ((TableOutputData)this.data).insertRowMeta = this.getInputRowMeta().clone();
            } else {
                TableOutputField tf;
                int i;
                ((TableOutputData)this.data).insertRowMeta = new RowMeta();
                ((TableOutputData)this.data).valuenrs = new int[((TableOutputMeta)this.meta).getFields().size()];
                for (i = 0; i < ((TableOutputMeta)this.meta).getFields().size(); ++i) {
                    tf = ((TableOutputMeta)this.meta).getFields().get(i);
                    ((TableOutputData)this.data).valuenrs[i] = this.getInputRowMeta().indexOfValue(tf.getFieldStream());
                    if (((TableOutputData)this.data).valuenrs[i] >= 0) continue;
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"TableOutput.Exception.FieldRequired", (String[])new String[]{tf.getFieldStream()}));
                }
                for (i = 0; i < ((TableOutputMeta)this.meta).getFields().size(); ++i) {
                    tf = ((TableOutputMeta)this.meta).getFields().get(i);
                    IValueMeta insValue = this.getInputRowMeta().searchValueMeta(tf.getFieldStream());
                    if (insValue == null) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"TableOutput.Exception.FailedToFindField", (String[])new String[]{tf.getFieldStream()}));
                    }
                    IValueMeta insertValue = insValue.clone();
                    insertValue.setName(tf.getFieldDatabase());
                    ((TableOutputData)this.data).insertRowMeta.addValueMeta(insertValue);
                }
            }
        }
        try {
            Object[] outputRowData = this.writeToTable(this.getInputRowMeta(), r);
            if (outputRowData != null) {
                this.putRow(((TableOutputData)this.data).outputRowMeta, outputRowData);
                this.incrementLinesOutput();
            }
            if (this.checkFeedback(this.getLinesRead()) && this.isBasic()) {
                this.logBasic("linenr " + this.getLinesRead());
            }
        }
        catch (HopException e) {
            this.logError("Because of an error, this transform can't continue: ", e);
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    protected Object[] writeToTable(IRowMeta rowMeta, Object[] r) throws HopException {
        Long generatedKey;
        boolean batchProblem;
        List exceptionsList;
        int[] updateCounts;
        boolean rowIsSafe;
        String errorMessage;
        boolean sendToErrorRow;
        Object[] outputRowData;
        block54: {
            Comparable<Date> partitioningValueData;
            Object[] insertRowData;
            if (r == null) {
                if (this.isDetailed()) {
                    this.logDetailed("Last line inserted: stop");
                }
                return null;
            }
            PreparedStatement insertStatement = null;
            outputRowData = r;
            Object tableName = null;
            sendToErrorRow = false;
            errorMessage = null;
            rowIsSafe = false;
            updateCounts = null;
            exceptionsList = null;
            batchProblem = false;
            generatedKey = null;
            if (((TableOutputMeta)this.meta).isTableNameInField()) {
                if (((TableOutputData)this.data).indexOfTableNameField < 0) {
                    String realTablename = this.resolve(((TableOutputMeta)this.meta).getTableNameField());
                    ((TableOutputData)this.data).indexOfTableNameField = rowMeta.indexOfValue(realTablename);
                    if (((TableOutputData)this.data).indexOfTableNameField < 0) {
                        String message = "Unable to find table name field [" + realTablename + "] in input row";
                        this.logError(message);
                        throw new HopTransformException(message);
                    }
                    if (!((TableOutputMeta)this.meta).isTableNameInTable() && !((TableOutputMeta)this.meta).isSpecifyFields()) {
                        ((TableOutputData)this.data).insertRowMeta.removeValueMeta(((TableOutputData)this.data).indexOfTableNameField);
                    }
                }
                tableName = rowMeta.getString(r, ((TableOutputData)this.data).indexOfTableNameField);
                insertRowData = !((TableOutputMeta)this.meta).isTableNameInTable() && !((TableOutputMeta)this.meta).isSpecifyFields() ? RowDataUtil.removeItem((Object[])rowMeta.cloneRow(r), (int)((TableOutputData)this.data).indexOfTableNameField) : r;
            } else if (((TableOutputMeta)this.meta).isPartitioningEnabled() && (((TableOutputMeta)this.meta).isPartitioningDaily() || ((TableOutputMeta)this.meta).isPartitioningMonthly()) && !Utils.isEmpty((CharSequence)((TableOutputMeta)this.meta).getPartitioningField())) {
                IValueMeta partitioningValue;
                if (((TableOutputData)this.data).indexOfPartitioningField < 0) {
                    ((TableOutputData)this.data).indexOfPartitioningField = rowMeta.indexOfValue(this.resolve(((TableOutputMeta)this.meta).getPartitioningField()));
                    if (((TableOutputData)this.data).indexOfPartitioningField < 0) {
                        throw new HopTransformException("Unable to find field [" + ((TableOutputMeta)this.meta).getPartitioningField() + "] in the input row!");
                    }
                    ((TableOutputData)this.data).dateFormater = ((TableOutputMeta)this.meta).isPartitioningDaily() ? new SimpleDateFormat("yyyyMMdd") : new SimpleDateFormat("yyyyMM");
                }
                if (!(partitioningValue = rowMeta.getValueMeta(((TableOutputData)this.data).indexOfPartitioningField)).isDate() || r[((TableOutputData)this.data).indexOfPartitioningField] == null) {
                    throw new HopTransformException("Sorry, the partitioning field needs to contain a data value and can't be empty!");
                }
                partitioningValueData = rowMeta.getDate(r, ((TableOutputData)this.data).indexOfPartitioningField);
                tableName = this.resolve(((TableOutputMeta)this.meta).getTableName()) + "_" + ((TableOutputData)this.data).dateFormater.format((Date)partitioningValueData);
                insertRowData = r;
            } else {
                tableName = ((TableOutputData)this.data).tableName;
                insertRowData = r;
            }
            if (((TableOutputMeta)this.meta).isSpecifyFields()) {
                insertRowData = new Object[((TableOutputData)this.data).valuenrs.length];
                for (int idx = 0; idx < ((TableOutputData)this.data).valuenrs.length; ++idx) {
                    insertRowData[idx] = r[((TableOutputData)this.data).valuenrs[idx]];
                }
            }
            if (Utils.isEmpty((CharSequence)tableName)) {
                throw new HopTransformException("The tablename is not defined (empty)");
            }
            insertStatement = ((TableOutputData)this.data).preparedStatements.get(tableName);
            if (insertStatement == null) {
                String sql = ((TableOutputData)this.data).db.getInsertStatement(this.resolve(((TableOutputMeta)this.meta).getSchemaName()), (String)tableName, ((TableOutputData)this.data).insertRowMeta);
                if (this.isDetailed()) {
                    this.logDetailed("Prepared statement : " + sql);
                }
                insertStatement = ((TableOutputData)this.data).db.prepareSql(sql, ((TableOutputMeta)this.meta).isReturningGeneratedKeys());
                ((TableOutputData)this.data).preparedStatements.put((String)tableName, insertStatement);
            }
            try {
                Integer commitCounter;
                if (((TableOutputData)this.data).useSafePoints) {
                    ((TableOutputData)this.data).savepoint = ((TableOutputData)this.data).db.setSavepoint();
                }
                ((TableOutputData)this.data).db.setValues(((TableOutputData)this.data).insertRowMeta, insertRowData, insertStatement);
                ((TableOutputData)this.data).db.insertRow(insertStatement, ((TableOutputData)this.data).batchMode, false);
                if (this.isRowLevel()) {
                    this.logRowlevel("Written row: " + ((TableOutputData)this.data).insertRowMeta.getString(insertRowData));
                }
                if ((commitCounter = ((TableOutputData)this.data).commitCounterMap.get(tableName)) == null) {
                    commitCounter = 1;
                } else {
                    partitioningValueData = commitCounter;
                    commitCounter = commitCounter + 1;
                }
                ((TableOutputData)this.data).commitCounterMap.put((String)tableName, commitCounter);
                if (((TableOutputData)this.data).useSafePoints && ((TableOutputData)this.data).releaseSavepoint) {
                    ((TableOutputData)this.data).db.releaseSavepoint(((TableOutputData)this.data).savepoint);
                }
                if (((TableOutputData)this.data).commitSize > 0 && commitCounter % ((TableOutputData)this.data).commitSize == 0) {
                    if (((TableOutputData)this.data).db.getUseBatchInsert(((TableOutputData)this.data).batchMode)) {
                        try {
                            insertStatement.executeBatch();
                            ((TableOutputData)this.data).db.commit();
                            insertStatement.clearBatch();
                        }
                        catch (SQLException ex) {
                            throw Database.createHopDatabaseBatchException((String)"Error updating batch", (SQLException)ex);
                        }
                        catch (Exception ex) {
                            throw new HopDatabaseException("Unexpected error inserting row", (Throwable)ex);
                        }
                    } else {
                        ((TableOutputData)this.data).db.commit();
                    }
                    ((TableOutputData)this.data).commitCounterMap.put((String)tableName, 0);
                    rowIsSafe = true;
                } else {
                    rowIsSafe = false;
                }
                if (!((TableOutputMeta)this.meta).isReturningGeneratedKeys()) break block54;
                RowMetaAndData extraKeys = ((TableOutputData)this.data).db.getGeneratedKeys(insertStatement);
                if (!extraKeys.getRowMeta().isEmpty()) {
                    generatedKey = extraKeys.getRowMeta().getInteger(extraKeys.getData(), 0);
                    break block54;
                }
                throw new HopTransformException("No generated keys while \"return generated keys\" is active!");
            }
            catch (HopDatabaseBatchException be) {
                errorMessage = be.toString();
                batchProblem = true;
                sendToErrorRow = true;
                updateCounts = be.getUpdateCounts();
                exceptionsList = be.getExceptionsList();
                if (this.getTransformMeta().isDoingErrorHandling()) {
                    ((TableOutputData)this.data).db.clearBatch(insertStatement);
                    ((TableOutputData)this.data).db.commit(true);
                }
                ((TableOutputData)this.data).db.clearBatch(insertStatement);
                ((TableOutputData)this.data).db.rollback();
                StringBuilder msg = new StringBuilder("Error batch inserting rows into table [" + (String)tableName + "].");
                msg.append(Const.CR);
                msg.append("Errors encountered (first 10):").append(Const.CR);
                for (int x = 0; x < be.getExceptionsList().size() && x < 10; ++x) {
                    Exception exception = (Exception)be.getExceptionsList().get(x);
                    if (exception.getMessage() == null) continue;
                    msg.append(exception.getMessage()).append(Const.CR);
                }
                throw new HopException(msg.toString(), (Throwable)be);
            }
            catch (HopDatabaseException dbe) {
                if (this.getTransformMeta().isDoingErrorHandling()) {
                    if (this.isRowLevel()) {
                        this.logRowlevel("Written row to error handling : " + this.getInputRowMeta().getString(r));
                    }
                    if (((TableOutputData)this.data).useSafePoints) {
                        ((TableOutputData)this.data).db.rollback(((TableOutputData)this.data).savepoint);
                        if (((TableOutputData)this.data).releaseSavepoint) {
                            ((TableOutputData)this.data).db.releaseSavepoint(((TableOutputData)this.data).savepoint);
                        }
                    }
                    sendToErrorRow = true;
                    errorMessage = dbe.toString();
                }
                if (((TableOutputMeta)this.meta).isIgnoreErrors()) {
                    if (((TableOutputData)this.data).warnings < 20) {
                        if (this.isBasic()) {
                            this.logBasic("WARNING: Couldn't insert row into table: " + rowMeta.getString(r) + Const.CR + dbe.getMessage());
                        }
                    } else if (((TableOutputData)this.data).warnings == 20 && this.isBasic()) {
                        this.logBasic("FINAL WARNING (no more then 20 displayed): Couldn't insert row into table: " + rowMeta.getString(r) + Const.CR + dbe.getMessage());
                    }
                    ++((TableOutputData)this.data).warnings;
                }
                this.setErrors(this.getErrors() + 1L);
                ((TableOutputData)this.data).db.rollback();
                throw new HopException("Error inserting row into table [" + (String)tableName + "] with values: " + rowMeta.getString(r), (Throwable)dbe);
            }
        }
        if (generatedKey != null) {
            outputRowData = RowDataUtil.addValueData((Object[])outputRowData, (int)rowMeta.size(), generatedKey);
        }
        if (((TableOutputData)this.data).batchMode) {
            if (sendToErrorRow) {
                if (batchProblem) {
                    ((TableOutputData)this.data).batchBuffer.add(outputRowData);
                    outputRowData = null;
                    this.processBatchException(errorMessage, updateCounts, exceptionsList);
                } else {
                    this.putError(rowMeta, r, 1L, errorMessage, null, "TOP001");
                    outputRowData = null;
                }
            } else {
                ((TableOutputData)this.data).batchBuffer.add(outputRowData);
                outputRowData = null;
                if (rowIsSafe) {
                    for (int i = 0; i < ((TableOutputData)this.data).batchBuffer.size(); ++i) {
                        Object[] row = ((TableOutputData)this.data).batchBuffer.get(i);
                        this.putRow(((TableOutputData)this.data).outputRowMeta, row);
                        this.incrementLinesOutput();
                    }
                    ((TableOutputData)this.data).batchBuffer.clear();
                }
            }
        } else if (sendToErrorRow) {
            this.putError(rowMeta, r, 1L, errorMessage, null, "TOP001");
            outputRowData = null;
        }
        return outputRowData;
    }

    private void processBatchException(String errorMessage, int[] updateCounts, List<Exception> exceptionsList) throws HopException {
        if (updateCounts != null) {
            int errNr = 0;
            for (int i = 0; i < updateCounts.length; ++i) {
                Object[] row = ((TableOutputData)this.data).batchBuffer.get(i);
                if (updateCounts[i] > 0) {
                    this.putRow(((TableOutputData)this.data).outputRowMeta, row);
                    this.incrementLinesOutput();
                    continue;
                }
                String exMessage = errorMessage;
                if (errNr < exceptionsList.size()) {
                    SQLException se = (SQLException)exceptionsList.get(errNr);
                    ++errNr;
                    exMessage = se.toString();
                }
                this.putError(((TableOutputData)this.data).outputRowMeta, row, 1L, exMessage, null, "TOP0002");
            }
        } else {
            for (int i = 0; i < ((TableOutputData)this.data).batchBuffer.size(); ++i) {
                Object[] row = ((TableOutputData)this.data).batchBuffer.get(i);
                this.putError(((TableOutputData)this.data).outputRowMeta, row, 1L, errorMessage, null, "TOP0003");
            }
        }
        ((TableOutputData)this.data).batchBuffer.clear();
    }

    public boolean init() {
        if (super.init()) {
            try {
                ((TableOutputData)this.data).commitSize = Integer.parseInt(this.resolve(((TableOutputMeta)this.meta).getCommitSize()));
                if (Utils.isEmpty((CharSequence)((TableOutputMeta)this.meta).getConnection())) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"TableOutput.Init.ConnectionMissing", (String[])new String[0]));
                }
                ((TableOutputData)this.data).databaseMeta = this.getPipelineMeta().findDatabase(((TableOutputMeta)this.meta).getConnection(), this.variables);
                IDatabase dbInterface = ((TableOutputData)this.data).databaseMeta.getIDatabase();
                ((TableOutputData)this.data).useSafePoints = ((TableOutputData)this.data).databaseMeta.getIDatabase().isUseSafePoints() && this.getTransformMeta().isDoingErrorHandling();
                ((TableOutputData)this.data).releaseSavepoint = dbInterface.isReleaseSavepoint();
                boolean bl = ((TableOutputData)this.data).batchMode = ((TableOutputMeta)this.meta).isUseBatchUpdate() && ((TableOutputData)this.data).commitSize > 0 && !((TableOutputMeta)this.meta).isReturningGeneratedKeys() && !((TableOutputData)this.data).useSafePoints;
                if (this.getTransformMeta().isDoingErrorHandling() && !dbInterface.IsSupportsErrorHandlingOnBatchUpdates() && this.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"TableOutput.Warning.ErrorHandlingIsNotFullySupportedWithBatchProcessing", (String[])new String[0]));
                }
                if (!dbInterface.supportsStandardTableOutput()) {
                    throw new HopException(dbInterface.getUnsupportedTableOutputMessage());
                }
                ((TableOutputData)this.data).db = new Database((ILoggingObject)this, (IVariables)this, ((TableOutputData)this.data).databaseMeta);
                ((TableOutputData)this.data).db.connect();
                if (this.isBasic()) {
                    this.logBasic("Connected to database [" + this.variables.resolve(((TableOutputMeta)this.meta).getConnection()) + "] (commit=" + ((TableOutputData)this.data).commitSize + ")");
                }
                if (((TableOutputData)this.data).commitSize == 0) {
                    ((TableOutputData)this.data).commitSize = Integer.MAX_VALUE;
                }
                ((TableOutputData)this.data).db.setCommit(((TableOutputData)this.data).commitSize);
                if (!((TableOutputMeta)this.meta).isPartitioningEnabled() && !((TableOutputMeta)this.meta).isTableNameInField()) {
                    ((TableOutputData)this.data).tableName = this.resolve(((TableOutputMeta)this.meta).getTableName());
                }
                return true;
            }
            catch (HopException e) {
                this.logError("An error occurred initializing this transform: " + e.getMessage());
                this.stopAll();
                this.setErrors(1L);
            }
        }
        return false;
    }

    void truncateTable() throws HopDatabaseException {
        if (!(((TableOutputMeta)this.meta).isPartitioningEnabled() || ((TableOutputMeta)this.meta).isTableNameInField() || !((TableOutputMeta)this.meta).isTruncateTable() || this.getCopy() != 0 && Utils.isEmpty((CharSequence)this.getPartitionId()))) {
            ((TableOutputData)this.data).db.truncateTable(this.resolve(((TableOutputMeta)this.meta).getSchemaName()), this.resolve(((TableOutputMeta)this.meta).getTableName()));
        }
    }

    void updateTableStructure() throws HopException {
        if (!((TableOutputMeta)this.meta).isPartitioningEnabled() && !((TableOutputMeta)this.meta).isTableNameInField() && this.getCopy() == 0 || !Utils.isEmpty((CharSequence)this.getPartitionId())) {
            String schemaName = this.resolve(((TableOutputMeta)this.meta).getSchemaName());
            String tableName = this.resolve(((TableOutputMeta)this.meta).getTableName());
            String fullTableName = ((TableOutputData)this.data).databaseMeta.getQuotedSchemaTableCombination((IVariables)this, schemaName, tableName);
            if (((TableOutputMeta)this.meta).isAlwaysDropAndRecreate()) {
                this.dropTable(fullTableName);
            }
            this.ensureTableExists(fullTableName, schemaName, tableName);
            if (((TableOutputMeta)this.meta).isAddColumns()) {
                this.addMissingColumns(fullTableName, schemaName, tableName);
            }
            if (((TableOutputMeta)this.meta).isDropColumns()) {
                this.dropSurplusColumns(fullTableName, schemaName, tableName);
            }
            if (((TableOutputMeta)this.meta).isChangeColumnTypes()) {
                this.changeColumnTypes(fullTableName, schemaName, tableName);
            }
        }
    }

    private void dropTable(String fullTableName) throws HopException {
        String dropSql;
        if (this.isBasic()) {
            this.logBasic("Dropping table: " + fullTableName);
        }
        if (!Utils.isEmpty((CharSequence)(dropSql = ((TableOutputData)this.data).databaseMeta.getDropTableIfExistsStatement(fullTableName)))) {
            try {
                ((TableOutputData)this.data).db.execStatement(dropSql);
                ((TableOutputData)this.data).db.commit();
                if (this.isBasic()) {
                    this.logBasic("Dropped table: " + fullTableName);
                }
            }
            catch (Exception e) {
                this.logDetailed("Drop table failed (may not exist): " + e.getMessage());
                try {
                    ((TableOutputData)this.data).db.rollback();
                    this.logDetailed("Rolled back transaction after drop table failure");
                }
                catch (Exception rollbackException) {
                    this.logDetailed(COULD_NOT_ROLLBACK_TRANSACTION + rollbackException.getMessage());
                }
            }
        }
    }

    void ensureTableExists(String fullTableName, String schemaName, String tableName) throws HopException {
        block8: {
            try {
                this.createTable(fullTableName);
            }
            catch (HopException e) {
                block7: {
                    if (this.isDetailed()) {
                        this.logDetailed("Table creation failed or table already exists, verifying...");
                    }
                    try {
                        ((TableOutputData)this.data).db.rollback();
                        if (this.isDetailed()) {
                            this.logDetailed("Rolled back transaction after create table failure in ensureTableExists");
                        }
                    }
                    catch (Exception rollbackException) {
                        if (!this.isDetailed()) break block7;
                        this.logDetailed(COULD_NOT_ROLLBACK_TRANSACTION + rollbackException.getMessage());
                    }
                }
                boolean tableExists = this.checkTableExists(schemaName, tableName, true);
                if (!tableExists) {
                    throw new HopException("Failed to create table " + fullTableName + " and table does not exist", (Throwable)e);
                }
                if (!this.isDetailed()) break block8;
                this.logDetailed("Table already exists: " + fullTableName);
            }
        }
    }

    private boolean checkTableExists(String schemaName, String tableName, boolean bypassCache) throws HopException {
        if (bypassCache) {
            try {
                DbCache.getInstance().clear(((TableOutputData)this.data).databaseMeta.getName());
                if (this.isDetailed()) {
                    this.logDetailed("Cleared database cache to ensure fresh table state");
                }
            }
            catch (Exception cacheException) {
                this.logError(COULD_NOT_CLEAR_DATABASE_CACHE + cacheException.getMessage());
            }
        }
        try {
            return ((TableOutputData)this.data).db.checkTableExists(schemaName, tableName);
        }
        catch (Exception e) {
            this.logDetailed("Table existence check failed, assuming table doesn't exist: " + e.getMessage());
            try {
                ((TableOutputData)this.data).db.rollback();
                this.logDetailed("Rolled back transaction after table existence check failure");
            }
            catch (Exception rollbackException) {
                this.logDetailed(COULD_NOT_ROLLBACK_TRANSACTION + rollbackException.getMessage());
            }
            return false;
        }
    }

    private void createTable(String fullTableName) throws HopException {
        IRowMeta inputRowMeta;
        String createSql;
        if (this.isBasic()) {
            this.logBasic("Creating table: " + fullTableName);
        }
        if (!Utils.isEmpty((CharSequence)(createSql = ((TableOutputData)this.data).db.getCreateTableStatement(fullTableName, inputRowMeta = this.getInputRowMeta(), null, false, null, true)))) {
            if (this.isDetailed()) {
                this.logDetailed("CREATE TABLE SQL: " + createSql);
            }
            ((TableOutputData)this.data).db.execStatement(createSql);
            ((TableOutputData)this.data).db.commit();
            if (this.isBasic()) {
                this.logBasic("Successfully created and committed table: " + fullTableName);
            }
            try {
                DbCache.getInstance().clear(((TableOutputData)this.data).databaseMeta.getName());
                if (this.isDetailed()) {
                    this.logDetailed("Cleared database cache after table creation");
                }
            }
            catch (Exception cacheException) {
                this.logError(COULD_NOT_CLEAR_DATABASE_CACHE + cacheException.getMessage());
            }
        }
    }

    private void addMissingColumns(String fullTableName, String schemaName, String tableName) throws HopException {
        block17: {
            if (this.isDetailed()) {
                this.logDetailed("Checking for missing columns in table: " + fullTableName);
            }
            try {
                IRowMeta tableFields = ((TableOutputData)this.data).db.getTableFieldsMeta(schemaName, tableName);
                if (tableFields == null) {
                    if (this.isDetailed()) {
                        this.logDetailed(COULD_NOT_RETRIEVE_TABLE_STRUCTURE_FOR + fullTableName);
                    }
                    return;
                }
                IRowMeta streamFields = this.getInputRowMeta();
                if (streamFields == null) {
                    if (this.isDetailed()) {
                        this.logDetailed(NO_INCOMING_STREAM_FIELDS_AVAILABLE);
                    }
                    return;
                }
                ArrayList<IValueMeta> missingColumns = new ArrayList<IValueMeta>();
                for (IValueMeta streamField : streamFields.getValueMetaList()) {
                    String fieldName = streamField.getName();
                    if (tableFields.searchValueMeta(fieldName) != null) continue;
                    missingColumns.add(streamField);
                    if (!this.isBasic()) continue;
                    this.logBasic("Found missing column: " + fieldName + " (" + streamField.getTypeDesc() + ")");
                }
                if (!missingColumns.isEmpty()) {
                    for (IValueMeta missingColumn : missingColumns) {
                        this.addColumn(fullTableName, missingColumn);
                    }
                    if (this.isBasic()) {
                        this.logBasic("Added " + missingColumns.size() + " missing column(s) to table: " + fullTableName);
                    }
                    try {
                        DbCache.getInstance().clear(((TableOutputData)this.data).databaseMeta.getName());
                        if (this.isDetailed()) {
                            this.logDetailed("Cleared database cache after adding columns");
                        }
                        break block17;
                    }
                    catch (Exception cacheException) {
                        this.logError(COULD_NOT_CLEAR_DATABASE_CACHE + cacheException.getMessage());
                    }
                    break block17;
                }
                if (this.isDetailed()) {
                    this.logDetailed("No missing columns found in table: " + fullTableName);
                }
            }
            catch (Exception e) {
                this.logError("Error checking/adding missing columns: " + e.getMessage(), e);
                try {
                    ((TableOutputData)this.data).db.rollback();
                    this.logDetailed("Rolled back transaction after add columns failure");
                }
                catch (Exception rollbackException) {
                    this.logDetailed(COULD_NOT_ROLLBACK_TRANSACTION + rollbackException.getMessage());
                }
                throw new HopException("Failed to add missing columns to table " + fullTableName, (Throwable)e);
            }
        }
    }

    private void addColumn(String fullTableName, IValueMeta column) throws HopException {
        if (this.isDetailed()) {
            this.logDetailed("Adding column: " + column.getName() + " to table: " + fullTableName);
        }
        try {
            String addColumnStatement = ((TableOutputData)this.data).databaseMeta.getAddColumnStatement(fullTableName, column, null, false, null, false);
            if (!Utils.isEmpty((CharSequence)addColumnStatement)) {
                if (this.isDetailed()) {
                    this.logDetailed("ALTER TABLE SQL: " + addColumnStatement);
                }
                ((TableOutputData)this.data).db.execStatement(addColumnStatement);
                ((TableOutputData)this.data).db.commit();
                if (this.isBasic()) {
                    this.logBasic("Successfully added column: " + column.getName());
                }
            }
        }
        catch (Exception e) {
            this.logError("Error adding column " + column.getName() + ": " + e.getMessage(), e);
            try {
                ((TableOutputData)this.data).db.rollback();
                this.logDetailed("Rolled back transaction after add column failure");
            }
            catch (Exception rollbackException) {
                this.logDetailed(COULD_NOT_ROLLBACK_TRANSACTION + rollbackException.getMessage());
            }
            throw new HopException("Failed to add column " + column.getName(), (Throwable)e);
        }
    }

    private void dropSurplusColumns(String fullTableName, String schemaName, String tableName) throws HopException {
        block18: {
            if (this.isDetailed()) {
                this.logDetailed("Checking for surplus columns in table: " + fullTableName);
            }
            try {
                IRowMeta tableFields = ((TableOutputData)this.data).db.getTableFieldsMeta(schemaName, tableName);
                if (tableFields == null) {
                    if (this.isDetailed()) {
                        this.logDetailed(COULD_NOT_RETRIEVE_TABLE_STRUCTURE_FOR + fullTableName);
                    }
                    return;
                }
                IRowMeta streamFields = this.getInputRowMeta();
                if (streamFields == null) {
                    if (this.isDetailed()) {
                        this.logDetailed(NO_INCOMING_STREAM_FIELDS_AVAILABLE);
                    }
                    return;
                }
                ArrayList<IValueMeta> surplusColumns = new ArrayList<IValueMeta>();
                for (IValueMeta tableField : tableFields.getValueMetaList()) {
                    String fieldName = tableField.getName();
                    if (streamFields.searchValueMeta(fieldName) != null) continue;
                    surplusColumns.add(tableField);
                    if (!this.isBasic()) continue;
                    this.logBasic("Found surplus column: " + fieldName + " (" + tableField.getTypeDesc() + ")");
                }
                if (!surplusColumns.isEmpty()) {
                    if (this.isBasic()) {
                        this.logBasic("WARNING: Dropping " + surplusColumns.size() + " column(s) from table: " + fullTableName + " - THIS WILL RESULT IN DATA LOSS");
                    }
                    for (IValueMeta surplusColumn : surplusColumns) {
                        this.dropColumn(fullTableName, surplusColumn);
                    }
                    if (this.isBasic()) {
                        this.logBasic("Dropped " + surplusColumns.size() + " surplus column(s) from table: " + fullTableName);
                    }
                    try {
                        DbCache.getInstance().clear(((TableOutputData)this.data).databaseMeta.getName());
                        if (this.isDetailed()) {
                            this.logDetailed("Cleared database cache after dropping columns");
                        }
                        break block18;
                    }
                    catch (Exception cacheException) {
                        this.logError(COULD_NOT_CLEAR_DATABASE_CACHE + cacheException.getMessage());
                    }
                    break block18;
                }
                if (this.isDetailed()) {
                    this.logDetailed("No surplus columns found in table: " + fullTableName);
                }
            }
            catch (Exception e) {
                this.logError("Error checking/dropping surplus columns: " + e.getMessage(), e);
                try {
                    ((TableOutputData)this.data).db.rollback();
                    this.logDetailed("Rolled back transaction after drop columns failure");
                }
                catch (Exception rollbackException) {
                    this.logDetailed(COULD_NOT_ROLLBACK_TRANSACTION + rollbackException.getMessage());
                }
                throw new HopException("Failed to drop surplus columns from table " + fullTableName, (Throwable)e);
            }
        }
    }

    private void dropColumn(String fullTableName, IValueMeta column) throws HopException {
        if (this.isDetailed()) {
            this.logDetailed("Dropping column: " + column.getName() + " from table: " + fullTableName);
        }
        try {
            String dropColumnStatement = ((TableOutputData)this.data).databaseMeta.getDropColumnStatement(fullTableName, column, null, false, null, false);
            if (!Utils.isEmpty((CharSequence)dropColumnStatement)) {
                if (this.isDetailed()) {
                    this.logDetailed("ALTER TABLE SQL: " + dropColumnStatement);
                }
                ((TableOutputData)this.data).db.execStatement(dropColumnStatement);
                ((TableOutputData)this.data).db.commit();
                if (this.isBasic()) {
                    this.logBasic("Successfully dropped column: " + column.getName());
                }
            }
        }
        catch (Exception e) {
            this.logError("Error dropping column " + column.getName() + ": " + e.getMessage(), e);
            try {
                ((TableOutputData)this.data).db.rollback();
                this.logDetailed("Rolled back transaction after drop column failure");
            }
            catch (Exception rollbackException) {
                this.logDetailed(COULD_NOT_ROLLBACK_TRANSACTION + rollbackException.getMessage());
            }
            throw new HopException("Failed to drop column " + column.getName(), (Throwable)e);
        }
    }

    private void changeColumnTypes(String fullTableName, String schemaName, String tableName) throws HopException {
        block18: {
            if (this.isDetailed()) {
                this.logDetailed("Checking for column type mismatches in table: " + fullTableName);
            }
            try {
                IRowMeta tableFields = ((TableOutputData)this.data).db.getTableFieldsMeta(schemaName, tableName);
                if (tableFields == null) {
                    if (this.isDetailed()) {
                        this.logDetailed(COULD_NOT_RETRIEVE_TABLE_STRUCTURE_FOR + fullTableName);
                    }
                    return;
                }
                IRowMeta streamFields = this.getInputRowMeta();
                if (streamFields == null) {
                    if (this.isDetailed()) {
                        this.logDetailed(NO_INCOMING_STREAM_FIELDS_AVAILABLE);
                    }
                    return;
                }
                ArrayList<IValueMeta> columnsToModify = new ArrayList<IValueMeta>();
                for (IValueMeta streamField : streamFields.getValueMetaList()) {
                    String fieldName = streamField.getName();
                    IValueMeta tableField = tableFields.searchValueMeta(fieldName);
                    if (tableField == null || this.typesAreCompatible(tableField, streamField)) continue;
                    columnsToModify.add(streamField);
                    if (!this.isBasic()) continue;
                    this.logBasic("Found type mismatch for column: " + fieldName + " (table: " + tableField.getTypeDesc() + ", stream: " + streamField.getTypeDesc() + ")");
                }
                if (!columnsToModify.isEmpty()) {
                    if (this.isBasic()) {
                        this.logBasic("WARNING: Changing data types for " + columnsToModify.size() + " column(s) in table: " + fullTableName + " - THIS MAY RESULT IN DATA LOSS");
                    }
                    for (IValueMeta columnToModify : columnsToModify) {
                        this.modifyColumn(fullTableName, columnToModify);
                    }
                    if (this.isBasic()) {
                        this.logBasic("Modified " + columnsToModify.size() + " column type(s) in table: " + fullTableName);
                    }
                    try {
                        DbCache.getInstance().clear(((TableOutputData)this.data).databaseMeta.getName());
                        if (this.isDetailed()) {
                            this.logDetailed("Cleared database cache after modifying column types");
                        }
                        break block18;
                    }
                    catch (Exception cacheException) {
                        this.logError(COULD_NOT_CLEAR_DATABASE_CACHE + cacheException.getMessage());
                    }
                    break block18;
                }
                if (this.isDetailed()) {
                    this.logDetailed("No column type mismatches found in table: " + fullTableName);
                }
            }
            catch (Exception e) {
                this.logError("Error checking/changing column types: " + e.getMessage(), e);
                try {
                    ((TableOutputData)this.data).db.rollback();
                    this.logDetailed("Rolled back transaction after change column types failure");
                }
                catch (Exception rollbackException) {
                    this.logDetailed(COULD_NOT_ROLLBACK_TRANSACTION + rollbackException.getMessage());
                }
                throw new HopException("Failed to change column types in table " + fullTableName, (Throwable)e);
            }
        }
    }

    boolean typesAreCompatible(IValueMeta tableField, IValueMeta streamField) {
        if (tableField.getType() == streamField.getType()) {
            if (tableField.getType() == 2) {
                int tableLength = tableField.getLength();
                int streamLength = streamField.getLength();
                if (streamLength > tableLength || streamLength < 0 && tableLength > 0) {
                    return false;
                }
            }
            return tableField.getType() != 1 && tableField.getType() != 6 || tableField.getPrecision() == streamField.getPrecision() && tableField.getLength() == streamField.getLength();
        }
        return false;
    }

    private void modifyColumn(String fullTableName, IValueMeta column) throws HopException {
        if (this.isDetailed()) {
            this.logDetailed("Modifying column: " + column.getName() + " to type: " + column.getTypeDesc() + " in table: " + fullTableName);
        }
        try {
            String addColumnStatement;
            String dropColumnStatement;
            if (this.isDetailed()) {
                this.logDetailed("Using drop/recreate approach for column type change: " + column.getName());
            }
            if (!Utils.isEmpty((CharSequence)(dropColumnStatement = ((TableOutputData)this.data).databaseMeta.getDropColumnStatement(fullTableName, column, null, false, null, false)))) {
                if (this.isDetailed()) {
                    this.logDetailed("DROP COLUMN SQL: " + dropColumnStatement);
                }
                ((TableOutputData)this.data).db.execStatement(dropColumnStatement);
                ((TableOutputData)this.data).db.commit();
                if (this.isDetailed()) {
                    this.logDetailed("Dropped column: " + column.getName());
                }
            }
            if (!Utils.isEmpty((CharSequence)(addColumnStatement = ((TableOutputData)this.data).databaseMeta.getAddColumnStatement(fullTableName, column, null, false, null, false)))) {
                if (this.isDetailed()) {
                    this.logDetailed("ADD COLUMN SQL: " + addColumnStatement);
                }
                ((TableOutputData)this.data).db.execStatement(addColumnStatement);
                ((TableOutputData)this.data).db.commit();
                if (this.isDetailed()) {
                    this.logDetailed("Added column with new type: " + column.getName());
                }
            }
            if (this.isBasic()) {
                this.logBasic("Successfully modified column type (via drop/recreate): " + column.getName());
            }
        }
        catch (Exception e) {
            this.logError("Error modifying column " + column.getName() + ": " + e.getMessage(), e);
            try {
                ((TableOutputData)this.data).db.rollback();
                this.logDetailed("Rolled back transaction after modify column failure");
            }
            catch (Exception rollbackException) {
                this.logDetailed(COULD_NOT_ROLLBACK_TRANSACTION + rollbackException.getMessage());
            }
            throw new HopException("Failed to modify column " + column.getName(), (Throwable)e);
        }
    }

    public void dispose() {
        if (((TableOutputData)this.data).db != null) {
            try {
                this.emptyAndCommitBatchBuffers(true);
            }
            finally {
                try {
                    for (Map.Entry<String, PreparedStatement> preparedStatement : ((TableOutputData)this.data).preparedStatements.entrySet()) {
                        preparedStatement.getValue().close();
                    }
                }
                catch (Exception e) {
                    this.logError("An error occurred closing the prepared statements: " + e.getMessage());
                }
                ((TableOutputData)this.data).db.disconnect();
                ((TableOutputData)this.data).db = null;
                ((TableOutputData)this.data).preparedStatements = null;
                ((TableOutputData)this.data).batchBuffer = null;
                ((TableOutputData)this.data).commitCounterMap = null;
                ((TableOutputData)this.data).outputRowMeta = null;
            }
        }
        super.dispose();
    }

    public void batchComplete() throws HopException {
        this.emptyAndCommitBatchBuffers(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emptyAndCommitBatchBuffers(boolean dispose) {
        try {
            for (String schemaTable : ((TableOutputData)this.data).preparedStatements.keySet()) {
                Integer batchCounter = ((TableOutputData)this.data).commitCounterMap.get(schemaTable);
                if (batchCounter == null || batchCounter == 0) continue;
                PreparedStatement insertStatement = ((TableOutputData)this.data).preparedStatements.get(schemaTable);
                ((TableOutputData)this.data).db.emptyAndCommit(insertStatement, ((TableOutputData)this.data).batchMode, batchCounter.intValue(), dispose);
                ((TableOutputData)this.data).commitCounterMap.put(schemaTable, 0);
            }
            for (int i = 0; i < ((TableOutputData)this.data).batchBuffer.size(); ++i) {
                Object[] row = ((TableOutputData)this.data).batchBuffer.get(i);
                this.putRow(((TableOutputData)this.data).outputRowMeta, row);
                this.incrementLinesOutput();
            }
            ((TableOutputData)this.data).batchBuffer.clear();
        }
        catch (HopDatabaseBatchException be) {
            if (this.getTransformMeta().isDoingErrorHandling()) {
                try {
                    this.processBatchException(be.toString(), be.getUpdateCounts(), be.getExceptionsList());
                }
                catch (HopException e) {
                    this.logError("Unexpected error processing batch error", e);
                    this.setErrors(1L);
                    this.stopAll();
                }
            } else {
                this.logError("Unexpected batch update error committing the database connection.", be);
                this.setErrors(1L);
                this.stopAll();
            }
        }
        catch (Exception dbe) {
            this.logError("Unexpected error committing the database connection.", dbe);
            this.logError(Const.getStackTracker((Throwable)dbe));
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.setOutputDone();
            if (this.getErrors() > 0L) {
                try {
                    ((TableOutputData)this.data).db.rollback();
                }
                catch (HopDatabaseException e) {
                    this.logError("Unexpected error rolling back the database connection.", e);
                }
            }
        }
    }
}

