/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol.exceptions;

import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.exceptions.RaftException;

public class StateMachineException
extends RaftException {
    private final boolean leaderShouldStepDown;

    public StateMachineException(RaftGroupMemberId serverId, Throwable cause) {
        super(cause.getClass().getName() + " from Server " + serverId + ": " + cause.getMessage(), cause);
        this.leaderShouldStepDown = true;
    }

    public StateMachineException(String msg) {
        super(msg);
        this.leaderShouldStepDown = true;
    }

    public StateMachineException(String message, Throwable cause) {
        super(message, cause);
        this.leaderShouldStepDown = true;
    }

    public StateMachineException(RaftGroupMemberId serverId, Throwable cause, boolean leaderShouldStepDown) {
        super(cause.getClass().getName() + " from Server " + serverId + ": " + cause.getMessage(), cause);
        this.leaderShouldStepDown = leaderShouldStepDown;
    }

    public StateMachineException(String msg, boolean leaderShouldStepDown) {
        super(msg);
        this.leaderShouldStepDown = leaderShouldStepDown;
    }

    public StateMachineException(String message, Throwable cause, boolean leaderShouldStepDown) {
        super(message, cause);
        this.leaderShouldStepDown = leaderShouldStepDown;
    }

    public boolean leaderShouldStepDown() {
        return this.leaderShouldStepDown;
    }
}

