/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.config;

import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.pipe.agent.plugin.builtin.BuiltinPipePlugin;
import org.apache.iotdb.consensus.pipe.consensuspipe.ConsensusPipeDispatcher;
import org.apache.iotdb.consensus.pipe.consensuspipe.ConsensusPipeGuardian;
import org.apache.iotdb.consensus.pipe.consensuspipe.ConsensusPipeReceiver;
import org.apache.iotdb.consensus.pipe.consensuspipe.ConsensusPipeSelector;
import org.apache.iotdb.consensus.pipe.consensuspipe.ProgressIndexManager;

public class PipeConsensusConfig {
    private final RPC rpc;
    private final Pipe pipe;
    private ReplicateMode replicateMode = ReplicateMode.STREAM;

    public PipeConsensusConfig(RPC rpc, Pipe pipe) {
        this.rpc = rpc;
        this.pipe = pipe;
    }

    public void setReplicateMode(ReplicateMode replicateMode) {
        this.replicateMode = replicateMode;
    }

    public ReplicateMode getReplicateMode() {
        return this.replicateMode;
    }

    public RPC getRpc() {
        return this.rpc;
    }

    public Pipe getPipe() {
        return this.pipe;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum ReplicateMode {
        STREAM("stream"),
        BATCH("batch");

        private final String value;

        private ReplicateMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class RPC {
        private final int rpcSelectorThreadNum;
        private final int rpcMinConcurrentClientNum;
        private final int rpcMaxConcurrentClientNum;
        private final int thriftServerAwaitTimeForStopService;
        private final boolean isRpcThriftCompressionEnabled;
        private final int connectionTimeoutInMs;
        private final int thriftMaxFrameSize;

        public RPC(int rpcSelectorThreadNum, int rpcMinConcurrentClientNum, int rpcMaxConcurrentClientNum, int thriftServerAwaitTimeForStopService, boolean isRpcThriftCompressionEnabled, int connectionTimeoutInMs, int thriftMaxFrameSize) {
            this.rpcSelectorThreadNum = rpcSelectorThreadNum;
            this.rpcMinConcurrentClientNum = rpcMinConcurrentClientNum;
            this.rpcMaxConcurrentClientNum = rpcMaxConcurrentClientNum;
            this.thriftServerAwaitTimeForStopService = thriftServerAwaitTimeForStopService;
            this.isRpcThriftCompressionEnabled = isRpcThriftCompressionEnabled;
            this.connectionTimeoutInMs = connectionTimeoutInMs;
            this.thriftMaxFrameSize = thriftMaxFrameSize;
        }

        public int getRpcSelectorThreadNum() {
            return this.rpcSelectorThreadNum;
        }

        public int getRpcMinConcurrentClientNum() {
            return this.rpcMinConcurrentClientNum;
        }

        public int getRpcMaxConcurrentClientNum() {
            return this.rpcMaxConcurrentClientNum;
        }

        public int getThriftServerAwaitTimeForStopService() {
            return this.thriftServerAwaitTimeForStopService;
        }

        public boolean isRpcThriftCompressionEnabled() {
            return this.isRpcThriftCompressionEnabled;
        }

        public int getConnectionTimeoutInMs() {
            return this.connectionTimeoutInMs;
        }

        public int getThriftMaxFrameSize() {
            return this.thriftMaxFrameSize;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private int rpcSelectorThreadNum = 1;
            private int rpcMinConcurrentClientNum = Runtime.getRuntime().availableProcessors();
            private int rpcMaxConcurrentClientNum = 65535;
            private int thriftServerAwaitTimeForStopService = 60;
            private boolean isRpcThriftCompressionEnabled = false;
            private int connectionTimeoutInMs = (int)TimeUnit.SECONDS.toMillis(60L);
            private int thriftMaxFrameSize = 0x20000000;

            public Builder setRpcSelectorThreadNum(int rpcSelectorThreadNum) {
                this.rpcSelectorThreadNum = rpcSelectorThreadNum;
                return this;
            }

            public Builder setRpcMinConcurrentClientNum(int rpcMinConcurrentClientNum) {
                this.rpcMinConcurrentClientNum = rpcMinConcurrentClientNum;
                return this;
            }

            public Builder setRpcMaxConcurrentClientNum(int rpcMaxConcurrentClientNum) {
                this.rpcMaxConcurrentClientNum = rpcMaxConcurrentClientNum;
                return this;
            }

            public Builder setThriftServerAwaitTimeForStopService(int thriftServerAwaitTimeForStopService) {
                this.thriftServerAwaitTimeForStopService = thriftServerAwaitTimeForStopService;
                return this;
            }

            public Builder setIsRpcThriftCompressionEnabled(boolean isRpcThriftCompressionEnabled) {
                this.isRpcThriftCompressionEnabled = isRpcThriftCompressionEnabled;
                return this;
            }

            public Builder setConnectionTimeoutInMs(int connectionTimeoutInMs) {
                this.connectionTimeoutInMs = connectionTimeoutInMs;
                return this;
            }

            public Builder setThriftMaxFrameSize(int thriftMaxFrameSize) {
                this.thriftMaxFrameSize = thriftMaxFrameSize;
                return this;
            }

            public RPC build() {
                return new RPC(this.rpcSelectorThreadNum, this.rpcMinConcurrentClientNum, this.rpcMaxConcurrentClientNum, this.thriftServerAwaitTimeForStopService, this.isRpcThriftCompressionEnabled, this.connectionTimeoutInMs, this.thriftMaxFrameSize);
            }
        }
    }

    public static class Pipe {
        private final String extractorPluginName;
        private final String processorPluginName;
        private final String connectorPluginName;
        private final ConsensusPipeDispatcher consensusPipeDispatcher;
        private final ConsensusPipeGuardian consensusPipeGuardian;
        private final ConsensusPipeSelector consensusPipeSelector;
        private final ProgressIndexManager progressIndexManager;
        private final ConsensusPipeReceiver consensusPipeReceiver;
        private final long consensusPipeGuardJobIntervalInSeconds;

        public Pipe(String extractorPluginName, String processorPluginName, String connectorPluginName, ConsensusPipeDispatcher consensusPipeDispatcher, ConsensusPipeGuardian consensusPipeGuardian, ConsensusPipeSelector consensusPipeSelector, ProgressIndexManager progressIndexManager, ConsensusPipeReceiver consensusPipeReceiver, long consensusPipeGuardJobIntervalInSeconds) {
            this.extractorPluginName = extractorPluginName;
            this.processorPluginName = processorPluginName;
            this.connectorPluginName = connectorPluginName;
            this.consensusPipeDispatcher = consensusPipeDispatcher;
            this.consensusPipeGuardian = consensusPipeGuardian;
            this.consensusPipeSelector = consensusPipeSelector;
            this.progressIndexManager = progressIndexManager;
            this.consensusPipeReceiver = consensusPipeReceiver;
            this.consensusPipeGuardJobIntervalInSeconds = consensusPipeGuardJobIntervalInSeconds;
        }

        public String getExtractorPluginName() {
            return this.extractorPluginName;
        }

        public String getProcessorPluginName() {
            return this.processorPluginName;
        }

        public String getConnectorPluginName() {
            return this.connectorPluginName;
        }

        public ConsensusPipeDispatcher getConsensusPipeDispatcher() {
            return this.consensusPipeDispatcher;
        }

        public ConsensusPipeGuardian getConsensusPipeGuardian() {
            return this.consensusPipeGuardian;
        }

        public ConsensusPipeSelector getConsensusPipeSelector() {
            return this.consensusPipeSelector;
        }

        public ConsensusPipeReceiver getConsensusPipeReceiver() {
            return this.consensusPipeReceiver;
        }

        public ProgressIndexManager getProgressIndexManager() {
            return this.progressIndexManager;
        }

        public long getConsensusPipeGuardJobIntervalInSeconds() {
            return this.consensusPipeGuardJobIntervalInSeconds;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private String extractorPluginName = BuiltinPipePlugin.IOTDB_EXTRACTOR.getPipePluginName();
            private String processorPluginName = BuiltinPipePlugin.PIPE_CONSENSUS_PROCESSOR.getPipePluginName();
            private String connectorPluginName = BuiltinPipePlugin.PIPE_CONSENSUS_ASYNC_CONNECTOR.getPipePluginName();
            private ConsensusPipeDispatcher consensusPipeDispatcher = null;
            private ConsensusPipeGuardian consensusPipeGuardian = null;
            private ConsensusPipeSelector consensusPipeSelector = null;
            private ProgressIndexManager progressIndexManager = null;
            private ConsensusPipeReceiver consensusPipeReceiver = null;
            private long consensusPipeGuardJobIntervalInSeconds = 180L;

            public Builder setExtractorPluginName(String extractorPluginName) {
                this.extractorPluginName = extractorPluginName;
                return this;
            }

            public Builder setProcessorPluginName(String processorPluginName) {
                this.processorPluginName = processorPluginName;
                return this;
            }

            public Builder setConnectorPluginName(String connectorPluginName) {
                this.connectorPluginName = connectorPluginName;
                return this;
            }

            public Builder setConsensusPipeDispatcher(ConsensusPipeDispatcher consensusPipeDispatcher) {
                this.consensusPipeDispatcher = consensusPipeDispatcher;
                return this;
            }

            public Builder setConsensusPipeGuardian(ConsensusPipeGuardian consensusPipeGuardian) {
                this.consensusPipeGuardian = consensusPipeGuardian;
                return this;
            }

            public Builder setConsensusPipeSelector(ConsensusPipeSelector consensusPipeSelector) {
                this.consensusPipeSelector = consensusPipeSelector;
                return this;
            }

            public Builder setConsensusPipeReceiver(ConsensusPipeReceiver consensusPipeReceiver) {
                this.consensusPipeReceiver = consensusPipeReceiver;
                return this;
            }

            public Builder setProgressIndexManager(ProgressIndexManager progressIndexManager) {
                this.progressIndexManager = progressIndexManager;
                return this;
            }

            public Builder setConsensusPipeGuardJobIntervalInSeconds(long consensusPipeGuardJobIntervalInSeconds) {
                this.consensusPipeGuardJobIntervalInSeconds = consensusPipeGuardJobIntervalInSeconds;
                return this;
            }

            public Pipe build() {
                return new Pipe(this.extractorPluginName, this.processorPluginName, this.connectorPluginName, this.consensusPipeDispatcher, this.consensusPipeGuardian, this.consensusPipeSelector, this.progressIndexManager, this.consensusPipeReceiver, this.consensusPipeGuardJobIntervalInSeconds);
            }
        }
    }

    public static class Builder {
        private RPC rpc;
        private Pipe pipe;

        public Builder setPipe(Pipe pipe) {
            this.pipe = pipe;
            return this;
        }

        public Builder setRPC(RPC rpc) {
            this.rpc = rpc;
            return this;
        }

        public PipeConsensusConfig build() {
            return new PipeConsensusConfig(this.rpc, this.pipe);
        }
    }
}

