/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.enumerated.UserTokenType;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class UserTokenPolicy
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=304");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=305");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=306");
    private final String policyId;
    private final UserTokenType tokenType;
    private final String issuedTokenType;
    private final String issuerEndpointUrl;
    private final String securityPolicyUri;

    public UserTokenPolicy(String policyId, UserTokenType tokenType, String issuedTokenType, String issuerEndpointUrl, String securityPolicyUri) {
        this.policyId = policyId;
        this.tokenType = tokenType;
        this.issuedTokenType = issuedTokenType;
        this.issuerEndpointUrl = issuerEndpointUrl;
        this.securityPolicyUri = securityPolicyUri;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public UserTokenType getTokenType() {
        return this.tokenType;
    }

    public String getIssuedTokenType() {
        return this.issuedTokenType;
    }

    public String getIssuerEndpointUrl() {
        return this.issuerEndpointUrl;
    }

    public String getSecurityPolicyUri() {
        return this.securityPolicyUri;
    }

    protected UserTokenPolicy(UserTokenPolicyBuilder<?, ?> b) {
        super(b);
        this.policyId = ((UserTokenPolicyBuilder)b).policyId;
        this.tokenType = ((UserTokenPolicyBuilder)b).tokenType;
        this.issuedTokenType = ((UserTokenPolicyBuilder)b).issuedTokenType;
        this.issuerEndpointUrl = ((UserTokenPolicyBuilder)b).issuerEndpointUrl;
        this.securityPolicyUri = ((UserTokenPolicyBuilder)b).securityPolicyUri;
    }

    public static UserTokenPolicyBuilder<?, ?> builder() {
        return new UserTokenPolicyBuilderImpl();
    }

    public UserTokenPolicyBuilder<?, ?> toBuilder() {
        return new UserTokenPolicyBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserTokenPolicy)) {
            return false;
        }
        UserTokenPolicy other = (UserTokenPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$policyId = this.getPolicyId();
        String other$policyId = other.getPolicyId();
        if (this$policyId == null ? other$policyId != null : !this$policyId.equals(other$policyId)) {
            return false;
        }
        UserTokenType this$tokenType = this.getTokenType();
        UserTokenType other$tokenType = other.getTokenType();
        if (this$tokenType == null ? other$tokenType != null : !this$tokenType.equals(other$tokenType)) {
            return false;
        }
        String this$issuedTokenType = this.getIssuedTokenType();
        String other$issuedTokenType = other.getIssuedTokenType();
        if (this$issuedTokenType == null ? other$issuedTokenType != null : !this$issuedTokenType.equals(other$issuedTokenType)) {
            return false;
        }
        String this$issuerEndpointUrl = this.getIssuerEndpointUrl();
        String other$issuerEndpointUrl = other.getIssuerEndpointUrl();
        if (this$issuerEndpointUrl == null ? other$issuerEndpointUrl != null : !this$issuerEndpointUrl.equals(other$issuerEndpointUrl)) {
            return false;
        }
        String this$securityPolicyUri = this.getSecurityPolicyUri();
        String other$securityPolicyUri = other.getSecurityPolicyUri();
        return !(this$securityPolicyUri == null ? other$securityPolicyUri != null : !this$securityPolicyUri.equals(other$securityPolicyUri));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserTokenPolicy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $policyId = this.getPolicyId();
        result = result * 59 + ($policyId == null ? 43 : $policyId.hashCode());
        UserTokenType $tokenType = this.getTokenType();
        result = result * 59 + ($tokenType == null ? 43 : $tokenType.hashCode());
        String $issuedTokenType = this.getIssuedTokenType();
        result = result * 59 + ($issuedTokenType == null ? 43 : $issuedTokenType.hashCode());
        String $issuerEndpointUrl = this.getIssuerEndpointUrl();
        result = result * 59 + ($issuerEndpointUrl == null ? 43 : $issuerEndpointUrl.hashCode());
        String $securityPolicyUri = this.getSecurityPolicyUri();
        result = result * 59 + ($securityPolicyUri == null ? 43 : $securityPolicyUri.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "UserTokenPolicy(policyId=" + this.getPolicyId() + ", tokenType=" + this.getTokenType() + ", issuedTokenType=" + this.getIssuedTokenType() + ", issuerEndpointUrl=" + this.getIssuerEndpointUrl() + ", securityPolicyUri=" + this.getSecurityPolicyUri() + ")";
    }

    private static final class UserTokenPolicyBuilderImpl
    extends UserTokenPolicyBuilder<UserTokenPolicy, UserTokenPolicyBuilderImpl> {
        private UserTokenPolicyBuilderImpl() {
        }

        @Override
        protected UserTokenPolicyBuilderImpl self() {
            return this;
        }

        @Override
        public UserTokenPolicy build() {
            return new UserTokenPolicy(this);
        }
    }

    public static abstract class UserTokenPolicyBuilder<C extends UserTokenPolicy, B extends UserTokenPolicyBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private String policyId;
        private UserTokenType tokenType;
        private String issuedTokenType;
        private String issuerEndpointUrl;
        private String securityPolicyUri;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            UserTokenPolicyBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(UserTokenPolicy instance, UserTokenPolicyBuilder<?, ?> b) {
            b.policyId(instance.policyId);
            b.tokenType(instance.tokenType);
            b.issuedTokenType(instance.issuedTokenType);
            b.issuerEndpointUrl(instance.issuerEndpointUrl);
            b.securityPolicyUri(instance.securityPolicyUri);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B policyId(String policyId) {
            this.policyId = policyId;
            return (B)this.self();
        }

        public B tokenType(UserTokenType tokenType) {
            this.tokenType = tokenType;
            return (B)this.self();
        }

        public B issuedTokenType(String issuedTokenType) {
            this.issuedTokenType = issuedTokenType;
            return (B)this.self();
        }

        public B issuerEndpointUrl(String issuerEndpointUrl) {
            this.issuerEndpointUrl = issuerEndpointUrl;
            return (B)this.self();
        }

        public B securityPolicyUri(String securityPolicyUri) {
            this.securityPolicyUri = securityPolicyUri;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "UserTokenPolicy.UserTokenPolicyBuilder(super=" + super.toString() + ", policyId=" + this.policyId + ", tokenType=" + this.tokenType + ", issuedTokenType=" + this.issuedTokenType + ", issuerEndpointUrl=" + this.issuerEndpointUrl + ", securityPolicyUri=" + this.securityPolicyUri + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<UserTokenPolicy> {
        @Override
        public Class<UserTokenPolicy> getType() {
            return UserTokenPolicy.class;
        }

        @Override
        public UserTokenPolicy decode(SerializationContext context, UaDecoder decoder) {
            String policyId = decoder.readString("PolicyId");
            UserTokenType tokenType = decoder.readEnum("TokenType", UserTokenType.class);
            String issuedTokenType = decoder.readString("IssuedTokenType");
            String issuerEndpointUrl = decoder.readString("IssuerEndpointUrl");
            String securityPolicyUri = decoder.readString("SecurityPolicyUri");
            return new UserTokenPolicy(policyId, tokenType, issuedTokenType, issuerEndpointUrl, securityPolicyUri);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, UserTokenPolicy value) {
            encoder.writeString("PolicyId", value.getPolicyId());
            encoder.writeEnum("TokenType", value.getTokenType());
            encoder.writeString("IssuedTokenType", value.getIssuedTokenType());
            encoder.writeString("IssuerEndpointUrl", value.getIssuerEndpointUrl());
            encoder.writeString("SecurityPolicyUri", value.getSecurityPolicyUri());
        }
    }
}

