/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.AbstractConsumeAllOperator;
import org.apache.iotdb.db.utils.datastructure.MergeSortHeap;
import org.apache.iotdb.db.utils.datastructure.MergeSortKey;
import org.apache.iotdb.db.utils.datastructure.SortKey;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.tsfile.utils.RamUsageEstimator;

public abstract class MergeSortOperator
extends AbstractConsumeAllOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(MergeSortOperator.class);
    private final List<TSDataType> dataTypes;
    private final TsBlockBuilder tsBlockBuilder;
    private final boolean[] noMoreTsBlocks;
    private final MergeSortHeap mergeSortHeap;
    private final Comparator<SortKey> comparator;
    private boolean finished;

    MergeSortOperator(OperatorContext operatorContext, List<Operator> inputOperators, List<TSDataType> dataTypes, Comparator<SortKey> comparator) {
        super(operatorContext, inputOperators);
        this.dataTypes = dataTypes;
        this.mergeSortHeap = new MergeSortHeap(this.inputOperatorsCount, comparator);
        this.comparator = comparator;
        this.noMoreTsBlocks = new boolean[this.inputOperatorsCount];
        this.tsBlockBuilder = new TsBlockBuilder(dataTypes);
        operatorContext.recordSpecifiedInfo("Merge sort branches", String.valueOf(this.inputOperatorsCount));
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        boolean hasReadyChild = false;
        ArrayList listenableFutures = new ArrayList();
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (this.noMoreTsBlocks[i] || !this.isEmpty(i) || this.children.get(i) == null) continue;
            ListenableFuture<?> blocked = ((Operator)this.children.get(i)).isBlocked();
            if (blocked.isDone()) {
                hasReadyChild = true;
                this.canCallNext[i] = true;
                continue;
            }
            listenableFutures.add(blocked);
        }
        return hasReadyChild || listenableFutures.isEmpty() ? NOT_BLOCKED : Futures.successfulAsList(listenableFutures);
    }

    @Override
    public TsBlock next() throws Exception {
        long startTime = System.nanoTime();
        long maxRuntime = this.operatorContext.getMaxRunTime().roundTo(TimeUnit.NANOSECONDS);
        if (!this.prepareInput()) {
            return null;
        }
        MergeSortKey minMergeSortKey = this.mergeSortHeap.poll();
        if (this.mergeSortHeap.isEmpty() || this.comparator.compare(new MergeSortKey(minMergeSortKey.tsBlock, minMergeSortKey.tsBlock.getPositionCount() - 1), this.mergeSortHeap.peek()) < 0) {
            this.inputTsBlocks[minMergeSortKey.inputChannelIndex] = null;
            return minMergeSortKey.rowIndex == 0 ? minMergeSortKey.tsBlock : minMergeSortKey.tsBlock.subTsBlock(minMergeSortKey.rowIndex);
        }
        this.mergeSortHeap.push(minMergeSortKey);
        this.tsBlockBuilder.reset();
        TimeColumnBuilder timeBuilder = this.tsBlockBuilder.getTimeColumnBuilder();
        ColumnBuilder[] valueColumnBuilders = this.tsBlockBuilder.getValueColumnBuilders();
        while (!this.mergeSortHeap.isEmpty()) {
            MergeSortKey mergeSortKey = this.mergeSortHeap.poll();
            TsBlock targetBlock = mergeSortKey.tsBlock;
            int rowIndex = mergeSortKey.rowIndex;
            this.appendTime(timeBuilder, targetBlock.getTimeByIndex(rowIndex));
            for (int i = 0; i < valueColumnBuilders.length; ++i) {
                if (targetBlock.getColumn(i).isNull(rowIndex)) {
                    valueColumnBuilders[i].appendNull();
                    continue;
                }
                valueColumnBuilders[i].write(targetBlock.getColumn(i), rowIndex);
            }
            this.tsBlockBuilder.declarePosition();
            if (mergeSortKey.rowIndex == mergeSortKey.tsBlock.getPositionCount() - 1) {
                this.inputTsBlocks[mergeSortKey.inputChannelIndex] = null;
                break;
            }
            ++mergeSortKey.rowIndex;
            this.mergeSortHeap.push(mergeSortKey);
            if (System.nanoTime() - startTime <= maxRuntime && !this.tsBlockBuilder.isFull()) continue;
            break;
        }
        return this.buildResult(this.tsBlockBuilder);
    }

    protected abstract void appendTime(TimeColumnBuilder var1, long var2);

    protected abstract TsBlock buildResult(TsBlockBuilder var1);

    @Override
    public boolean hasNext() throws Exception {
        if (this.finished) {
            return false;
        }
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (!this.isEmpty(i)) {
                return true;
            }
            if (this.noMoreTsBlocks[i]) continue;
            if (!this.canCallNext[i] || ((Operator)this.children.get(i)).hasNextWithTimer()) {
                return true;
            }
            ((Operator)this.children.get(i)).close();
            this.children.set(i, null);
            this.noMoreTsBlocks[i] = true;
            this.inputTsBlocks[i] = null;
        }
        return false;
    }

    @Override
    public boolean isFinished() throws Exception {
        if (this.finished) {
            return true;
        }
        this.finished = true;
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (this.noMoreTsBlocks[i] && this.isEmpty(i)) continue;
            this.finished = false;
            break;
        }
        return this.finished;
    }

    @Override
    public long calculateMaxPeekMemory() {
        long maxPeekMemory = TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
        for (Operator operator : this.children) {
            maxPeekMemory += operator.calculateMaxReturnSize();
            maxPeekMemory += operator.calculateRetainedSizeAfterCallingNext();
        }
        for (Operator operator : this.children) {
            maxPeekMemory = Math.max(maxPeekMemory, operator.calculateMaxPeekMemoryWithCounter());
        }
        return Math.max(maxPeekMemory, this.calculateMaxReturnSize());
    }

    @Override
    public long calculateMaxReturnSize() {
        return (1L + (long)this.dataTypes.size()) * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        long currentRetainedSize = 0L;
        long minChildReturnSize = Long.MAX_VALUE;
        for (Operator child : this.children) {
            long maxReturnSize = child.calculateMaxReturnSize();
            minChildReturnSize = Math.min(minChildReturnSize, maxReturnSize);
            currentRetainedSize += maxReturnSize + child.calculateRetainedSizeAfterCallingNext();
        }
        return currentRetainedSize - minChildReturnSize;
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + this.children.stream().mapToLong(MemoryEstimationHelper::getEstimatedSizeOfAccountableObject).sum() + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + RamUsageEstimator.sizeOf((boolean[])this.canCallNext) + RamUsageEstimator.sizeOf((boolean[])this.noMoreTsBlocks) + this.tsBlockBuilder.getRetainedSizeInBytes();
    }

    @Override
    protected boolean canSkipCurrentChild(int currentChildIndex) {
        return this.noMoreTsBlocks[currentChildIndex] || !this.isEmpty(currentChildIndex) || this.children.get(currentChildIndex) == null;
    }

    @Override
    protected void processCurrentInputTsBlock(int currentInputIndex) {
        this.mergeSortHeap.push(new MergeSortKey(this.inputTsBlocks[currentInputIndex], 0, currentInputIndex));
    }

    @Override
    protected void handleFinishedChild(int currentChildIndex) throws Exception {
        this.noMoreTsBlocks[currentChildIndex] = true;
        this.inputTsBlocks[currentChildIndex] = null;
        ((Operator)this.children.get(currentChildIndex)).close();
        this.children.set(currentChildIndex, null);
    }
}

