/*
 * Decompiled with CFR 0.152.
 */
package org.archive.url;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import org.archive.url.URLRegexTransformer;

public class HandyURL {
    public static final int DEFAULT_PORT = -1;
    private String scheme;
    private String authUser;
    private String authPass;
    private String host;
    private int port;
    private String path;
    private String query;
    private String hash;
    private String opaque;
    private String cachedPubSuffix;
    private String cachedPubPrefix;

    public HandyURL() {
        this.scheme = null;
        this.authUser = null;
        this.authPass = null;
        this.host = null;
        this.port = -1;
        this.path = null;
        this.query = null;
        this.hash = null;
        this.opaque = null;
    }

    public HandyURL(String scheme, String authUser, String authPass, String host, int port, String path, String query, String hash) {
        this.scheme = scheme;
        this.authUser = authUser;
        this.authPass = authPass;
        this.host = host;
        this.port = port;
        this.path = path;
        this.query = query;
        this.hash = hash;
    }

    public String getSURTString(boolean includeScheme) {
        return this.getURLString(true, includeScheme, false);
    }

    public String getURLString(boolean surt, boolean includeScheme, boolean publicSuffix) {
        boolean hasPath;
        if (this.opaque != null) {
            return this.opaque;
        }
        StringBuilder sb = new StringBuilder();
        if (includeScheme) {
            sb.append(this.scheme).append("://");
            if (surt) {
                sb.append("(");
            }
        }
        if (this.authUser != null) {
            sb.append(this.authUser);
            if (this.authPass != null) {
                sb.append(":").append(this.authPass);
            }
            sb.append("@");
        }
        String hostSrc = this.host;
        if (publicSuffix) {
            hostSrc = this.getPublicSuffix();
        }
        if (surt) {
            hostSrc = URLRegexTransformer.hostToSURT(hostSrc);
        }
        sb.append(hostSrc);
        if (this.port != -1) {
            sb.append(":").append(this.port);
        }
        if (surt) {
            sb.append(")");
        }
        boolean bl = hasPath = this.path != null && this.path.length() > 0;
        if (hasPath) {
            sb.append(this.path);
        } else if (this.query != null || this.hash != null) {
            sb.append("/");
        }
        if (this.query != null) {
            sb.append('?').append(this.query);
        }
        if (this.hash != null) {
            sb.append('#').append(this.hash);
        }
        return sb.toString();
    }

    public String getURLString() {
        return this.getURLString(false, true, false);
    }

    public String getPathQuery() {
        boolean hasPath;
        StringBuilder sb = new StringBuilder();
        boolean bl = hasPath = this.path != null && this.path.length() > 0;
        if (hasPath) {
            sb.append(this.path);
        } else if (this.query != null || this.hash != null) {
            sb.append("/");
        }
        if (this.query != null) {
            sb.append('?').append(this.query);
        }
        return sb.toString();
    }

    public URL toURL() throws MalformedURLException {
        return new URL(this.getURLString());
    }

    public String getPublicSuffix() {
        if (this.cachedPubSuffix != null) {
            return this.cachedPubSuffix;
        }
        if (this.host == null) {
            return null;
        }
        this.cachedPubSuffix = URLRegexTransformer.hostToPublicSuffix(this.host);
        return this.cachedPubSuffix;
    }

    public String getPublicPrefix() {
        if (this.cachedPubPrefix != null) {
            return this.cachedPubPrefix;
        }
        if (this.host == null) {
            return null;
        }
        String pubS = this.getPublicSuffix();
        if (pubS == null) {
            return null;
        }
        int hostLen = this.host.length();
        this.cachedPubPrefix = (hostLen -= pubS.length()) > 1 ? this.host.substring(0, this.host.length() - pubS.length() - 1) : "";
        return this.cachedPubPrefix;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getAuthUser() {
        return this.authUser;
    }

    public void setAuthUser(String authUser) {
        this.authUser = authUser;
    }

    public String getAuthPass() {
        return this.authPass;
    }

    public void setAuthPass(String authPass) {
        this.authPass = authPass;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
        this.cachedPubPrefix = null;
        this.cachedPubSuffix = null;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public void setOpaque(String opaque) {
        this.opaque = opaque;
    }

    public String toDebugString() {
        return String.format(Locale.ROOT, "Scheme(%s) UserName(%s) UserPass(%s) Host(%s) port(%d) Path(%s) Query(%s) Frag(%s)", this.scheme, this.authUser, this.authPass, this.host, this.port, this.path, this.query, this.hash);
    }
}

