/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.client.impl.PatternMultiTopicsConsumerImpl;
import org.apache.pulsar.common.api.proto.CommandWatchTopicListSuccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
public class PatternConsumerUpdateQueue {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PatternConsumerUpdateQueue.class);
    private final LinkedBlockingQueue<UpdateTask> pendingTasks;
    private final PatternMultiTopicsConsumerImpl<?> patternConsumer;
    private final PatternMultiTopicsConsumerImpl.TopicsChangedListener topicsChangeListener;
    private Pair<UpdateSubscriptionType, CompletableFuture<Void>> taskInProgress = null;
    private boolean recheckTaskInQueue = false;
    private volatile long lastRecheckTaskStartingTimestamp = 0L;
    private boolean closed;

    public PatternConsumerUpdateQueue(PatternMultiTopicsConsumerImpl<?> patternConsumer) {
        this(patternConsumer, patternConsumer.topicsChangeListener);
    }

    @VisibleForTesting
    public PatternConsumerUpdateQueue(PatternMultiTopicsConsumerImpl<?> patternConsumer, PatternMultiTopicsConsumerImpl.TopicsChangedListener topicsChangeListener) {
        this.patternConsumer = patternConsumer;
        this.topicsChangeListener = topicsChangeListener;
        this.pendingTasks = new LinkedBlockingQueue();
        this.doAppend(InitTask.INSTANCE);
    }

    synchronized void appendTopicsChangedOp(Collection<String> addedTopics, Collection<String> deletedTopics, String topicsHash) {
        this.doAppend(new TopicsAddedOrRemovedTask(addedTopics, deletedTopics, topicsHash));
    }

    synchronized void appendRecheckOp() {
        this.doAppend(RecheckTask.INSTANCE);
    }

    synchronized void appendWatchTopicListSuccessOp(CommandWatchTopicListSuccess response, String localStateTopicsHash, int epoch) {
        this.doAppend(new WatchTopicListSuccessTask(response, localStateTopicsHash, epoch));
    }

    synchronized void doAppend(UpdateTask task) {
        if (log.isDebugEnabled()) {
            log.debug("Pattern consumer [{}] try to append task. {}", (Object)this.patternConsumer.getSubscription(), (Object)task);
        }
        if (this.recheckTaskInQueue) {
            return;
        }
        if (this.pendingTasks.size() >= 30 && task.type != UpdateSubscriptionType.RECHECK) {
            this.appendRecheckOp();
            return;
        }
        this.pendingTasks.add(task);
        if (task.type == UpdateSubscriptionType.RECHECK) {
            this.recheckTaskInQueue = true;
        }
        if (this.taskInProgress == null) {
            this.triggerNextTask();
        }
    }

    synchronized void triggerNextTask() {
        if (this.closed) {
            return;
        }
        UpdateTask task = this.pendingTasks.poll();
        if (task == null) {
            this.taskInProgress = null;
            return;
        }
        if (this.recheckTaskInQueue && task.type != UpdateSubscriptionType.RECHECK) {
            this.triggerNextTask();
            return;
        }
        CompletionStage<Void> newTaskFuture = null;
        switch (task.type.ordinal()) {
            case 0: {
                newTaskFuture = ((CompletableFuture)this.patternConsumer.getSubscribeFuture().thenAccept(__ -> {})).exceptionally(ex -> {
                    PatternConsumerUpdateQueue patternConsumerUpdateQueue = this;
                    synchronized (patternConsumerUpdateQueue) {
                        this.closed = true;
                        this.patternConsumer.closeAsync().exceptionally(ex2 -> {
                            log.error("Pattern consumer failed to close, this error may left orphan consumers. Subscription: {}", (Object)this.patternConsumer.getSubscription());
                            return null;
                        });
                    }
                    return null;
                });
                break;
            }
            case 1: {
                TopicsAddedOrRemovedTask topicsAddedOrRemovedTask = (TopicsAddedOrRemovedTask)task;
                newTaskFuture = ((CompletableFuture)this.topicsChangeListener.onTopicsRemoved(topicsAddedOrRemovedTask.removedTopics).thenCompose(__ -> this.topicsChangeListener.onTopicsAdded(topicsAddedOrRemovedTask.addedTopics))).thenRun(() -> {
                    if (!this.patternConsumer.supportsTopicListWatcherReconcile()) {
                        return;
                    }
                    String localHash = this.patternConsumer.getLocalStateTopicsHash();
                    String brokerHash = topicsAddedOrRemovedTask.topicsHash;
                    if (brokerHash != null && brokerHash.length() > 0 && !brokerHash.equals(localHash)) {
                        log.info("[{}][{}] Hash mismatch detected (local: {}, broker: {}). Triggering reconciliation.", new Object[]{this.patternConsumer.getPattern().inputPattern(), this.patternConsumer.getSubscription(), localHash, brokerHash});
                        this.appendRecheckOp();
                    }
                });
                break;
            }
            case 2: {
                this.recheckTaskInQueue = false;
                this.lastRecheckTaskStartingTimestamp = System.currentTimeMillis();
                newTaskFuture = this.patternConsumer.recheckTopicsChange();
                break;
            }
            case 3: {
                WatchTopicListSuccessTask watchTopicListSuccessTask = (WatchTopicListSuccessTask)task;
                newTaskFuture = this.patternConsumer.handleWatchTopicListSuccess(watchTopicListSuccessTask.response, watchTopicListSuccessTask.localStateTopicsHash, watchTopicListSuccessTask.epoch);
                break;
            }
            default: {
                throw new RuntimeException("Un-support UpdateSubscriptionType");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Pattern consumer [{}] starting task. {}", (Object)this.patternConsumer.getSubscription(), (Object)task);
        }
        this.taskInProgress = Pair.of((Object)((Object)task.type), newTaskFuture);
        ((CompletableFuture)((CompletableFuture)newTaskFuture).thenAccept(ignore -> {
            if (log.isDebugEnabled()) {
                log.debug("Pattern consumer [{}] task finished. {}", (Object)this.patternConsumer.getSubscription(), (Object)task);
            }
            this.triggerNextTask();
        })).exceptionally(ex -> {
            log.error("Pattern consumer [{}] task finished. {}. But it failed", new Object[]{this.patternConsumer.getSubscription(), task, ex});
            PatternConsumerUpdateQueue patternConsumerUpdateQueue = this;
            synchronized (patternConsumerUpdateQueue) {
                if (this.recheckTaskInQueue || this.closed) {
                    return null;
                }
            }
            long failedTime = System.currentTimeMillis();
            this.patternConsumer.getClient().timer().newTimeout(timeout -> {
                if (this.lastRecheckTaskStartingTimestamp <= failedTime) {
                    this.appendRecheckOp();
                }
            }, 10L, TimeUnit.SECONDS);
            this.triggerNextTask();
            return null;
        });
    }

    public synchronized CompletableFuture<Void> cancelAllAndWaitForTheRunningTask() {
        this.closed = true;
        if (this.taskInProgress == null) {
            return CompletableFuture.completedFuture(null);
        }
        if (((UpdateSubscriptionType)((Object)this.taskInProgress.getLeft())).equals((Object)UpdateSubscriptionType.CONSUMER_INIT)) {
            return CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)((CompletableFuture)this.taskInProgress.getRight()).thenAccept(__ -> {})).exceptionally(ex -> null);
    }

    static class InitTask
    extends UpdateTask {
        public static final InitTask INSTANCE = new InitTask();

        private InitTask() {
            super(UpdateSubscriptionType.CONSUMER_INIT);
        }

        public String toString() {
            return "InitTask";
        }
    }

    static class UpdateTask {
        private final UpdateSubscriptionType type;

        UpdateTask(UpdateSubscriptionType type) {
            this.type = type;
        }
    }

    static class TopicsAddedOrRemovedTask
    extends UpdateTask {
        private final Collection<String> addedTopics;
        private final Collection<String> removedTopics;
        private final String topicsHash;

        public TopicsAddedOrRemovedTask(Collection<String> addedTopics, Collection<String> removedTopics, String topicsHash) {
            super(UpdateSubscriptionType.TOPICS_CHANGED);
            this.addedTopics = addedTopics;
            this.removedTopics = removedTopics;
            this.topicsHash = topicsHash;
        }

        public String toString() {
            return "TopicsAddedOrRemovedTask{addedTopics=" + this.addedTopics + ", removedTopics=" + this.removedTopics + ", topicsHash='" + this.topicsHash + '\'' + '}';
        }
    }

    static class RecheckTask
    extends UpdateTask {
        public static final RecheckTask INSTANCE = new RecheckTask();

        private RecheckTask() {
            super(UpdateSubscriptionType.RECHECK);
        }

        public String toString() {
            return "RecheckTask";
        }
    }

    static class WatchTopicListSuccessTask
    extends UpdateTask {
        private final CommandWatchTopicListSuccess response;
        private final String localStateTopicsHash;
        private final int epoch;

        WatchTopicListSuccessTask(CommandWatchTopicListSuccess response, String localStateTopicsHash, int epoch) {
            super(UpdateSubscriptionType.WATCH_TOPIC_LIST_SUCCESS);
            this.response = response;
            this.localStateTopicsHash = localStateTopicsHash;
            this.epoch = epoch;
        }
    }

    private static enum UpdateSubscriptionType {
        CONSUMER_INIT,
        TOPICS_CHANGED,
        RECHECK,
        WATCH_TOPIC_LIST_SUCCESS;

    }
}

