/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.metrics;

import com.google.common.collect.Lists;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.incubator.metrics.ExtendedDoubleHistogramBuilder;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.DoubleHistogramBuilder;
import io.opentelemetry.api.metrics.Meter;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.impl.metrics.MetricsUtil;
import org.apache.pulsar.client.impl.metrics.Unit;

public class LatencyHistogram {
    public static final LatencyHistogram NOOP = new LatencyHistogram(){

        @Override
        public void recordSuccess(long latencyNanos) {
        }

        @Override
        public void recordFailure(long latencyNanos) {
        }
    };
    private static final List<Double> latencyHistogramBuckets = Lists.newArrayList((Object[])new Double[]{5.0E-4, 0.001, 0.0025, 0.005, 0.01, 0.025, 0.05, 0.1, 0.25, 0.5, 1.0, 2.5, 5.0, 10.0, 30.0, 60.0});
    private static final double NANOS = TimeUnit.SECONDS.toNanos(1L);
    private final Attributes successAttributes;
    private final Attributes failedAttributes;
    private final DoubleHistogram histogram;

    private LatencyHistogram() {
        this.successAttributes = null;
        this.failedAttributes = null;
        this.histogram = null;
    }

    LatencyHistogram(Meter meter, String name, String description, String topic, Attributes attributes) {
        DoubleHistogramBuilder builder = meter.histogramBuilder(name).setDescription(description).setUnit(Unit.Seconds.toString()).setExplicitBucketBoundariesAdvice(latencyHistogramBuckets);
        if (topic != null) {
            if (builder instanceof ExtendedDoubleHistogramBuilder) {
                ExtendedDoubleHistogramBuilder eb = (ExtendedDoubleHistogramBuilder)builder;
                eb.setAttributesAdvice(MetricsUtil.getDefaultAggregationLabels(attributes.toBuilder().put("pulsar.response.status", "success").build()));
            }
            attributes = MetricsUtil.getTopicAttributes(topic, attributes);
        }
        this.successAttributes = attributes.toBuilder().put("pulsar.response.status", "success").build();
        this.failedAttributes = attributes.toBuilder().put("pulsar.response.status", "failed").build();
        this.histogram = builder.build();
    }

    private LatencyHistogram(DoubleHistogram histogram, Attributes successAttributes, Attributes failedAttributes) {
        this.histogram = histogram;
        this.successAttributes = successAttributes;
        this.failedAttributes = failedAttributes;
    }

    public LatencyHistogram withAttributes(Attributes attributes) {
        return new LatencyHistogram(this.histogram, this.successAttributes.toBuilder().putAll(attributes).build(), this.failedAttributes.toBuilder().putAll(attributes).build());
    }

    public void recordSuccess(long latencyNanos) {
        this.histogram.record((double)latencyNanos / NANOS, this.successAttributes);
    }

    public void recordFailure(long latencyNanos) {
        this.histogram.record((double)latencyNanos / NANOS, this.failedAttributes);
    }
}

