/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.router.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class TagItem {
    private static final String VERSION = "version";
    private String version;
    private Map<String, String> param;

    public TagItem() {
    }

    public TagItem(String version, Map<String, String> param) {
        this.version = version;
        this.param = param;
    }

    public TagItem(String version) {
        this.version = version;
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(VERSION, version);
        this.param = param;
    }

    public TagItem(Map<String, String> param) {
        if (param.containsKey(VERSION)) {
            this.version = param.get(VERSION);
        }
        this.param = param;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Map<String, String> getParam() {
        return this.param;
    }

    public void setParam(Map<String, String> param) {
        this.param = param;
    }

    public int hashCode() {
        return Objects.hash(this.getVersion(), this.getParam());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TagItem)) {
            return false;
        }
        TagItem tagItem = (TagItem)o;
        return Objects.equals(this.getVersion(), tagItem.getVersion()) && Objects.equals(this.getParam(), tagItem.getParam());
    }

    public int matchNum(TagItem item) {
        int cnt = 0;
        if (this.version != null && !this.version.equals(item.version)) {
            return 0;
        }
        for (Map.Entry<String, String> entry : this.param.entrySet()) {
            if (item.getParam().containsKey(entry.getKey()) && !item.getParam().get(entry.getKey()).equals(entry.getValue())) {
                return 0;
            }
            ++cnt;
        }
        return cnt;
    }
}

