/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.util.Arrays;
import org.apache.sis.referencing.internal.Arithmetic;
import org.apache.sis.referencing.internal.shared.ExtendedPrecisionMatrix;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.transform.AbstractLinearTransform;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.ScaleTransform;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.Matrix;

final class TranslationTransform
extends AbstractLinearTransform
implements ExtendedPrecisionMatrix {
    private static final long serialVersionUID = -3713820636959453961L;
    private final double[] offsets;
    private final Number[] numbers;

    TranslationTransform(int dim, double offset) {
        this.offsets = new double[dim];
        this.numbers = new Double[dim];
        Arrays.fill(this.offsets, offset);
        if (offset != 0.0) {
            Arrays.fill(this.numbers, (Object)offset);
        }
    }

    TranslationTransform(double[] offsets) {
        this.offsets = (double[])offsets.clone();
        this.numbers = TranslationTransform.wrap(this.offsets);
    }

    private TranslationTransform(TranslationTransform other) {
        int dim = other.offsets.length;
        this.offsets = new double[dim];
        this.numbers = new Number[dim];
        for (int i = 0; i < dim; ++i) {
            this.offsets[i] = -other.offsets[i];
            this.numbers[i] = Arithmetic.negate(other.numbers[i]);
        }
    }

    TranslationTransform(int size, Number[] elements) {
        int dim = size - 1;
        this.numbers = new Number[dim];
        this.offsets = ScaleTransform.store(elements, this.numbers, i -> dim + i * size);
    }

    @Override
    public Number[] getElementAsNumbers(boolean writable) {
        int dim = this.numbers.length;
        int size = dim + 1;
        Number[] elements = new Number[size * size];
        for (int i = 0; i < dim; ++i) {
            int j = i * size;
            elements[j + i] = 1;
            elements[j + dim] = this.numbers[i];
        }
        elements[elements.length - 1] = 1;
        return elements;
    }

    @Override
    public int getSourceDimensions() {
        return this.offsets.length;
    }

    @Override
    public int getTargetDimensions() {
        return this.offsets.length;
    }

    @Override
    public final Number getElementOrNull(int row, int column) {
        int dim = this.numbers.length;
        ArgumentChecks.ensureBetween((String)"row", (int)0, (int)dim, (int)row);
        ArgumentChecks.ensureBetween((String)"column", (int)0, (int)dim, (int)column);
        return column == row ? (Number)1 : (Number)(column == dim ? this.numbers[row] : null);
    }

    @Override
    public boolean isIdentity() {
        for (int i = 0; i < this.numbers.length; ++i) {
            if (this.numbers[i] == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) {
        this.transform(srcPts, srcOff, dstPts, dstOff, 1);
        return derivate ? this.derivative(null) : null;
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        int dim;
        if (srcPts == dstPts && IterationStrategy.suggest(srcOff, dim = this.offsets.length, dstOff, dim, numPts) != IterationStrategy.ASCENDING) {
            srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * dim);
            srcOff = 0;
        }
        while (--numPts >= 0) {
            for (int i = 0; i < this.offsets.length; ++i) {
                dstPts[dstOff++] = srcPts[srcOff++] + this.offsets[i];
            }
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        int dim;
        if (srcPts == dstPts && IterationStrategy.suggest(srcOff, dim = this.offsets.length, dstOff, dim, numPts) != IterationStrategy.ASCENDING) {
            srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * dim);
            srcOff = 0;
        }
        while (--numPts >= 0) {
            for (int i = 0; i < this.offsets.length; ++i) {
                dstPts[dstOff++] = (float)((double)srcPts[srcOff++] + this.offsets[i]);
            }
        }
    }

    @Override
    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        while (--numPts >= 0) {
            for (int i = 0; i < this.offsets.length; ++i) {
                dstPts[dstOff++] = (float)(srcPts[srcOff++] + this.offsets[i]);
            }
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        while (--numPts >= 0) {
            for (int i = 0; i < this.offsets.length; ++i) {
                dstPts[dstOff++] = (double)srcPts[srcOff++] + this.offsets[i];
            }
        }
    }

    @Override
    public Matrix derivative(DirectPosition point) {
        return Matrices.createIdentity(this.offsets.length);
    }

    @Override
    protected final LinearTransform createInverse() {
        return new TranslationTransform(this);
    }

    @Override
    protected int computeHashCode() {
        return Arrays.hashCode(this.offsets) + 31 * super.computeHashCode();
    }

    @Override
    protected boolean equalsSameClass(Object object) {
        TranslationTransform that = (TranslationTransform)object;
        return Arrays.equals(this.offsets, that.offsets) && Arrays.equals(this.numbers, that.numbers);
    }
}

