/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.codegen;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.attribute.MultiValueAttribute;
import com.googlecode.cqengine.attribute.MultiValueNullableAttribute;
import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.attribute.SimpleNullableAttribute;
import com.googlecode.cqengine.attribute.support.AbstractAttribute;
import com.googlecode.cqengine.codegen.AttributeNameProducers;
import com.googlecode.cqengine.codegen.AttributeSourceGenerator;
import com.googlecode.cqengine.codegen.MemberFilter;
import com.googlecode.cqengine.codegen.MemberFilters;
import com.googlecode.cqengine.codegen.support.GeneratedAttributeSupport;
import com.googlecode.cqengine.query.option.QueryOptions;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.bytecode.SignatureAttribute;

public class AttributeBytecodeGenerator {
    static final Map<Class<?>, Class<?>> PRIMITIVES_TO_WRAPPERS = new LinkedHashMap<Class<?>, Class<?>>(){
        {
            this.put(Boolean.TYPE, Boolean.class);
            this.put(Byte.TYPE, Byte.class);
            this.put(Character.TYPE, Character.class);
            this.put(Double.TYPE, Double.class);
            this.put(Float.TYPE, Float.class);
            this.put(Integer.TYPE, Integer.class);
            this.put(Long.TYPE, Long.class);
            this.put(Short.TYPE, Short.class);
            this.put(Void.TYPE, Void.class);
        }
    };

    public static <O> Map<String, ? extends Attribute<O, ?>> createAttributes(Class<O> pojoClass) {
        return AttributeBytecodeGenerator.createAttributes(pojoClass, MemberFilters.FIELDS_ONLY);
    }

    public static <O> Map<String, ? extends Attribute<O, ?>> createAttributes(Class<O> pojoClass, MemberFilter memberFilter) {
        return AttributeBytecodeGenerator.createAttributes(pojoClass, memberFilter, AttributeNameProducers.USE_MEMBER_NAMES_VERBATIM);
    }

    public static <O> Map<String, ? extends Attribute<O, ?>> createAttributes(Class<O> pojoClass, MemberFilter memberFilter, Function<Member, String> attributeNameProducer) {
        TreeMap<String, Attribute> attributes = new TreeMap<String, Attribute>();
        HashSet<String> membersEncountered = new HashSet<String>();
        for (Class<O> currentClass = pojoClass; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Member member : AttributeSourceGenerator.getMembers(currentClass)) {
                try {
                    Class<AbstractAttribute> attributeClass;
                    if (!memberFilter.accept(member) || membersEncountered.contains(member.getName())) continue;
                    int modifiers = member.getModifiers();
                    String memberName = member.getName();
                    String attributeName = attributeNameProducer.apply(member);
                    Class<?> memberType = AttributeSourceGenerator.getType(member);
                    if (Modifier.isStatic(modifiers) || Modifier.isPrivate(modifiers) || !member.getDeclaringClass().getPackage().getName().equals(pojoClass.getPackage().getName()) && !Modifier.isProtected(modifiers) && !Modifier.isPublic(modifiers)) continue;
                    if (memberType.isPrimitive()) {
                        Class<?> wrapperType = AttributeBytecodeGenerator.getWrapperForPrimitive(memberType);
                        attributeClass = member instanceof Method ? AttributeBytecodeGenerator.generateSimpleAttributeForGetter(pojoClass, wrapperType, memberName, attributeName) : AttributeBytecodeGenerator.generateSimpleAttributeForField(pojoClass, wrapperType, memberName, attributeName);
                    } else if (Iterable.class.isAssignableFrom(memberType)) {
                        ParameterizedType parameterizedType = AttributeSourceGenerator.getGenericType(member);
                        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                        if (actualTypeArguments.length != 1) {
                            throw new UnsupportedOperationException();
                        }
                        Class genericType = (Class)actualTypeArguments[0];
                        attributeClass = member instanceof Method ? AttributeBytecodeGenerator.generateMultiValueNullableAttributeForGetter(pojoClass, genericType, memberName, true, attributeName) : AttributeBytecodeGenerator.generateMultiValueNullableAttributeForField(pojoClass, genericType, memberName, true, attributeName);
                    } else if (memberType.isArray()) {
                        Class<?> componentType = memberType.getComponentType();
                        if (componentType.isPrimitive()) {
                            Class<?> wrapperType = AttributeBytecodeGenerator.getWrapperForPrimitive(componentType);
                            attributeClass = member instanceof Method ? AttributeBytecodeGenerator.generateMultiValueNullableAttributeForGetter(pojoClass, wrapperType, memberName, false, attributeName) : AttributeBytecodeGenerator.generateMultiValueNullableAttributeForField(pojoClass, wrapperType, memberName, false, attributeName);
                        } else {
                            attributeClass = member instanceof Method ? AttributeBytecodeGenerator.generateMultiValueNullableAttributeForGetter(pojoClass, componentType, memberName, true, attributeName) : AttributeBytecodeGenerator.generateMultiValueNullableAttributeForField(pojoClass, componentType, memberName, true, attributeName);
                        }
                    } else {
                        attributeClass = member instanceof Method ? AttributeBytecodeGenerator.generateSimpleNullableAttributeForGetter(pojoClass, memberType, memberName, attributeName) : AttributeBytecodeGenerator.generateSimpleNullableAttributeForField(pojoClass, memberType, memberName, attributeName);
                    }
                    Attribute attribute = attributeClass.newInstance();
                    attributes.put(attribute.getAttributeName(), attribute);
                    membersEncountered.add(member.getName());
                }
                catch (Throwable e) {
                    throw new IllegalStateException("Failed to create attribute for member: " + member.toString(), e);
                }
            }
        }
        return attributes;
    }

    public static <O, A> Class<? extends SimpleAttribute<O, A>> generateSimpleAttributeForField(Class<O> pojoClass, Class<A> attributeValueType, String fieldName, String attributeName) {
        AttributeBytecodeGenerator.ensureFieldExists(pojoClass, attributeValueType, fieldName, attributeName);
        return AttributeBytecodeGenerator.generateSimpleAttribute(SimpleAttribute.class, pojoClass, attributeValueType, attributeName, "object." + fieldName);
    }

    public static <O, A> Class<? extends SimpleAttribute<O, A>> generateSimpleAttributeForGetter(Class<O> pojoClass, Class<A> attributeValueType, String getterMethodName, String attributeName) {
        AttributeBytecodeGenerator.ensureGetterExists(pojoClass, attributeValueType, getterMethodName, attributeName);
        return AttributeBytecodeGenerator.generateSimpleAttribute(SimpleAttribute.class, pojoClass, attributeValueType, attributeName, "object." + getterMethodName + "()");
    }

    public static <O, A> Class<? extends SimpleAttribute<O, A>> generateSimpleAttributeForParameterizedGetter(Class<O> pojoClass, Class<A> attributeValueType, String getterMethodName, String getterParameter, String attributeName) {
        AttributeBytecodeGenerator.ensureParameterizedGetterExists(pojoClass, attributeValueType, getterMethodName, getterParameter, attributeName);
        return AttributeBytecodeGenerator.generateSimpleAttribute(SimpleAttribute.class, pojoClass, attributeValueType, attributeName, "object." + getterMethodName + "(\"" + getterParameter + "\")");
    }

    public static <O, A> Class<? extends SimpleNullableAttribute<O, A>> generateSimpleNullableAttributeForField(Class<O> pojoClass, Class<A> attributeValueType, String fieldName, String attributeName) {
        AttributeBytecodeGenerator.ensureFieldExists(pojoClass, attributeValueType, fieldName, attributeName);
        return AttributeBytecodeGenerator.generateSimpleAttribute(SimpleNullableAttribute.class, pojoClass, attributeValueType, attributeName, "object." + fieldName);
    }

    public static <O, A> Class<? extends SimpleNullableAttribute<O, A>> generateSimpleNullableAttributeForGetter(Class<O> pojoClass, Class<A> attributeValueType, String getterMethodName, String attributeName) {
        AttributeBytecodeGenerator.ensureGetterExists(pojoClass, attributeValueType, getterMethodName, attributeName);
        return AttributeBytecodeGenerator.generateSimpleAttribute(SimpleNullableAttribute.class, pojoClass, attributeValueType, attributeName, "object." + getterMethodName + "()");
    }

    public static <O, A> Class<? extends SimpleNullableAttribute<O, A>> generateSimpleNullableAttributeForParameterizedGetter(Class<O> pojoClass, Class<A> attributeValueType, String getterMethodName, String getterParameter, String attributeName) {
        AttributeBytecodeGenerator.ensureParameterizedGetterExists(pojoClass, attributeValueType, getterMethodName, getterParameter, attributeName);
        return AttributeBytecodeGenerator.generateSimpleAttribute(SimpleNullableAttribute.class, pojoClass, attributeValueType, attributeName, "object." + getterMethodName + "(\"" + getterParameter + "\")");
    }

    public static <O, A> Class<? extends MultiValueAttribute<O, A>> generateMultiValueAttributeForField(Class<O> pojoClass, Class<A> attributeValueType, String fieldName, String attributeName) {
        AttributeBytecodeGenerator.ensureFieldExists(pojoClass, attributeValueType, fieldName, attributeName);
        return AttributeBytecodeGenerator.generateMultiValueAttribute(MultiValueAttribute.class, pojoClass, attributeValueType, attributeName, "object." + fieldName);
    }

    public static <O, A> Class<? extends MultiValueAttribute<O, A>> generateMultiValueAttributeForGetter(Class<O> pojoClass, Class<A> attributeValueType, String getterMethodName, String attributeName) {
        AttributeBytecodeGenerator.ensureGetterExists(pojoClass, attributeValueType, getterMethodName, attributeName);
        return AttributeBytecodeGenerator.generateMultiValueAttribute(MultiValueAttribute.class, pojoClass, attributeValueType, attributeName, "object." + getterMethodName + "()");
    }

    public static <O, A> Class<? extends MultiValueAttribute<O, A>> generateMultiValueAttributeForParameterizedGetter(Class<O> pojoClass, Class<A> attributeValueType, String getterMethodName, String getterParameter, String attributeName) {
        AttributeBytecodeGenerator.ensureParameterizedGetterExists(pojoClass, attributeValueType, getterMethodName, getterParameter, attributeName);
        return AttributeBytecodeGenerator.generateMultiValueAttribute(MultiValueAttribute.class, pojoClass, attributeValueType, attributeName, "object." + getterMethodName + "(\"" + getterParameter + "\")");
    }

    public static <O, A> Class<? extends MultiValueNullableAttribute<O, A>> generateMultiValueNullableAttributeForField(Class<O> pojoClass, Class<A> attributeValueType, String fieldName, boolean componentValuesNullable, String attributeName) {
        AttributeBytecodeGenerator.ensureFieldExists(pojoClass, attributeValueType, fieldName, attributeName);
        return AttributeBytecodeGenerator.generateMultiValueNullableAttribute(MultiValueNullableAttribute.class, pojoClass, attributeValueType, attributeName, componentValuesNullable, "object." + fieldName);
    }

    public static <O, A> Class<? extends MultiValueNullableAttribute<O, A>> generateMultiValueNullableAttributeForGetter(Class<O> pojoClass, Class<A> attributeValueType, String getterMethodName, boolean componentValuesNullable, String attributeName) {
        AttributeBytecodeGenerator.ensureGetterExists(pojoClass, attributeValueType, getterMethodName, attributeName);
        return AttributeBytecodeGenerator.generateMultiValueNullableAttribute(MultiValueNullableAttribute.class, pojoClass, attributeValueType, attributeName, componentValuesNullable, "object." + getterMethodName + "()");
    }

    public static <O, A> Class<? extends MultiValueNullableAttribute<O, A>> generateMultiValueNullableAttributeForParameterizedGetter(Class<O> pojoClass, Class<A> attributeValueType, String getterMethodName, String getterParameter, boolean componentValuesNullable, String attributeName) {
        AttributeBytecodeGenerator.ensureParameterizedGetterExists(pojoClass, attributeValueType, getterMethodName, getterParameter, attributeName);
        return AttributeBytecodeGenerator.generateMultiValueNullableAttribute(MultiValueNullableAttribute.class, pojoClass, attributeValueType, attributeName, componentValuesNullable, "object." + getterMethodName + "(\"" + getterParameter + "\")");
    }

    private static <O, A, C extends Attribute<O, A>, R extends Class<? extends C>> R generateSimpleAttribute(Class<C> attributeSuperClass, Class<O> pojoClass, Class<A> attributeValueType, String attributeName, String target) {
        try {
            ClassPool pool = new ClassPool(false);
            pool.appendClassPath((ClassPath)new ClassClassPath(pojoClass));
            CtClass attributeClass = pool.makeClass(pojoClass.getName() + "$$CQEngine_" + attributeSuperClass.getSimpleName() + "_" + attributeName);
            attributeClass.setSuperclass(pool.get(attributeSuperClass.getName()));
            SignatureAttribute.ClassType genericTypeOfAttribute = new SignatureAttribute.ClassType(attributeSuperClass.getName(), new SignatureAttribute.TypeArgument[]{new SignatureAttribute.TypeArgument((SignatureAttribute.ObjectType)new SignatureAttribute.ClassType(pojoClass.getName())), new SignatureAttribute.TypeArgument((SignatureAttribute.ObjectType)new SignatureAttribute.ClassType(attributeValueType.getName()))});
            attributeClass.setGenericSignature(genericTypeOfAttribute.encode());
            CtConstructor constructor = CtNewConstructor.make((String)("public " + attributeClass.getSimpleName() + "() { super(\"" + attributeName + "\"); }"), (CtClass)attributeClass);
            attributeClass.addConstructor(constructor);
            CtMethod getterMethod = CtMethod.make((String)("public " + attributeValueType.getName() + " getValue(" + pojoClass.getName() + " object, " + QueryOptions.class.getName() + " queryOptions) { return (" + attributeValueType.getName() + ") " + GeneratedAttributeSupport.class.getName() + ".valueOf(" + target + "); }"), (CtClass)attributeClass);
            attributeClass.addMethod(getterMethod);
            CtMethod getterBridgeMethod = CtMethod.make((String)("public java.lang.Object getValue(java.lang.Object object, " + QueryOptions.class.getName() + " queryOptions) { return getValue((" + pojoClass.getName() + ")object, queryOptions); }"), (CtClass)attributeClass);
            getterBridgeMethod.setModifiers(getterBridgeMethod.getModifiers() | 0x40);
            attributeClass.addMethod(getterBridgeMethod);
            Class result = attributeClass.toClass(pojoClass.getClassLoader(), pojoClass.getProtectionDomain());
            attributeClass.detach();
            return (R)result;
        }
        catch (Exception e) {
            throw new IllegalStateException(AttributeBytecodeGenerator.getExceptionMessage(pojoClass, attributeValueType, attributeName), e);
        }
    }

    private static <O, A, C extends MultiValueAttribute<O, A>, R extends Class<? extends C>> R generateMultiValueAttribute(Class<C> attributeSuperClass, Class<O> pojoClass, Class<A> attributeValueType, String attributeName, String target) {
        try {
            ClassPool pool = new ClassPool(false);
            pool.appendClassPath((ClassPath)new ClassClassPath(pojoClass));
            CtClass attributeClass = pool.makeClass(pojoClass.getName() + "$$CQEngine_" + attributeSuperClass.getSimpleName() + "_" + attributeName);
            attributeClass.setSuperclass(pool.get(attributeSuperClass.getName()));
            SignatureAttribute.ClassType genericTypeOfAttribute = new SignatureAttribute.ClassType(attributeSuperClass.getName(), new SignatureAttribute.TypeArgument[]{new SignatureAttribute.TypeArgument((SignatureAttribute.ObjectType)new SignatureAttribute.ClassType(pojoClass.getName())), new SignatureAttribute.TypeArgument((SignatureAttribute.ObjectType)new SignatureAttribute.ClassType(attributeValueType.getName()))});
            attributeClass.setGenericSignature(genericTypeOfAttribute.encode());
            CtConstructor constructor = CtNewConstructor.make((String)("public " + attributeClass.getSimpleName() + "() { super(\"" + attributeName + "\"); }"), (CtClass)attributeClass);
            attributeClass.addConstructor(constructor);
            CtMethod getterMethod = CtMethod.make((String)("public java.lang.Iterable getValues(" + pojoClass.getName() + " object, " + QueryOptions.class.getName() + " queryOptions) { return " + GeneratedAttributeSupport.class.getName() + ".valueOf(" + target + "); }"), (CtClass)attributeClass);
            getterMethod.setGenericSignature(new SignatureAttribute.MethodSignature(new SignatureAttribute.TypeParameter[0], new SignatureAttribute.Type[]{new SignatureAttribute.ClassType(pojoClass.getName())}, (SignatureAttribute.Type)new SignatureAttribute.ClassType(Iterable.class.getName(), new SignatureAttribute.TypeArgument[]{new SignatureAttribute.TypeArgument((SignatureAttribute.ObjectType)new SignatureAttribute.ClassType(attributeValueType.getName()))}), new SignatureAttribute.ObjectType[0]).encode());
            attributeClass.addMethod(getterMethod);
            CtMethod getterBridgeMethod = CtMethod.make((String)("public java.lang.Iterable getValues(java.lang.Object object, " + QueryOptions.class.getName() + " queryOptions) { return getValues((" + pojoClass.getName() + ")object, queryOptions); }"), (CtClass)attributeClass);
            getterBridgeMethod.setModifiers(getterBridgeMethod.getModifiers() | 0x40);
            attributeClass.addMethod(getterBridgeMethod);
            Class result = attributeClass.toClass(pojoClass.getClassLoader(), pojoClass.getProtectionDomain());
            attributeClass.detach();
            return (R)result;
        }
        catch (Exception e) {
            throw new IllegalStateException(AttributeBytecodeGenerator.getExceptionMessage(pojoClass, attributeValueType, attributeName), e);
        }
    }

    private static <O, A, C extends MultiValueNullableAttribute<O, A>, R extends Class<? extends C>> R generateMultiValueNullableAttribute(Class<C> attributeSuperClass, Class<O> pojoClass, Class<A> attributeValueType, String attributeName, boolean componentValuesNullable, String target) {
        try {
            ClassPool pool = new ClassPool(false);
            pool.appendClassPath((ClassPath)new ClassClassPath(pojoClass));
            CtClass attributeClass = pool.makeClass(pojoClass.getName() + "$$CQEngine_" + attributeSuperClass.getSimpleName() + "_" + attributeName);
            attributeClass.setSuperclass(pool.get(attributeSuperClass.getName()));
            SignatureAttribute.ClassType genericTypeOfAttribute = new SignatureAttribute.ClassType(attributeSuperClass.getName(), new SignatureAttribute.TypeArgument[]{new SignatureAttribute.TypeArgument((SignatureAttribute.ObjectType)new SignatureAttribute.ClassType(pojoClass.getName())), new SignatureAttribute.TypeArgument((SignatureAttribute.ObjectType)new SignatureAttribute.ClassType(attributeValueType.getName()))});
            attributeClass.setGenericSignature(genericTypeOfAttribute.encode());
            CtConstructor constructor = CtNewConstructor.make((String)("public " + attributeClass.getSimpleName() + "() { super(\"" + attributeName + "\", " + componentValuesNullable + "); }"), (CtClass)attributeClass);
            attributeClass.addConstructor(constructor);
            CtMethod getterMethod = CtMethod.make((String)("public java.lang.Iterable getNullableValues(" + pojoClass.getName() + " object, " + QueryOptions.class.getName() + " queryOptions) { return " + GeneratedAttributeSupport.class.getName() + ".valueOf(" + target + "); }"), (CtClass)attributeClass);
            getterMethod.setGenericSignature(new SignatureAttribute.MethodSignature(new SignatureAttribute.TypeParameter[0], new SignatureAttribute.Type[]{new SignatureAttribute.ClassType(pojoClass.getName())}, (SignatureAttribute.Type)new SignatureAttribute.ClassType(Iterable.class.getName(), new SignatureAttribute.TypeArgument[]{new SignatureAttribute.TypeArgument((SignatureAttribute.ObjectType)new SignatureAttribute.ClassType(attributeValueType.getName()))}), new SignatureAttribute.ObjectType[0]).encode());
            attributeClass.addMethod(getterMethod);
            CtMethod getterBridgeMethod = CtMethod.make((String)("public java.lang.Iterable getNullableValues(java.lang.Object object, " + QueryOptions.class.getName() + " queryOptions) { return getNullableValues((" + pojoClass.getName() + ")object, queryOptions); }"), (CtClass)attributeClass);
            getterBridgeMethod.setModifiers(getterBridgeMethod.getModifiers() | 0x40);
            attributeClass.addMethod(getterBridgeMethod);
            Class result = attributeClass.toClass(pojoClass.getClassLoader(), pojoClass.getProtectionDomain());
            attributeClass.detach();
            return (R)result;
        }
        catch (Exception e) {
            throw new IllegalStateException(AttributeBytecodeGenerator.getExceptionMessage(pojoClass, attributeValueType, attributeName), e);
        }
    }

    static String getClassName(Class<?> cls) {
        return cls != null ? cls.getName() : null;
    }

    static void ensureFieldExists(Class<?> pojoClass, Class<?> attributeValueType, String fieldName, String attributeName) {
        try {
            while (pojoClass != null) {
                try {
                    pojoClass.getDeclaredField(fieldName);
                    return;
                }
                catch (NoSuchFieldException e) {
                    pojoClass = pojoClass.getSuperclass();
                }
            }
            throw new NoSuchFieldException(fieldName);
        }
        catch (Exception e) {
            throw new IllegalStateException(AttributeBytecodeGenerator.getExceptionMessage(pojoClass, attributeValueType, attributeName), e);
        }
    }

    static void ensureGetterExists(Class<?> pojoClass, Class<?> attributeValueType, String getterMethodName, String attributeName) {
        try {
            while (pojoClass != null) {
                try {
                    pojoClass.getDeclaredMethod(getterMethodName, new Class[0]);
                    return;
                }
                catch (NoSuchMethodException e) {
                    pojoClass = pojoClass.getSuperclass();
                }
            }
            throw new NoSuchMethodException(getterMethodName);
        }
        catch (Exception e) {
            throw new IllegalStateException(AttributeBytecodeGenerator.getExceptionMessage(pojoClass, attributeValueType, attributeName), e);
        }
    }

    static void ensureParameterizedGetterExists(Class<?> pojoClass, Class<?> attributeValueType, String parameterizedGetterMethodName, String getterParameter, String attributeName) {
        try {
            if (getterParameter.contains("\"") || getterParameter.contains("\\")) {
                throw new IllegalArgumentException("Getter parameter contains unsupported characters: " + getterParameter);
            }
            while (pojoClass != null) {
                try {
                    pojoClass.getDeclaredMethod(parameterizedGetterMethodName, String.class);
                    return;
                }
                catch (NoSuchMethodException e) {
                    pojoClass = pojoClass.getSuperclass();
                }
            }
            throw new NoSuchMethodException(parameterizedGetterMethodName + "(String)");
        }
        catch (Exception e) {
            throw new IllegalStateException(AttributeBytecodeGenerator.getExceptionMessage(pojoClass, attributeValueType, attributeName), e);
        }
    }

    static String getExceptionMessage(Class<?> pojoClass, Class<?> attributeValueType, String attributeName) {
        return "Failed to generate attribute for class " + AttributeBytecodeGenerator.getClassName(pojoClass) + ", type " + AttributeBytecodeGenerator.getClassName(attributeValueType) + ", name '" + attributeName + "'";
    }

    static Class<?> getWrapperForPrimitive(Class<?> primitiveType) {
        Class<?> wrapperType = PRIMITIVES_TO_WRAPPERS.get(primitiveType);
        if (wrapperType == null) {
            throw new IllegalStateException("No wrapper type for primitive type: " + primitiveType);
        }
        return wrapperType;
    }
}

