/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.kerberos;

import org.apache.kafka.common.security.kerberos.BadFormatString;
import org.apache.kafka.common.security.kerberos.KerberosRule;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class KerberosRuleTest {
    @Test
    public void testReplaceParameters() throws BadFormatString {
        Assertions.assertEquals((Object)KerberosRule.replaceParameters((String)"", (String[])new String[0]), (Object)"");
        Assertions.assertEquals((Object)KerberosRule.replaceParameters((String)"hello", (String[])new String[0]), (Object)"hello");
        Assertions.assertEquals((Object)KerberosRule.replaceParameters((String)"", (String[])new String[]{"too", "many", "parameters", "are", "ok"}), (Object)"");
        Assertions.assertEquals((Object)KerberosRule.replaceParameters((String)"hello", (String[])new String[]{"too", "many", "parameters", "are", "ok"}), (Object)"hello");
        Assertions.assertEquals((Object)KerberosRule.replaceParameters((String)"hello $0", (String[])new String[]{"too", "many", "parameters", "are", "ok"}), (Object)"hello too");
        Assertions.assertEquals((Object)KerberosRule.replaceParameters((String)"hello $0", (String[])new String[]{"no recursion $1"}), (Object)"hello no recursion $1");
        Assertions.assertThrows(BadFormatString.class, () -> KerberosRule.replaceParameters((String)"$0", (String[])new String[0]), (String)"An out-of-bounds parameter number should trigger an exception!");
        Assertions.assertThrows(BadFormatString.class, () -> KerberosRule.replaceParameters((String)"hello $a", (String[])new String[]{"does not matter"}), (String)"A malformed parameter name should trigger an exception!");
    }
}

