/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.propagation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.request.AbstractPatchItem;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.LinkedAccountUR;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.LinkedAccountTO;
import org.apache.syncope.common.lib.to.OrgUnit;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Attributable;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.policy.PropagationPolicy;
import org.apache.syncope.core.persistence.api.entity.task.PropagationData;
import org.apache.syncope.core.persistence.api.entity.user.LinkedAccount;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.UserWorkflowResult;
import org.apache.syncope.core.provisioning.api.jexl.JexlTools;
import org.apache.syncope.core.provisioning.api.propagation.PropagationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskInfo;
import org.apache.syncope.core.provisioning.java.propagation.DeletingLinkedAccount;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeDeltaBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Transactional(rollbackFor={Throwable.class})
public class DefaultPropagationManager
implements PropagationManager {
    protected static final Logger LOG = LoggerFactory.getLogger(PropagationManager.class);
    protected final ExternalResourceDAO resourceDAO;
    protected final EntityFactory entityFactory;
    protected final ConnObjectUtils connObjectUtils;
    protected final MappingManager mappingManager;
    protected final DerAttrHandler derAttrHandler;
    protected final AnyUtilsFactory anyUtilsFactory;
    protected final JexlTools jexlTools;

    public DefaultPropagationManager(ExternalResourceDAO resourceDAO, EntityFactory entityFactory, ConnObjectUtils connObjectUtils, MappingManager mappingManager, DerAttrHandler derAttrHandler, AnyUtilsFactory anyUtilsFactory, JexlTools jexlTools) {
        this.resourceDAO = resourceDAO;
        this.entityFactory = entityFactory;
        this.connObjectUtils = connObjectUtils;
        this.mappingManager = mappingManager;
        this.derAttrHandler = derAttrHandler;
        this.anyUtilsFactory = anyUtilsFactory;
        this.jexlTools = jexlTools;
    }

    public List<PropagationTaskInfo> getCreateTasks(AnyTypeKind kind, String key, Boolean enable, PropagationByResource<String> propByRes, Collection<String> excludedResources) {
        return this.getCreateTasks(this.anyUtilsFactory.getInstance(kind).dao().authFind(key), null, enable, propByRes, null, excludedResources);
    }

    public List<PropagationTaskInfo> getUserCreateTasks(String key, String password, Boolean enable, PropagationByResource<String> propByRes, PropagationByResource<Pair<String, String>> propByLinkedAccount, Collection<String> excludedResources) {
        return this.getCreateTasks(this.anyUtilsFactory.getInstance(AnyTypeKind.USER).dao().authFind(key), password, enable, propByRes, propByLinkedAccount, excludedResources);
    }

    protected List<PropagationTaskInfo> getCreateTasks(Any any, String password, Boolean enable, PropagationByResource<String> propByRes, PropagationByResource<Pair<String, String>> propByLinkedAccount, Collection<String> excludedResources) {
        if ((propByRes == null || propByRes.isEmpty()) && (propByLinkedAccount == null || propByLinkedAccount.isEmpty())) {
            return List.of();
        }
        ArrayList<String> changePwdRes = new ArrayList<String>();
        if (excludedResources != null) {
            if (propByRes != null) {
                propByRes.get(ResourceOperation.CREATE).removeAll(excludedResources);
            }
            if (propByLinkedAccount != null) {
                propByLinkedAccount.get(ResourceOperation.CREATE).removeIf(account -> excludedResources.contains(account.getLeft()));
            }
        }
        if (propByRes != null) {
            propByRes.asMap().forEach((resource, resourceOperation) -> changePwdRes.add((String)resource));
        }
        if (propByLinkedAccount != null) {
            propByLinkedAccount.asMap().forEach((resource, resourceOperation) -> changePwdRes.add((String)resource.getKey()));
        }
        return this.createTasks(any, password, changePwdRes, enable, propByRes, propByLinkedAccount);
    }

    public List<PropagationTaskInfo> getUpdateTasks(AnyUR anyUR, AnyTypeKind kind, String key, List<String> changePwdRes, Boolean enable, PropagationByResource<String> propByRes, PropagationByResource<Pair<String, String>> propByLinkedAccount, Collection<String> excludedResources) {
        return this.getUpdateTasks(anyUR, this.anyUtilsFactory.getInstance(kind).dao().authFind(key), null, changePwdRes, enable, propByRes, propByLinkedAccount, excludedResources);
    }

    public List<PropagationTaskInfo> getUserUpdateTasks(UserWorkflowResult<Pair<UserUR, Boolean>> wfResult, List<String> changePwdRes, Collection<String> excludedResources) {
        return this.getUpdateTasks((AnyUR)((Pair)wfResult.getResult()).getLeft(), this.anyUtilsFactory.getInstance(AnyTypeKind.USER).dao().authFind(((UserUR)((Pair)wfResult.getResult()).getLeft()).getKey()), (String)Optional.ofNullable(((UserUR)((Pair)wfResult.getResult()).getLeft()).getPassword()).map(AbstractPatchItem::getValue).orElse(null), changePwdRes, (Boolean)((Pair)wfResult.getResult()).getRight(), (PropagationByResource<String>)wfResult.getPropByRes(), (PropagationByResource<Pair<String, String>>)wfResult.getPropByLinkedAccount(), excludedResources);
    }

    public List<PropagationTaskInfo> getUserUpdateTasks(UserWorkflowResult<Pair<UserUR, Boolean>> wfResult) {
        ArrayList<PropagationTaskInfo> tasks;
        UserUR userUR = (UserUR)((Pair)wfResult.getResult()).getLeft();
        List urPwdResources = userUR.getPassword() == null ? List.of() : userUR.getPassword().getResources().stream().distinct().toList();
        List<String> laPwdResources = userUR.getLinkedAccounts().stream().filter(laur -> laur.getOperation() == PatchOperation.ADD_REPLACE).map(LinkedAccountUR::getLinkedAccountTO).filter(la -> la != null && la.getPassword() != null).map(LinkedAccountTO::getResource).distinct().toList();
        List<String> pwdResources = Stream.concat(urPwdResources.stream(), laPwdResources.stream()).distinct().toList();
        if (pwdResources.isEmpty()) {
            tasks = this.getUserUpdateTasks(wfResult, List.of(), null);
        } else {
            tasks = new ArrayList();
            PropagationByResource urNoPwdPropByRes = new PropagationByResource();
            urNoPwdPropByRes.merge(wfResult.getPropByRes());
            urNoPwdPropByRes.purge();
            urNoPwdPropByRes.removeAll(urPwdResources);
            PropagationByResource laNoPwdPropByRes = new PropagationByResource();
            laNoPwdPropByRes.merge(wfResult.getPropByLinkedAccount());
            laNoPwdPropByRes.purge();
            laNoPwdPropByRes.removeIf(p -> laPwdResources.contains(p.getLeft()));
            if (!urNoPwdPropByRes.isEmpty() || !laNoPwdPropByRes.isEmpty()) {
                UserWorkflowResult noPwdWFResult = new UserWorkflowResult((Object)((Pair)wfResult.getResult()), new UserWorkflowResult.PropagationInfo(urNoPwdPropByRes, laNoPwdPropByRes), wfResult.getPerformedTasks());
                tasks.addAll(this.getUserUpdateTasks((UserWorkflowResult<Pair<UserUR, Boolean>>)noPwdWFResult, List.of(), null));
            }
            PropagationByResource urPwdPropByRes = new PropagationByResource();
            urPwdPropByRes.merge(wfResult.getPropByRes());
            urPwdPropByRes.purge();
            urPwdPropByRes.retainAll(urPwdResources);
            PropagationByResource laPwdPropByRes = new PropagationByResource();
            laPwdPropByRes.merge(wfResult.getPropByLinkedAccount());
            laPwdPropByRes.purge();
            laPwdPropByRes.removeIf(p -> !laPwdResources.contains(p.getLeft()));
            if (!urPwdPropByRes.isEmpty() || !laPwdPropByRes.isEmpty()) {
                UserWorkflowResult pwdWFResult = new UserWorkflowResult((Object)((Pair)wfResult.getResult()), new UserWorkflowResult.PropagationInfo(urPwdPropByRes, laPwdPropByRes), wfResult.getPerformedTasks());
                tasks.addAll(this.getUserUpdateTasks((UserWorkflowResult<Pair<UserUR, Boolean>>)pwdWFResult, pwdResources, null));
            }
        }
        return tasks;
    }

    protected List<PropagationTaskInfo> getUpdateTasks(AnyUR anyUR, Any any, String password, List<String> changePwdRes, Boolean enable, PropagationByResource<String> propByRes, PropagationByResource<Pair<String, String>> propByLinkedAccount, Collection<String> excludedResources) {
        if (excludedResources != null) {
            if (propByRes != null) {
                propByRes.removeAll(excludedResources);
            }
            if (propByLinkedAccount != null) {
                propByLinkedAccount.get(ResourceOperation.CREATE).removeIf(account -> excludedResources.contains(account.getLeft()));
                propByLinkedAccount.get(ResourceOperation.UPDATE).removeIf(account -> excludedResources.contains(account.getLeft()));
                propByLinkedAccount.get(ResourceOperation.DELETE).removeIf(account -> excludedResources.contains(account.getLeft()));
            }
        }
        List<PropagationTaskInfo> tasks = this.createTasks(any, password, changePwdRes, enable, (PropagationByResource<String>)Optional.ofNullable(propByRes).orElseGet(PropagationByResource::new), propByLinkedAccount);
        tasks.forEach(task -> task.setUpdateRequest(anyUR));
        return tasks;
    }

    public List<PropagationTaskInfo> getDeleteTasks(AnyTypeKind kind, String key, PropagationByResource<String> propByRes, PropagationByResource<Pair<String, String>> propByLinkedAccount, Collection<String> excludedResources) {
        return this.getDeleteTasks(this.anyUtilsFactory.getInstance(kind).dao().authFind(key), propByRes, propByLinkedAccount, excludedResources);
    }

    protected List<PropagationTaskInfo> getDeleteTasks(Any any, PropagationByResource<String> propByRes, PropagationByResource<Pair<String, String>> propByLinkedAccount, Collection<String> excludedResources) {
        PropagationByResource localPropByRes = new PropagationByResource();
        if (propByRes == null || propByRes.isEmpty()) {
            localPropByRes.addAll(ResourceOperation.DELETE, this.anyUtilsFactory.getInstance(any).dao().findAllResourceKeys(any.getKey()));
        } else {
            localPropByRes.merge(propByRes);
        }
        if (excludedResources != null) {
            localPropByRes.removeAll(excludedResources);
            if (propByLinkedAccount != null) {
                propByLinkedAccount.get(ResourceOperation.CREATE).removeIf(account -> excludedResources.contains(account.getLeft()));
                propByLinkedAccount.get(ResourceOperation.UPDATE).removeIf(account -> excludedResources.contains(account.getLeft()));
                propByLinkedAccount.get(ResourceOperation.DELETE).removeIf(account -> excludedResources.contains(account.getLeft()));
            }
        }
        return this.createTasks(any, null, List.of(), false, (PropagationByResource<String>)localPropByRes, propByLinkedAccount);
    }

    public PropagationTaskInfo newTask(DerAttrHandler derAttrHandler, Any any, ExternalResource resource, ResourceOperation operation, Provision provision, Stream<Item> mappingItems, MappingManager.PreparedAttrs preparedAttrs) {
        ArrayList mandatoryMissing = new ArrayList();
        ArrayList mandatoryNullOrEmpty = new ArrayList();
        mappingItems.filter(item -> !item.isConnObjectKey() && this.jexlTools.evaluateMandatoryCondition(item.getMandatoryCondition(), (Attributable)any, derAttrHandler)).forEach(item -> {
            Attribute attr = AttributeUtil.find((String)item.getExtAttrName(), (Set)preparedAttrs.attributes());
            if (attr == null) {
                mandatoryMissing.add(item.getExtAttrName());
            } else if (CollectionUtils.isEmpty((Collection)attr.getValue())) {
                mandatoryNullOrEmpty.add(item.getExtAttrName());
            }
        });
        if (!mandatoryMissing.isEmpty()) {
            preparedAttrs.attributes().add(AttributeBuilder.build((String)"__MANDATORY_MISSING__", mandatoryMissing));
        }
        if (!mandatoryNullOrEmpty.isEmpty()) {
            preparedAttrs.attributes().add(AttributeBuilder.build((String)"__MANDATORY_NULL_OR_EMPTY__", mandatoryNullOrEmpty));
        }
        return new PropagationTaskInfo(resource, operation, new ObjectClass(provision.getObjectClass()), any.getType().getKind(), any.getType().getKey(), any.getKey(), preparedAttrs.connObjectLink(), new PropagationData(preparedAttrs.attributes()));
    }

    protected List<PropagationTaskInfo> createTasks(Any any, String password, List<String> changePwdRes, Boolean enable, PropagationByResource<String> propByRes, PropagationByResource<Pair<String, String>> propByLinkedAccount) {
        LOG.debug("Provisioning {}:\n{}", (Object)any, propByRes);
        propByRes.purge();
        LOG.debug("After purge {}:\n{}", (Object)any, propByRes);
        ArrayList<PropagationTaskInfo> tasks = new ArrayList<PropagationTaskInfo>();
        propByRes.asMap().forEach((resourceKey, operation) -> {
            Stream<Item> mappingItems;
            ExternalResource resource = this.resourceDAO.findById(resourceKey).orElse(null);
            Provision provision = Optional.ofNullable(resource).flatMap(r -> r.getProvisionByAnyType(any.getType().getKey())).orElse(null);
            Stream<Item> stream = mappingItems = provision == null ? Stream.empty() : MappingUtils.getPropagationItems(provision.getMapping().getItems().stream());
            if (resource == null) {
                LOG.error("Invalid resource name specified: {}, ignoring...", resourceKey);
            } else if (provision == null) {
                LOG.error("No provision specified on resource {} for type {}, ignoring...", (Object)resource, (Object)any.getType());
            } else if (provision.getMapping() == null || provision.getMapping().getItems().isEmpty()) {
                LOG.warn("Requesting propagation for {} but no propagation mapping provided for {}", (Object)any.getType(), (Object)resource);
            } else {
                MappingManager.PreparedAttrs preparedAttrs = this.mappingManager.prepareAttrsFromAny(any, password, changePwdRes.contains(resourceKey), enable, resource, provision);
                PropagationTaskInfo task = this.newTask(this.derAttrHandler, any, resource, (ResourceOperation)operation, provision, mappingItems, preparedAttrs);
                task.setOldConnObjectKey(propByRes.getOldConnObjectKey(resourceKey));
                tasks.add(task);
                LOG.debug("PropagationTask created: {}", (Object)task);
            }
        });
        if (any instanceof User) {
            User user = (User)any;
            if (propByLinkedAccount != null) {
                propByLinkedAccount.asMap().forEach((accountInfo, operation) -> {
                    Stream<Item> mappingItems;
                    LinkedAccount account = user.getLinkedAccount((String)accountInfo.getLeft(), (String)accountInfo.getRight()).orElse(null);
                    if (account == null && operation == ResourceOperation.DELETE) {
                        account = new DeletingLinkedAccount(user, (ExternalResource)this.resourceDAO.findById((String)accountInfo.getLeft()).orElseThrow(() -> new NotFoundException("Resource " + (String)accountInfo.getLeft())), (String)accountInfo.getRight());
                    }
                    Provision provision = account == null || account.getResource() == null ? null : (Provision)account.getResource().getProvisionByAnyType(AnyTypeKind.USER.name()).orElse(null);
                    Stream<Item> stream = mappingItems = provision == null ? Stream.empty() : MappingUtils.getPropagationItems(provision.getMapping().getItems().stream());
                    if (account == null) {
                        LOG.error("Invalid operation {} on deleted account {} on resource {}, ignoring...", new Object[]{operation, accountInfo.getRight(), accountInfo.getLeft()});
                    } else if (account.getResource() == null) {
                        LOG.error("Invalid resource name specified: {}, ignoring...", accountInfo.getLeft());
                    } else if (provision == null) {
                        LOG.error("No provision specified on resource {} for type {}, ignoring...", (Object)account.getResource(), (Object)AnyTypeKind.USER.name());
                    } else if (provision.getMapping() == null || provision.getMapping().getItems().isEmpty()) {
                        LOG.warn("Requesting propagation for {} but no propagation mapping provided for {}", (Object)AnyTypeKind.USER.name(), (Object)account.getResource());
                    } else {
                        PropagationTaskInfo accountTask = this.newTask(this.derAttrHandler, (Any)user, account.getResource(), (ResourceOperation)operation, provision, mappingItems, new MappingManager.PreparedAttrs(account.getConnObjectKeyValue(), this.mappingManager.prepareAttrsFromLinkedAccount(user, account, password, changePwdRes.contains(account.getResource().getKey()), provision)));
                        tasks.add(accountTask);
                        LOG.debug("PropagationTask created for Linked Account {}: {}", (Object)account.getConnObjectKeyValue(), (Object)accountTask);
                    }
                });
            }
        }
        return tasks;
    }

    public List<PropagationTaskInfo> createTasks(Realm realm, PropagationByResource<String> propByRes, Collection<String> excludedResources) {
        if (excludedResources != null) {
            propByRes.removeAll(excludedResources);
        }
        LOG.debug("Provisioning {}:\n{}", (Object)realm, propByRes);
        propByRes.purge();
        LOG.debug("After purge {}:\n{}", (Object)realm, propByRes);
        ArrayList<PropagationTaskInfo> tasks = new ArrayList<PropagationTaskInfo>();
        propByRes.asMap().forEach((resourceKey, operation) -> {
            ExternalResource resource = this.resourceDAO.findById(resourceKey).orElse(null);
            OrgUnit orgUnit = Optional.ofNullable(resource).map(ExternalResource::getOrgUnit).orElse(null);
            if (resource == null) {
                LOG.error("Invalid resource name specified: {}, ignoring...", resourceKey);
            } else if (orgUnit == null) {
                LOG.error("No orgUnit specified on resource {}, ignoring...", (Object)resource);
            } else {
                MappingManager.PreparedAttrs preparedAttrs = this.mappingManager.prepareAttrsFromRealm(realm, resource);
                PropagationTaskInfo task = new PropagationTaskInfo(resource, operation, new ObjectClass(orgUnit.getObjectClass()), null, null, realm.getKey(), preparedAttrs.connObjectLink(), new PropagationData(preparedAttrs.attributes()));
                task.setOldConnObjectKey(propByRes.getOldConnObjectKey(resource.getKey()));
                tasks.add(task);
                LOG.debug("PropagationTask created: {}", (Object)task);
            }
        });
        return tasks;
    }

    @Transactional(readOnly=true, propagation=Propagation.REQUIRES_NEW)
    public List<PropagationManager.PropagationAttrs> prepareAttrs(AnyTypeKind kind, String key, String password, List<String> changePwdRes, Boolean enable, Collection<String> excludedResources) {
        ArrayList<PropagationManager.PropagationAttrs> attrs = new ArrayList<PropagationManager.PropagationAttrs>();
        Any any = this.anyUtilsFactory.getInstance(kind).dao().authFind(key);
        this.anyUtilsFactory.getInstance(kind).dao().findAllResourceKeys(key).stream().filter(Predicate.not(excludedResources::contains)).map(arg_0 -> ((ExternalResourceDAO)this.resourceDAO).findById(arg_0)).flatMap(Optional::stream).filter(resource -> Optional.ofNullable(resource.getPropagationPolicy()).map(PropagationPolicy::isUpdateDelta).orElse(false)).forEach(resource -> resource.getProvisionByAnyType(any.getType().getKey()).ifPresent(provision -> {
            MappingManager.PreparedAttrs preparedAttrs = this.mappingManager.prepareAttrsFromAny(any, password, changePwdRes.contains(resource.getKey()), enable, resource, provision);
            attrs.add(new PropagationManager.PropagationAttrs(resource.getKey(), preparedAttrs.connObjectLink(), preparedAttrs.attributes()));
        }));
        if (any instanceof User) {
            User user = (User)any;
            user.getLinkedAccounts().stream().filter(account -> !excludedResources.contains(account.getResource().getKey()) && account.getResource().getProvisionByAnyType(user.getType().getKey()).isPresent() && Optional.ofNullable(account.getResource().getPropagationPolicy()).map(PropagationPolicy::isUpdateDelta).orElse(false) != false).forEach(account -> account.getResource().getProvisionByAnyType(user.getType().getKey()).ifPresent(provision -> {
                Set preparedAttrs = this.mappingManager.prepareAttrsFromLinkedAccount(user, account, password, true, provision);
                attrs.add(new PropagationManager.PropagationAttrs(account.getResource().getKey(), account.getConnObjectKeyValue(), preparedAttrs));
            }));
        }
        LOG.debug("Prepared attrs for {} {}: {}", new Object[]{kind, key, attrs});
        return attrs;
    }

    @Transactional(readOnly=true, propagation=Propagation.REQUIRES_NEW)
    public List<PropagationManager.PropagationAttrs> prepareAttrs(Realm realm) {
        ArrayList<PropagationManager.PropagationAttrs> attrs = new ArrayList<PropagationManager.PropagationAttrs>();
        realm.getResources().stream().filter(resource -> resource.getOrgUnit() != null && Optional.ofNullable(resource.getPropagationPolicy()).map(PropagationPolicy::isUpdateDelta).orElse(false) != false).forEach(resource -> {
            MappingManager.PreparedAttrs preparedAttrs = this.mappingManager.prepareAttrsFromRealm(realm, resource);
            attrs.add(new PropagationManager.PropagationAttrs(resource.getKey(), preparedAttrs.connObjectLink(), preparedAttrs.attributes()));
        });
        LOG.debug("Prepared attrs for Realm {}: {}", (Object)realm.getKey(), attrs);
        return attrs;
    }

    protected boolean isOrdinaryForAttrForDelta(Attribute attr) {
        return !attr.is(Name.NAME) && !OperationalAttributes.isOperationalAttribute((Attribute)attr);
    }

    public List<PropagationTaskInfo> setAttributeDeltas(List<PropagationTaskInfo> tasks, List<PropagationManager.PropagationAttrs> beforeAttrs) {
        if (beforeAttrs.isEmpty()) {
            return tasks;
        }
        for (PropagationTaskInfo task : tasks) {
            PropagationManager.PropagationAttrs propagationAttrs;
            if (task.getOldConnObjectKey() != null && !task.getConnObjectKey().equals(task.getOldConnObjectKey()) || (propagationAttrs = (PropagationManager.PropagationAttrs)beforeAttrs.stream().filter(attr -> attr.resource().equals(task.getResource().getKey()) && attr.connObjectLink().equals(task.getConnObjectKey())).findFirst().orElse(null)) == null) continue;
            Set attrs = propagationAttrs.attributes();
            attrs.removeIf(attr -> "__MANDATORY_MISSING__".equals(attr.getName()) || "__MANDATORY_NULL_OR_EMPTY__".equals(attr.getName()));
            PropagationData propagationData = task.getPropagationData();
            HashSet attributeDeltas = new HashSet();
            propagationData.getAttributes().forEach(next -> {
                HashSet valuesToAdd = new HashSet();
                HashSet valuesToRemove = new HashSet();
                Optional.ofNullable(AttributeUtil.find((String)next.getName(), (Set)attrs)).ifPresent(prev -> {
                    if (next.is(OperationalAttributes.PASSWORD_NAME)) {
                        valuesToAdd.addAll(next.getValue());
                    } else if (next.getValue() == null && prev.getValue() != null) {
                        valuesToRemove.addAll(prev.getValue());
                    } else if (next.getValue() != null && prev.getValue() == null) {
                        valuesToAdd.addAll(next.getValue());
                    } else if (next.getValue() != null && prev.getValue() != null) {
                        next.getValue().stream().filter(value -> !prev.getValue().contains(value)).forEach(valuesToAdd::add);
                        prev.getValue().stream().filter(value -> !next.getValue().contains(value)).forEach(valuesToRemove::add);
                    }
                });
                if (this.isOrdinaryForAttrForDelta((Attribute)next)) {
                    if (!valuesToAdd.isEmpty() || !valuesToRemove.isEmpty()) {
                        attributeDeltas.add(AttributeDeltaBuilder.build((String)next.getName(), valuesToAdd, valuesToRemove));
                    }
                } else if (!valuesToAdd.isEmpty()) {
                    attributeDeltas.add(AttributeDeltaBuilder.build((String)next.getName(), valuesToAdd));
                }
            });
            Set nextNames = propagationData.getAttributes().stream().filter(this::isOrdinaryForAttrForDelta).map(Attribute::getName).collect(Collectors.toSet());
            Set prevNames = attrs.stream().filter(this::isOrdinaryForAttrForDelta).map(Attribute::getName).collect(Collectors.toSet());
            nextNames.stream().filter(name -> !prevNames.contains(name)).forEach(toAdd -> Optional.ofNullable(AttributeUtil.find((String)toAdd, (Set)propagationData.getAttributes())).ifPresent(attr -> attributeDeltas.add(AttributeDeltaBuilder.build((String)attr.getName(), (Collection)attr.getValue(), Set.of()))));
            prevNames.stream().filter(name -> !nextNames.contains(name)).forEach(toRemove -> Optional.ofNullable(AttributeUtil.find((String)toRemove, (Set)attrs)).ifPresent(attr -> attributeDeltas.add(AttributeDeltaBuilder.build((String)attr.getName(), Set.of(), (Collection)attr.getValue()))));
            if (attributeDeltas.isEmpty()) continue;
            propagationData.setAttributeDeltas(attributeDeltas);
        }
        return tasks;
    }
}

