/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.http;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.FieldExtension;
import org.flowable.bpmn.model.FlowableHttpRequestHandler;
import org.flowable.bpmn.model.FlowableHttpResponseHandler;
import org.flowable.bpmn.model.HttpServiceTask;
import org.flowable.bpmn.model.ScriptInfo;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.async.AsyncTaskInvoker;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.el.FixedValue;
import org.flowable.common.engine.impl.util.ExceptionUtil;
import org.flowable.engine.cfg.HttpClientConfig;
import org.flowable.engine.delegate.BpmnError;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.FutureJavaDelegate;
import org.flowable.engine.impl.bpmn.helper.ErrorPropagation;
import org.flowable.engine.impl.bpmn.http.handler.ClassDelegateHttpHandler;
import org.flowable.engine.impl.bpmn.http.handler.DelegateExpressionHttpHandler;
import org.flowable.engine.impl.bpmn.http.handler.ScriptHttpHandler;
import org.flowable.engine.impl.bpmn.parser.FieldDeclaration;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.http.common.api.HttpResponse;
import org.flowable.http.common.api.client.FlowableHttpClient;
import org.flowable.http.common.api.delegate.HttpRequestHandler;
import org.flowable.http.common.api.delegate.HttpResponseHandler;
import org.flowable.http.common.impl.BaseHttpActivityDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBpmnHttpActivityDelegate
extends BaseHttpActivityDelegate
implements FutureJavaDelegate<BaseHttpActivityDelegate.ExecutionData> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBpmnHttpActivityDelegate.class);

    public DefaultBpmnHttpActivityDelegate() {
        this(null);
    }

    public DefaultBpmnHttpActivityDelegate(FlowableHttpClient httpClient) {
        super(httpClient);
    }

    protected FlowableHttpClient createHttpClient() {
        HttpClientConfig config = CommandContextUtil.getProcessEngineConfiguration().getHttpClientConfig();
        return config.determineHttpClient();
    }

    @Override
    public CompletableFuture<BaseHttpActivityDelegate.ExecutionData> execute(DelegateExecution execution, AsyncTaskInvoker taskInvoker) {
        BaseHttpActivityDelegate.RequestData request;
        HttpServiceTask httpServiceTask = (HttpServiceTask)execution.getCurrentFlowElement();
        try {
            request = this.createRequest((VariableContainer)execution, httpServiceTask.getId());
        }
        catch (Exception e) {
            if (e instanceof FlowableException) {
                throw (FlowableException)((Object)e);
            }
            throw new FlowableException("request fields are invalid in execution " + String.valueOf(execution), (Throwable)e);
        }
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        HttpRequestHandler httpRequestHandler = this.createHttpRequestHandler(httpServiceTask.getHttpRequestHandler(), processEngineConfiguration);
        if (httpRequestHandler != null) {
            httpRequestHandler.handleHttpRequest((VariableContainer)execution, request.getHttpRequest(), null);
        }
        this.validateRequest(request.getHttpRequest());
        boolean parallelInSameTransaction = httpServiceTask.getParallelInSameTransaction() != null ? httpServiceTask.getParallelInSameTransaction().booleanValue() : processEngineConfiguration.getHttpClientConfig().isDefaultParallelInSameTransaction();
        return this.prepareAndExecuteRequest(request, parallelInSameTransaction, taskInvoker);
    }

    @Override
    public void afterExecution(DelegateExecution execution, BaseHttpActivityDelegate.ExecutionData result) {
        BaseHttpActivityDelegate.RequestData request = result.getRequest();
        HttpResponse response = result.getResponse();
        Throwable resultException = result.getException();
        if (resultException != null) {
            if (request.isIgnoreErrors()) {
                LOGGER.info("Error ignored while processing http task in execution {}", (Object)execution.getId(), (Object)resultException);
                execution.setVariable(request.getPrefix() + "ErrorMessage", resultException.getMessage());
                return;
            }
            ExceptionUtil.sneakyThrow((Throwable)resultException);
        }
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        HttpServiceTask httpServiceTask = (HttpServiceTask)execution.getCurrentFlowElement();
        try {
            HttpResponseHandler httpResponseHandler = this.createHttpResponseHandler(httpServiceTask.getHttpResponseHandler(), processEngineConfiguration);
            if (httpResponseHandler != null) {
                httpResponseHandler.handleHttpResponse((VariableContainer)execution, response);
            }
            this.saveResponseFields((VariableContainer)execution, request, response, processEngineConfiguration.getObjectMapper());
        }
        catch (BpmnError e) {
            throw e;
        }
        catch (Exception ex) {
            if (request.isIgnoreErrors()) {
                LOGGER.info("Error ignored while processing http task in execution {}", (Object)execution.getId(), (Object)ex);
                execution.setVariable(request.getPrefix() + "ErrorMessage", ex.getMessage());
            }
            ExceptionUtil.sneakyThrow((Throwable)ex);
        }
    }

    protected HttpRequestHandler createHttpRequestHandler(FlowableHttpRequestHandler handler, ProcessEngineConfigurationImpl processEngineConfiguration) {
        HttpRequestHandler requestHandler = null;
        if (handler != null) {
            ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
            if ("class".equalsIgnoreCase(handler.getImplementationType())) {
                requestHandler = new ClassDelegateHttpHandler(handler.getImplementation(), this.createFieldDeclarations(handler.getFieldExtensions(), processEngineConfiguration));
            } else if ("delegateExpression".equalsIgnoreCase(handler.getImplementationType())) {
                requestHandler = new DelegateExpressionHttpHandler(expressionManager.createExpression(handler.getImplementation()), this.createFieldDeclarations(handler.getFieldExtensions(), processEngineConfiguration));
            } else if ("script".equalsIgnoreCase(handler.getImplementationType()) && handler.getScriptInfo() != null) {
                ScriptHttpHandler scriptHttpHandler = this.createScriptHttpHandler(expressionManager, handler.getScriptInfo());
                requestHandler = scriptHttpHandler;
            }
        }
        return requestHandler;
    }

    protected Expression createExpression(ExpressionManager expManager, Object value) {
        return value instanceof String ? expManager.createExpression((String)value) : new FixedValue(value);
    }

    protected HttpResponseHandler createHttpResponseHandler(FlowableHttpResponseHandler handler, ProcessEngineConfigurationImpl processEngineConfiguration) {
        HttpRequestHandler responseHandler = null;
        if (handler != null) {
            ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
            if ("class".equalsIgnoreCase(handler.getImplementationType())) {
                responseHandler = new ClassDelegateHttpHandler(handler.getImplementation(), this.createFieldDeclarations(handler.getFieldExtensions(), processEngineConfiguration));
            } else if ("delegateExpression".equalsIgnoreCase(handler.getImplementationType())) {
                responseHandler = new DelegateExpressionHttpHandler(expressionManager.createExpression(handler.getImplementation()), this.createFieldDeclarations(handler.getFieldExtensions(), processEngineConfiguration));
            } else if ("script".equalsIgnoreCase(handler.getImplementationType()) && handler.getScriptInfo() != null) {
                ScriptHttpHandler scriptHttpHandler = this.createScriptHttpHandler(expressionManager, handler.getScriptInfo());
                responseHandler = scriptHttpHandler;
            }
        }
        return responseHandler;
    }

    protected ScriptHttpHandler createScriptHttpHandler(ExpressionManager expressionManager, ScriptInfo scriptInfo) {
        ScriptHttpHandler scriptHttpHandler = new ScriptHttpHandler(this.createExpression(expressionManager, scriptInfo.getLanguage()), scriptInfo.getScript());
        if (scriptInfo.getResultVariable() != null) {
            scriptHttpHandler.setResultVariable(this.createExpression(expressionManager, scriptInfo.getResultVariable()));
        }
        return scriptHttpHandler;
    }

    protected List<FieldDeclaration> createFieldDeclarations(List<FieldExtension> fieldList, ProcessEngineConfigurationImpl processEngineConfiguration) {
        ArrayList<FieldDeclaration> fieldDeclarations = new ArrayList<FieldDeclaration>();
        for (FieldExtension fieldExtension : fieldList) {
            FieldDeclaration fieldDeclaration = StringUtils.isNotEmpty((CharSequence)fieldExtension.getExpression()) ? new FieldDeclaration(fieldExtension.getFieldName(), Expression.class.getName(), processEngineConfiguration.getExpressionManager().createExpression(fieldExtension.getExpression())) : new FieldDeclaration(fieldExtension.getFieldName(), Expression.class.getName(), new FixedValue((Object)fieldExtension.getStringValue()));
            fieldDeclarations.add(fieldDeclaration);
        }
        return fieldDeclarations;
    }

    protected void propagateError(VariableContainer container, String code) {
        ErrorPropagation.propagateError("HTTP" + code, (DelegateExecution)container);
    }
}

