/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;

public final class SyncDeltaBuilder {
    private SyncToken syncToken;
    private SyncDeltaType deltaType;
    private Uid previousUid;
    private ObjectClass objectClass;
    private Uid uid;
    private ConnectorObject connectorObject;

    public SyncDeltaBuilder() {
    }

    public SyncDeltaBuilder(SyncDelta delta) {
        this.syncToken = delta.getToken();
        this.deltaType = delta.getDeltaType();
        this.connectorObject = delta.getObject();
        this.previousUid = delta.getPreviousUid();
        this.objectClass = delta.getObjectClass();
        this.uid = delta.getUid();
    }

    public SyncToken getToken() {
        return this.syncToken;
    }

    public SyncDeltaBuilder setToken(SyncToken token) {
        this.syncToken = token;
        return this;
    }

    public SyncDeltaType getDeltaType() {
        return this.deltaType;
    }

    public SyncDeltaBuilder setDeltaType(SyncDeltaType type) {
        this.deltaType = type;
        return this;
    }

    public Uid getPreviousUid() {
        return this.previousUid;
    }

    public SyncDeltaBuilder setPreviousUid(Uid previousUid) {
        this.previousUid = previousUid;
        return this;
    }

    public ObjectClass getObjectClass() {
        return this.objectClass;
    }

    public SyncDeltaBuilder setObjectClass(ObjectClass objectClass) {
        this.objectClass = objectClass;
        return this;
    }

    public Uid getUid() {
        return this.uid;
    }

    public SyncDeltaBuilder setUid(Uid uid) {
        this.uid = uid;
        return this;
    }

    public ConnectorObject getObject() {
        return this.connectorObject;
    }

    public SyncDeltaBuilder setObject(ConnectorObject object) {
        this.connectorObject = object;
        if (object != null) {
            this.uid = object.getUid();
            this.objectClass = object.getObjectClass();
        }
        return this;
    }

    public SyncDelta build() {
        return new SyncDelta(this.syncToken, this.deltaType, this.previousUid, this.objectClass, this.uid, this.connectorObject);
    }
}

