/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.mfa.simple.validation;

import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.mfa.simple.CasSimpleMultifactorTokenCredential;
import org.apereo.cas.mfa.simple.ticket.CasSimpleMultifactorAuthenticationTicket;
import org.apereo.cas.mfa.simple.validation.CasSimpleMultifactorAuthenticationService;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCasSimpleMultifactorAuthenticationService
implements CasSimpleMultifactorAuthenticationService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseCasSimpleMultifactorAuthenticationService.class);
    protected final TicketRegistry ticketRegistry;

    @Override
    public CasSimpleMultifactorAuthenticationTicket getMultifactorAuthenticationTicket(CasSimpleMultifactorTokenCredential credential) {
        String tokenId = BaseCasSimpleMultifactorAuthenticationService.normalize(credential.getId());
        return (CasSimpleMultifactorAuthenticationTicket)this.ticketRegistry.getTicket(tokenId, CasSimpleMultifactorAuthenticationTicket.class);
    }

    protected Principal validateTokenForPrincipal(Principal resolvedPrincipal, CasSimpleMultifactorAuthenticationTicket acct) throws FailedLoginException {
        if (!acct.getProperties().containsKey("principal")) {
            LOGGER.warn("Unable to locate principal for token [{}]", (Object)acct.getId());
            this.deleteToken(acct);
            throw new FailedLoginException("Failed to authenticate code " + acct.getId());
        }
        Principal principal = (Principal)acct.getProperties().get("principal");
        if (!principal.equals((Object)resolvedPrincipal)) {
            LOGGER.warn("Principal assigned to token [{}] is unauthorized for token [{}]", (Object)principal.getId(), (Object)acct.getId());
            this.deleteToken(acct);
            throw new FailedLoginException("Failed to authenticate code " + acct.getId());
        }
        return principal;
    }

    protected static String normalize(String tokenId) {
        if (!tokenId.startsWith("CASMFA")) {
            return "CASMFA-" + tokenId;
        }
        return tokenId;
    }

    protected void deleteToken(CasSimpleMultifactorAuthenticationTicket acct) {
        FunctionUtils.doUnchecked(__ -> this.ticketRegistry.deleteTicket(acct.getId()), (Object[])new Object[0]);
    }

    @Generated
    public BaseCasSimpleMultifactorAuthenticationService(TicketRegistry ticketRegistry) {
        this.ticketRegistry = ticketRegistry;
    }
}

